/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it;

import com.xpn.xwiki.it.framework.AbstractValidationTest;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.URLEncoder;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.xwiki.validator.ValidationError;
import org.xwiki.validator.Validator;
import org.xwiki.validator.XHTMLValidator;

public class XHTMLValidationTest
extends AbstractValidationTest {
    private XHTMLValidator validator = new XHTMLValidator();
    protected PrintStream stdout;
    protected ByteArrayOutputStream out;
    protected PrintStream stderr;
    protected ByteArrayOutputStream err;

    public XHTMLValidationTest(String fullPageName, HttpClient client, Validator validator) throws Exception {
        super("testDocumentValidity");
        this.validator = (XHTMLValidator)validator;
        this.fullPageName = fullPageName;
        this.client = client;
    }

    protected void setUp() throws Exception {
        super.setUp();
        System.out.println(this.getName());
        this.stdout = System.out;
        this.out = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.out));
        this.stderr = System.err;
        this.err = new ByteArrayOutputStream();
        System.setErr(new PrintStream(this.err));
    }

    protected void tearDown() throws Exception {
        String output = this.out.toString();
        String errput = this.err.toString();
        System.setOut(this.stdout);
        System.out.print(output);
        System.setErr(this.stderr);
        System.err.print(errput);
        XHTMLValidationTest.assertFalse((String)"Errors found in the stdout output", (boolean)this.hasLogErrors(output));
        XHTMLValidationTest.assertFalse((String)"Warnings found in the stdout output", (boolean)this.hasLogWarnings(output));
        XHTMLValidationTest.assertFalse((String)"Errors found in the stderr output", (boolean)this.hasLogErrors(errput));
        XHTMLValidationTest.assertFalse((String)"Warnings found in the stderr output", (boolean)this.hasLogWarnings(errput));
        super.tearDown();
    }

    public String getName() {
        return "Validating XHTML validity for: " + this.fullPageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDocumentValidity() throws Exception {
        byte[] responseBody;
        GetMethod method = new GetMethod("http://127.0.0.1:8080/xwiki/bin/view/" + URLEncoder.encode(this.fullPageName, "UTF-8").replace('.', '/'));
        method.setDoAuthentication(true);
        method.setFollowRedirects(true);
        method.addRequestHeader("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])"Admin:admin".getBytes())));
        try {
            int statusCode = this.client.executeMethod((HttpMethod)method);
            XHTMLValidationTest.assertEquals((String)("Method failed: " + method.getStatusLine()), (int)200, (int)statusCode);
            responseBody = method.getResponseBody();
        }
        finally {
            method.releaseConnection();
        }
        this.validator.setDocument((InputStream)new ByteArrayInputStream(responseBody));
        List errors = this.validator.validate();
        StringBuffer message = new StringBuffer();
        message.append("Validation errors in " + this.fullPageName);
        boolean hasError = false;
        for (ValidationError error : errors) {
            if (error.getType() == ValidationError.Type.WARNING) {
                System.out.println("Warning at " + error.getLine() + ":" + error.getColumn() + " " + error.getMessage());
                continue;
            }
            message.append("\n" + error.toString() + " at line [" + error.getLine() + "] column [" + error.getColumn() + "]");
            hasError = true;
        }
        if (hasError) {
            System.err.println("");
            System.err.println("Validated content:");
            BufferedReader reader = new BufferedReader(new StringReader(new String(responseBody)));
            int index = 1;
            String line = reader.readLine();
            while (line != null) {
                System.err.println(index + "\t" + line);
                line = reader.readLine();
                ++index;
            }
        }
        XHTMLValidationTest.assertFalse((String)message.toString(), (boolean)hasError);
    }

    protected boolean hasLogErrors(String output) {
        return output.indexOf("ERROR") >= 0 || output.indexOf("ERR") >= 0;
    }

    protected boolean hasLogWarnings(String output) {
        return output.indexOf("WARNING") >= 0 || output.indexOf("WARN") >= 0;
    }
}

