/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it.framework;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xwiki.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractValidationTest
extends TestCase {
    protected HttpClient client;
    protected String fullPageName;

    public AbstractValidationTest(String name) {
        super(name);
    }

    public static Test suite(Class<? extends AbstractValidationTest> validationTest, Validator validator) throws Exception {
        TestSuite suite = new TestSuite();
        String path = System.getProperty("localRepository") + "/" + System.getProperty("pathToXWikiXar");
        String patternFilter = System.getProperty("documentsToTest");
        HttpClient client = new HttpClient();
        UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials("Admin", "admin");
        client.getState().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
        for (String pageName : AbstractValidationTest.readXarContents(path, patternFilter)) {
            suite.addTest((Test)validationTest.getConstructor(String.class, HttpClient.class, Validator.class).newInstance(pageName, client, validator));
        }
        return suite;
    }

    public static List<String> readXarContents(String fileName, String patternFilter) throws Exception {
        ZipEntry entry;
        FileInputStream fileIS = new FileInputStream(fileName);
        ZipInputStream zipIS = new ZipInputStream(fileIS);
        Document tocDoc = null;
        while ((entry = zipIS.getNextEntry()) != null) {
            if (entry.getName().compareTo("package.xml") != 0) continue;
            SAXReader reader = new SAXReader();
            tocDoc = reader.read((InputStream)zipIS);
            break;
        }
        if (tocDoc == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        Element filesElement = tocDoc.getRootElement().element("files");
        List fileElementList = filesElement.elements("file");
        for (Element el : fileElementList) {
            String docFullName = el.getStringValue();
            if (patternFilter != null && !docFullName.matches(patternFilter)) continue;
            result.add(docFullName);
        }
        return result;
    }
}

