/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it.selenium;

import com.xpn.xwiki.it.selenium.framework.AbstractWysiwygTestCase;
import com.xpn.xwiki.it.selenium.framework.AlbatrossSkinExecutor;
import com.xpn.xwiki.it.selenium.framework.XWikiTestSuite;
import junit.framework.Test;

public class LinkSupportTest
extends AbstractWysiwygTestCase {
    public static final String MENU_LINK = "Link";
    public static final String MENU_WEBPAGE = "Web page";
    public static final String MENU_EMAIL_ADDRESS = "Email address";
    public static final String MENU_WIKIPAGE = "Wiki page";
    public static final String MENU_ATTACHMENT = "Attached file";
    public static final String MENU_LINK_EDIT = "Edit link";
    public static final String MENU_LINK_REMOVE = "Remove link";

    public static Test suite() {
        XWikiTestSuite suite = new XWikiTestSuite("Tests insert link feature");
        suite.addTestSuite(LinkSupportTest.class, AlbatrossSkinExecutor.class);
        return suite;
    }

    public void testCreateLinkToExistingPage() {
        String linkLabel = "foo";
        this.typeText(linkLabel);
        this.selectAllContent();
        this.clickMenu(MENU_LINK);
        this.clickMenu(MENU_WIKIPAGE);
        this.waitForDialogToOpen();
        String selectedSpace = "Blog";
        String selectedPage = "AddCategory";
        this.typeInExplorerInput(selectedSpace + "." + selectedPage);
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cell\") and nobr=\"" + selectedSpace + "\"]');");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cellSelected\") and nobr=\"" + selectedPage + "\"]');");
        this.clickButtonWithText("Select");
        this.ensureStepIsLoaded("xLinkConfig");
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertWiki("[[" + linkLabel + ">>xwiki:" + selectedSpace + "." + selectedPage + "]]");
    }

    public void testCreateLinkToSpace() {
        String linkLabel = "foobar";
        this.typeText(linkLabel);
        this.selectAllContent();
        this.clickMenu(MENU_LINK);
        this.clickMenu(MENU_WIKIPAGE);
        this.waitForDialogToOpen();
        String space = "Blog";
        this.typeInExplorerInput(space + ".WebHome");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cell\") and nobr=\"" + space + "\"]');");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cellSelected\") and nobr=\"WebHome\"]');");
        this.clickButtonWithText("Select");
        this.ensureStepIsLoaded("xLinkConfig");
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertWiki("[[" + linkLabel + ">>xwiki:" + space + ".WebHome]]");
    }

    public void testCreateLinkToNewPage() {
        String linkLabel = "alice";
        String space = "Main";
        String newPageName = "AliceInWonderwiki";
        this.typeText(linkLabel);
        this.selectAllContent();
        this.clickMenu(MENU_LINK);
        this.clickMenu(MENU_WIKIPAGE);
        this.waitForDialogToOpen();
        this.typeInExplorerInput(space + "." + newPageName);
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cell\") and nobr=\"" + space + "\"]');");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cellSelected\") and nobr=\"New page...\"]');");
        this.clickButtonWithText("Select");
        this.ensureStepIsLoaded("xLinkConfig");
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertWiki("[[" + linkLabel + ">>xwiki:" + space + "." + newPageName + "]]");
    }

    public void testCreateLinkToNewPageInNewSpace() {
        String linkLabel = "bob";
        String newSpace = "Bob";
        String newPage = "Cat";
        this.typeText(linkLabel);
        this.selectAllContent();
        this.clickMenu(MENU_LINK);
        this.clickMenu(MENU_WIKIPAGE);
        this.waitForDialogToOpen();
        this.typeInExplorerInput(newSpace + "." + newPage);
        this.clickButtonWithText("Select");
        this.ensureStepIsLoaded("xLinkConfig");
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertWiki("[[" + linkLabel + ">>xwiki:" + newSpace + "." + newPage + "]]");
    }

    public void testCreateLinkToWebPage() {
        String linkLabel = "xwiki";
        String url = "http://www.xwiki.org";
        this.typeText(linkLabel);
        this.selectAllContent();
        this.clickMenu(MENU_LINK);
        this.clickMenu(MENU_WEBPAGE);
        this.waitForDialogToOpen();
        this.ensureStepIsLoaded("xLinkToUrl");
        this.typeInInput("Web page address", url);
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertWiki("[[" + linkLabel + ">>" + url + "]]");
    }

    public void testCreateLinkToWebPageWithChangedLabel() {
        String linkLabel = "rox";
        String url = "http://www.xwiki.org";
        this.typeText(linkLabel);
        this.selectAllContent();
        this.clickMenu(MENU_LINK);
        this.clickMenu(MENU_WEBPAGE);
        this.waitForDialogToOpen();
        this.ensureStepIsLoaded("xLinkToUrl");
        String newLabel = "xwiki rox";
        this.typeInInput("Label of the link to a web page", newLabel);
        this.typeInInput("Web page address", url);
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertWiki("[[" + newLabel + ">>" + url + "]]");
    }

    public void testCreateLinkToEmailAddress() {
        String linkLabel = "carol";
        String email = "mailto:carol@xwiki.org";
        this.typeText(linkLabel);
        this.selectAllContent();
        this.clickMenu(MENU_LINK);
        this.clickMenu(MENU_EMAIL_ADDRESS);
        this.waitForDialogToOpen();
        this.typeInInput(MENU_EMAIL_ADDRESS, email);
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertWiki("[[" + linkLabel + ">>" + email + "]]");
    }

    public void testCreateLinkToEmailAddressWithoutMailto() {
        String linkLabel = "joe le taxi";
        String email = "joe@xwiki.org";
        this.typeText(linkLabel);
        this.selectAllContent();
        this.clickMenu(MENU_LINK);
        this.clickMenu(MENU_EMAIL_ADDRESS);
        this.waitForDialogToOpen();
        this.typeInInput(MENU_EMAIL_ADDRESS, email);
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertWiki("[[" + linkLabel + "\n>>mailto:" + email + "]]");
    }

    public void testCreateLinkWithNewLabel() {
        String linkLabel = "xwiki";
        String linkURL = "www.xwiki.org";
        this.clickMenu(MENU_LINK);
        this.clickMenu(MENU_WEBPAGE);
        this.waitForDialogToOpen();
        this.typeInInput("Web page address", linkURL);
        this.typeInInput("Label of the link to a web page", linkLabel);
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertWiki("[[" + linkLabel + ">>http://" + linkURL + "]]");
    }

    public void testCreateLinkPreservesLabelFormatting() {
        this.typeText("our");
        this.clickBoldButton();
        this.typeText("xwiki");
        this.clickBoldButton();
        this.typeText("rox");
        this.selectAllContent();
        this.clickMenu(MENU_LINK);
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_WEBPAGE));
        this.clickMenu(MENU_WEBPAGE);
        this.waitForDialogToOpen();
        LinkSupportTest.assertEquals((String)"ourxwikirox", (String)this.getInputValue("Label of the link to a web page"));
        this.typeInInput("Web page address", "www.xwiki.org");
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertWiki("[[our**xwiki**rox>>http://www.xwiki.org]]");
    }

    public void testCreateThenEditLink() {
        this.applyStyleParagraph();
        this.typeText("this is ");
        String linkLabel = "xwiki";
        String linkURL = "http://www.xwiki.com";
        String newLinkURL = "http://www.xwiki.org";
        this.clickMenu(MENU_LINK);
        this.clickMenu(MENU_WEBPAGE);
        this.waitForDialogToOpen();
        this.typeInInput("Web page address", linkURL);
        this.typeInInput("Label of the link to a web page", linkLabel);
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertXHTML("<p>this is <!--startwikilink:http://www.xwiki.com--><span class=\"wikiexternallink\"><a href=\"http://www.xwiki.com\">xwiki</a></span><!--stopwikilink--><br class=\"spacer\"></p>");
        this.moveCaret("XWE.body.firstChild.childNodes[1].firstChild", 5);
        this.typeBackspace();
        this.typeText("i");
        this.clickMenu(MENU_LINK);
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_LINK_REMOVE));
        this.clickMenu(MENU_LINK_REMOVE);
        this.typeText(" which rox");
        this.assertWiki("this is [[" + linkLabel + ">>" + linkURL + "]] which rox");
        this.select("XWE.body.firstChild", 1, "XWE.body.firstChild.childNodes[1].firstChild", 5);
        this.clickMenu(MENU_LINK);
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_LINK_EDIT));
        this.clickMenu(MENU_LINK_EDIT);
        this.waitForDialogToOpen();
        LinkSupportTest.assertEquals((String)linkLabel, (String)this.getInputValue("Label of the link to a web page"));
        LinkSupportTest.assertEquals((String)linkURL, (String)this.getInputValue("Web page address"));
        this.typeInInput("Web page address", newLinkURL);
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertWiki("this is [[" + linkLabel + ">>" + newLinkURL + "]] which rox");
    }

    public void testCreateAndEditLinkOnImage() {
        this.applyStyleParagraph();
        this.clickInsertImageButton();
        String imageSpaceSelector = "//div[@class=\"xImageChooser\"]//select[2]";
        String imageSpace = "XWiki";
        this.waitForCondition("selenium.isElementPresent('" + imageSpaceSelector + "/option[@value=\"" + imageSpace + "\"]');");
        this.getSelenium().select(imageSpaceSelector, imageSpace);
        String imagePageSelector = "//div[@class=\"xImageChooser\"]//select[3]";
        String imagePage = "AdminSheet";
        this.waitForCondition("selenium.isElementPresent('" + imagePageSelector + "/option[@value=\"" + imagePage + "\"]');");
        this.getSelenium().select(imagePageSelector, imagePage);
        this.getSelenium().click("//div[@class=\"xImageChooser\"]//button[text()=\"Update\"]");
        String imageSelector = "//div[@class=\"xImagesContainerPanel\"]//img[@title=\"photos.png\"]";
        this.waitForCondition("selenium.isElementPresent('" + imageSelector + "');");
        this.getSelenium().click(imageSelector);
        this.getSelenium().click("//div[@class=\"xImageDialogMain\"]/button[text()=\"OK\"]");
        this.waitForCondition("!selenium.isElementPresent('//div[@class=\"xImageDialogMain\"]')");
        String pageName = "Photos";
        String spaceName = "Blog";
        String newSpaceName = "Main";
        String newPageName = "Dashboard";
        this.clickMenu(MENU_LINK);
        this.clickMenu(MENU_WIKIPAGE);
        this.waitForDialogToOpen();
        this.typeInExplorerInput(spaceName + "." + pageName);
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cell\") and nobr=\"" + spaceName + "\"]');");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cellSelected\") and nobr=\"New page...\"]');");
        this.clickButtonWithText("Select");
        this.ensureStepIsLoaded("xLinkConfig");
        LinkSupportTest.assertEquals((String)"photos.png", (String)this.getInputValue("Label of the created link"));
        this.assertElementPresent("//input[@title=\"Label of the created link\" and @readonly=\"\"]");
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertWiki("[[[[image:XWiki.AdminSheet@photos.png]]>>xwiki:Blog.Photos]]");
        this.moveCaret("XWE.body.firstChild", 1);
        this.typeText(" foo ");
        this.clickMenu(MENU_LINK);
        this.clickMenu(MENU_WEBPAGE);
        this.typeInInput("Label of the link to a web page", "bar");
        this.typeInInput("Web page address", "http://bar.myxwiki.org");
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.select("XWE.body.firstChild.firstChild", 0, "XWE.body.firstChild.firstChild", 1);
        this.clickMenu(MENU_LINK);
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_LINK_EDIT));
        this.clickMenu(MENU_LINK_EDIT);
        this.waitForDialogToOpen();
        LinkSupportTest.assertEquals((String)("xwiki:" + spaceName + "." + pageName), (String)this.getExplorerInputValue());
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cell\") and nobr=\"" + spaceName + "\"]');");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cellSelected\") and nobr=\"New page...\"]');");
        this.typeInExplorerInput(newSpaceName + "." + newPageName);
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cell\") and nobr=\"" + newSpaceName + "\"]');");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cellSelected\") and nobr=\"" + newPageName + "\"]');");
        this.clickButtonWithText("Select");
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertWiki("[[[[image:XWiki.AdminSheet@photos.png]]>>xwiki:" + newSpaceName + "." + newPageName + "]] foo [[bar>>http://bar.myxwiki.org]]");
    }

    public void testDetectAndUnlinkSelectedAnchor() {
        this.setWikiContent("foo [[bar>>http://xwiki.org]] [[far>>Main.WebHome]] [[alice>>Main.NewPage]] [[carol>>mailto:carol@xwiki.org]] [[b**o**b>>http://xwiki.org]] blog webhome [[Blog.WebHome]] [[image:XWiki.AdminSheet@photos.png>>Blog.Photos]]");
        this.moveCaret("XWE.body.firstChild.firstChild", 2);
        this.clickMenu(MENU_LINK);
        LinkSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_LINK_REMOVE));
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_WIKIPAGE));
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_WEBPAGE));
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_EMAIL_ADDRESS));
        this.moveCaret("XWE.body.firstChild.childNodes[1].firstChild", 2);
        this.clickMenu(MENU_LINK);
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_LINK_EDIT));
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_LINK_REMOVE));
        this.clickMenu(MENU_LINK_REMOVE);
        this.select("XWE.body.firstChild", 3, "XWE.body.firstChild", 4);
        this.clickMenu(MENU_LINK);
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_LINK_EDIT));
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_LINK_REMOVE));
        this.clickMenu(MENU_LINK_REMOVE);
        this.select("XWE.body.firstChild.childNodes[4]", 1, "XWE.body.firstChild.childNodes[6]", 0);
        this.clickMenu(MENU_LINK);
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_LINK_EDIT));
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_LINK_REMOVE));
        this.clickMenu(MENU_LINK_REMOVE);
        this.select("XWE.body.firstChild.childNodes[6]", 1, "XWE.body.firstChild.childNodes[7].firstChild", 5);
        this.clickMenu(MENU_LINK);
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_LINK_EDIT));
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_LINK_REMOVE));
        this.clickMenu(MENU_LINK_REMOVE);
        this.select("XWE.body.firstChild.childNodes[9].childNodes[1].firstChild", 0, "XWE.body.firstChild.childNodes[9].childNodes[1].firstChild", 1);
        this.clickMenu(MENU_LINK);
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_LINK_EDIT));
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_LINK_REMOVE));
        this.clickMenu(MENU_LINK_REMOVE);
        this.select("XWE.body.firstChild.childNodes[12]", 5, "XWE.body.firstChild.childNodes[13].firstChild.firstChild", 4);
        this.clickMenu(MENU_LINK);
        LinkSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_LINK_EDIT));
        LinkSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_LINK_REMOVE));
        LinkSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_WEBPAGE));
        LinkSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_EMAIL_ADDRESS));
        LinkSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_WIKIPAGE));
        this.select("XWE.body.firstChild.childNodes[13].firstChild.firstChild", 4, "XWE.body.firstChild.childNodes[15]", 1);
        this.clickMenu(MENU_LINK);
        LinkSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_LINK_EDIT));
        LinkSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_LINK_REMOVE));
        LinkSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_WEBPAGE));
        LinkSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_EMAIL_ADDRESS));
        LinkSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_WIKIPAGE));
        this.assertWiki("foo bar far alice carol b**o**b blog webhome [[Blog.WebHome]] [[image:XWiki.AdminSheet@photos.png>>Blog.Photos]]");
    }

    public void testEditLinkInList() {
        this.setWikiContent("* one\n* [[two>>http://www.xwiki.com]]\n** three");
        this.moveCaret("XWE.body.firstChild.childNodes[1].firstChild.firstChild", 1);
        this.clickMenu(MENU_LINK);
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_LINK_EDIT));
        this.clickMenu(MENU_LINK_EDIT);
        this.waitForDialogToOpen();
        this.ensureStepIsLoaded("xLinkToUrl");
        LinkSupportTest.assertEquals((String)"two", (String)this.getInputValue("Label of the link to a web page"));
        LinkSupportTest.assertEquals((String)"http://www.xwiki.com", (String)this.getInputValue("Web page address"));
        this.typeInInput("Web page address", "http://www.xwiki.org");
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertWiki("* one\n* [[two>>http://www.xwiki.org]]\n** three");
    }

    public void testValidationOnLinkInsert() {
        this.clickMenu(MENU_LINK);
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_WIKIPAGE));
        this.clickMenu(MENU_WIKIPAGE);
        this.waitForDialogToOpen();
        String space = "Main";
        String page = "WebHome";
        this.typeInExplorerInput(space + "." + page);
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cell\") and nobr=\"" + space + "\"]');");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cellSelected\") and nobr=\"" + page + "\"]');");
        this.clickButtonWithText("Select");
        this.ensureStepIsLoaded("xLinkConfig");
        this.clickButtonWithText("Create Link");
        LinkSupportTest.assertTrue((boolean)this.getSelenium().isAlertPresent());
        LinkSupportTest.assertEquals((String)"The label of the link cannot be empty", (String)this.getSelenium().getAlert());
        this.waitForDialogToOpen();
        this.ensureStepIsLoaded("xLinkConfig");
        this.typeInInput("Label of the created link", "foo");
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertWiki("[[foo>>xwiki:" + space + "." + page + "]]");
        this.resetContent();
        this.clickMenu(MENU_LINK);
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_WIKIPAGE));
        this.clickMenu(MENU_WIKIPAGE);
        this.waitForDialogToOpen();
        space = "Main";
        page = "NewPage";
        this.typeInExplorerInput(space + "." + page);
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cell\") and nobr=\"" + space + "\"]');");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cellSelected\") and nobr=\"New page...\"]');");
        this.clickButtonWithText("Select");
        this.ensureStepIsLoaded("xLinkConfig");
        this.clickButtonWithText("Create Link");
        LinkSupportTest.assertTrue((boolean)this.getSelenium().isAlertPresent());
        LinkSupportTest.assertEquals((String)"The label of the link cannot be empty", (String)this.getSelenium().getAlert());
        this.waitForDialogToOpen();
        this.ensureStepIsLoaded("xLinkConfig");
        this.typeInInput("Label of the created link", "foo");
        this.clickButtonWithText("Create Link");
        this.assertWiki("[[foo>>xwiki:Main.NewPage]]");
        this.resetContent();
        this.clickMenu(MENU_LINK);
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_WEBPAGE));
        this.clickMenu(MENU_WEBPAGE);
        this.waitForDialogToOpen();
        this.typeInInput("Web page address", "http://www.xwiki.org");
        this.clickButtonWithText("Create Link");
        LinkSupportTest.assertTrue((boolean)this.getSelenium().isAlertPresent());
        LinkSupportTest.assertEquals((String)"The label of the link cannot be empty", (String)this.getSelenium().getAlert());
        this.waitForDialogToOpen();
        this.ensureStepIsLoaded("xLinkToUrl");
        this.typeInInput("Label of the link to a web page", "xwiki");
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertWiki("[[xwiki>>http://www.xwiki.org]]");
        this.resetContent();
        this.clickMenu(MENU_LINK);
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_EMAIL_ADDRESS));
        this.clickMenu(MENU_EMAIL_ADDRESS);
        this.waitForDialogToOpen();
        this.clickButtonWithText("Create Link");
        LinkSupportTest.assertTrue((boolean)this.getSelenium().isAlertPresent());
        LinkSupportTest.assertEquals((String)"The label of the link cannot be empty", (String)this.getSelenium().getAlert());
        this.waitForDialogToOpen();
        this.ensureStepIsLoaded("xLinkToUrl");
        this.typeInInput("Label of the link to an email address", "alice");
        this.clickButtonWithText("Create Link");
        LinkSupportTest.assertTrue((boolean)this.getSelenium().isAlertPresent());
        LinkSupportTest.assertEquals((String)"The email address was not set", (String)this.getSelenium().getAlert());
        this.waitForDialogToOpen();
        this.ensureStepIsLoaded("xLinkToUrl");
        this.typeInInput(MENU_EMAIL_ADDRESS, "alice@wonderla.nd");
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertWiki("[[alice>>mailto:alice@wonderla.nd]]");
    }

    public void testCannotCreateLinkAroundBlockElements() {
        this.applyStyleParagraph();
        this.typeText("foo");
        this.typeEnter(2);
        this.typeText("bar");
        this.assertXHTML("<p>foo</p><p>bar<br class=\"spacer\"></p>");
        this.select("XWE.body.firstChild.firstChild", 2, "XWE.body.childNodes[1].firstChild", 2);
        this.clickMenu(MENU_LINK);
        LinkSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_WEBPAGE));
        LinkSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_WIKIPAGE));
        LinkSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_EMAIL_ADDRESS));
        LinkSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_LINK_EDIT));
        LinkSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_LINK_REMOVE));
    }

    public void testLinkLocationIsPreservedOnPrevious() {
        String linkLabel = "foo";
        this.typeText(linkLabel);
        this.selectAllContent();
        this.clickMenu(MENU_LINK);
        this.clickMenu(MENU_WIKIPAGE);
        this.waitForDialogToOpen();
        String selectedSpace = "Blog";
        String selectedPage = "AddCategory";
        String changedSpace = "Main";
        String changedPage = "RecentChanges";
        this.typeInExplorerInput(selectedSpace + "." + selectedPage);
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cell\") and nobr=\"" + selectedSpace + "\"]');");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cellSelected\") and nobr=\"" + selectedPage + "\"]');");
        this.clickButtonWithText("Select");
        this.ensureStepIsLoaded("xLinkConfig");
        this.clickButtonWithText("Previous");
        this.ensureStepIsLoaded("xExplorerPanel");
        LinkSupportTest.assertEquals((String)("xwiki:" + selectedSpace + "." + selectedPage), (String)this.getExplorerInputValue());
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cell\") and nobr=\"" + selectedSpace + "\"]');");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cellSelected\") and nobr=\"" + selectedPage + "\"]');");
        this.typeInExplorerInput(changedSpace + "." + changedPage);
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cell\") and nobr=\"" + changedSpace + "\"]');");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cellSelected\") and nobr=\"" + changedPage + "\"]');");
        this.clickButtonWithText("Select");
        this.ensureStepIsLoaded("xLinkConfig");
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertWiki("[[" + linkLabel + ">>xwiki:" + changedSpace + "." + changedPage + "]]");
    }

    public void testCreateLinkToAttachment() {
        String linkLabel = "boo";
        this.typeText(linkLabel);
        this.selectAllContent();
        this.clickMenu(MENU_LINK);
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_ATTACHMENT));
        this.clickMenu(MENU_ATTACHMENT);
        this.waitForDialogToOpen();
        String attachSpace = "Main";
        String attachPage = "RecentChanges";
        String attachment = "lquo.gif";
        this.typeInExplorerInput(attachSpace + "." + attachPage + "@" + attachment);
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cell\") and nobr=\"" + attachSpace + "\"]');");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cell\") and nobr=\"" + attachPage + "\"]');");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cellSelected\") and nobr=\"" + attachment + "\"]');");
        this.clickButtonWithText("Select");
        this.ensureStepIsLoaded("xLinkConfig");
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertWiki("[[" + linkLabel + ">>attach:" + attachSpace + "." + attachPage + "@" + attachment + "]]");
    }

    public void testCreateLinkToAttachmentWithParameters() {
        String linkLabel = "rquo";
        String linkTooltip = "Right quote image";
        this.clickMenu(MENU_LINK);
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_ATTACHMENT));
        this.clickMenu(MENU_ATTACHMENT);
        this.waitForDialogToOpen();
        String attachSpace = "Main";
        String attachPage = "RecentChanges";
        String attachment = "rquo.gif";
        this.typeInExplorerInput(attachSpace + "." + attachPage + "@" + attachment);
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cell\") and nobr=\"" + attachSpace + "\"]');");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cell\") and nobr=\"" + attachPage + "\"]');");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cellSelected\") and nobr=\"" + attachment + "\"]');");
        this.clickButtonWithText("Select");
        this.ensureStepIsLoaded("xLinkConfig");
        this.typeInInput("Label of the created link", linkLabel);
        this.typeInInput("Tooltip of the created link, which will appear when mouse is over the link", linkTooltip);
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertWiki("[[" + linkLabel + ">>attach:" + attachSpace + "." + attachPage + "@" + attachment + "||title=\"" + linkTooltip + "\"]]");
    }

    public void testValidationOnLinkToAttachment() {
        String linkLabel = "boo";
        this.clickMenu(MENU_LINK);
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_ATTACHMENT));
        this.clickMenu(MENU_ATTACHMENT);
        this.waitForDialogToOpen();
        String attachSpace = "Main";
        String attachPage = "RecentChanges";
        String attachment = "lquo.gif";
        this.typeInExplorerInput(attachSpace + "." + attachPage);
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cell\") and nobr=\"" + attachSpace + "\"]');");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cellSelected\") and nobr=\"" + attachPage + "\"]');");
        this.clickButtonWithText("Select");
        LinkSupportTest.assertTrue((boolean)this.getSelenium().isAlertPresent());
        LinkSupportTest.assertEquals((String)"No attachment was selected", (String)this.getSelenium().getAlert());
        this.ensureStepIsLoaded("xExplorerPanel");
        this.typeInExplorerInput(attachSpace + "." + attachPage + "@" + attachment);
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cell\") and nobr=\"" + attachSpace + "\"]');");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cell\") and nobr=\"" + attachPage + "\"]');");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cellSelected\") and nobr=\"" + attachment + "\"]');");
        this.clickButtonWithText("Select");
        this.ensureStepIsLoaded("xLinkConfig");
        this.clickButtonWithText("Create Link");
        LinkSupportTest.assertTrue((boolean)this.getSelenium().isAlertPresent());
        LinkSupportTest.assertEquals((String)"The label of the link cannot be empty", (String)this.getSelenium().getAlert());
        this.ensureStepIsLoaded("xLinkConfig");
        this.typeInInput("Label of the created link", linkLabel);
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertWiki("[[" + linkLabel + ">>attach:" + attachSpace + "." + attachPage + "@" + attachment + "]]");
    }

    public void testEditLinkToAttachment() {
        this.setWikiContent("[[foobar>>attach:Main.RecentChanges@lquo.gif]]");
        this.moveCaret("XWE.body.firstChild.firstChild", 2);
        this.moveCaret("XWE.body.firstChild.firstChild.firstChild", 3);
        this.clickMenu(MENU_LINK);
        LinkSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_LINK_EDIT));
        this.clickMenu(MENU_LINK_EDIT);
        this.waitForDialogToOpen();
        this.ensureStepIsLoaded("xExplorerPanel");
        LinkSupportTest.assertEquals((String)"Main.RecentChanges@lquo.gif", (String)this.getExplorerInputValue());
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cell\") and nobr=\"Main\"]');");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cell\") and nobr=\"RecentChanges\"]');");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cellSelected\") and nobr=\"lquo.gif\"]');");
        this.typeInExplorerInput("XWiki.AdminSheet@photos.png");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cell\") and nobr=\"XWiki\"]');");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cell\") and nobr=\"AdminSheet\"]');");
        this.waitForCondition("selenium.isElementPresent('//td[contains(@class, \"cellSelected\") and nobr=\"photos.png\"]');");
        this.clickButtonWithText("Select");
        this.ensureStepIsLoaded("xLinkConfig");
        this.clickButtonWithText("Create Link");
        this.waitForDialogToClose();
        this.assertWiki("[[foobar>>attach:XWiki.AdminSheet@photos.png]]");
    }

    protected void ensureStepIsLoaded(String divClass) {
        this.waitForCondition("selenium.isElementPresent('//div[contains(@class, \"" + divClass + "\")]');");
    }

    protected void typeInExplorerInput(String text) {
        this.getSelenium().type("//div[contains(@class, 'xExplorerPanel')]/input", text);
    }

    protected String getExplorerInputValue() {
        return this.getSelenium().getValue("//div[contains(@class, 'xExplorerPanel')]/input");
    }
}

