/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it.selenium;

import com.xpn.xwiki.it.selenium.framework.AbstractWysiwygTestCase;
import com.xpn.xwiki.it.selenium.framework.AlbatrossSkinExecutor;
import com.xpn.xwiki.it.selenium.framework.XWikiTestSuite;
import junit.framework.Test;

public class MacroSupportTest
extends AbstractWysiwygTestCase {
    public static final String MENU_MACRO = "Macro";
    public static final String MENU_REFRESH = "Refresh";
    public static final String MENU_COLLAPSE = "Collapse";
    public static final String MENU_COLLAPSE_ALL = "Collapse All";
    public static final String MENU_EXPAND = "Expand";
    public static final String MENU_EXPAND_ALL = "Expand All";
    public static final String MENU_EDIT = "Edit Macro Properties...";
    public static final String MENU_INSERT = "Insert Macro...";

    public static Test suite() {
        XWikiTestSuite suite = new XWikiTestSuite("Integration tests for macro support inside the WYSIWYG editor.");
        suite.addTestSuite(MacroSupportTest.class, AlbatrossSkinExecutor.class);
        return suite;
    }

    public void testDeleteCharacterBeforeMacro() {
        this.setWikiContent("a{{html}}b{{/html}}");
        this.typeDelete();
        this.typeText("x");
        this.assertWiki("x{{html}}b{{/html}}");
    }

    public void testHoldDeleteKeyBeforeMacro() {
        this.setWikiContent("c{{html}}def{{/html}}g");
        this.typeDelete(2, true);
        this.typeText("x");
        this.assertWiki("xg");
    }

    public void testSelectCharacterBeforeMacroAndPressBackspace() {
        this.setWikiContent("g{{html}}h{{/html}}");
        this.selectNode("XWE.body.firstChild.firstChild");
        this.typeBackspace();
        this.typeText("x");
        this.assertWiki("x{{html}}h{{/html}}");
    }

    public void testSelectCharacterBeforeMacroAndInsertSymbol() {
        this.setWikiContent("i{{html}}j{{/html}}");
        this.selectNode("XWE.body.firstChild.firstChild");
        this.clickSymbolButton();
        this.getSelenium().click("//div[@title='copyright sign']");
        this.typeText("x");
        this.assertWiki("\u00a9x{{html}}j{{/html}}");
    }

    public void testPressDeleteJustBeforeMacro() {
        this.setWikiContent("{{html}}k{{/html}}l");
        this.typeDelete();
        this.typeText("x");
        this.assertWiki("xl");
    }

    public void testDeleteCharacterAfterMacro() {
        this.setWikiContent("a{{html}}b{{/html}}c");
        this.moveCaret("XWE.body.firstChild.lastChild", 1);
        this.typeBackspace();
        this.typeText("x");
        this.assertWiki("a{{html}}b{{/html}}x");
    }

    public void testHoldBackspaceKeyAfterMacro() {
        this.setWikiContent("c{{html}}def{{/html}}g");
        this.moveCaret("XWE.body.firstChild.lastChild", 1);
        this.typeBackspace(2, true);
        this.typeText("x");
        this.assertWiki("cx");
    }

    public void testSelectCharacterAfterMacroAndPressDelete() {
        this.setWikiContent("g{{html}}h{{/html}}i");
        this.selectNode("XWE.body.firstChild.lastChild");
        this.typeDelete();
        this.typeText("x");
        this.assertWiki("g{{html}}h{{/html}}x");
    }

    public void testSelectCharacterAfterMacroAndInsertSymbol() {
        this.setWikiContent("i{{html}}j{{/html}}k");
        this.selectNode("XWE.body.firstChild.lastChild");
        this.clickSymbolButton();
        this.getSelenium().click("//div[@title='copyright sign']");
        this.typeText("x");
        this.assertWiki("i{{html}}j{{/html}}\u00a9x");
    }

    public void testPressBackspaceJustAfterMacro() {
        this.setWikiContent("k{{html}}l{{/html}}m");
        this.moveCaret("XWE.body.firstChild.lastChild", 0);
        this.typeBackspace();
        this.typeText("x");
        this.assertWiki("kxm");
    }

    public void testUndoRedoWhenMacrosArePresent() {
        this.setWikiContent("{{html}}pq{{/html}}");
        this.applyStyleParagraph();
        this.typeText("uv");
        this.clickUndoButton();
        this.clickRedoButton();
        this.assertWiki("uv{{html}}pq{{/html}}");
    }

    public void testSelectAndDeleteMacro() {
        this.setWikiContent("{{html}}<p>foo</p>{{/html}}\n\nbar");
        this.getSelenium().clickAt(this.getDOMLocator("getElementsByTagName('button')[0]"), "0, 0");
        this.typeDelete();
        this.assertWiki("bar");
    }

    public void testWhiteSpacesInsideCodeMacroArePreserved() {
        String wikiText = "{{code}}\nfunction foo() {\n    alert('bar');\n}\n{{/code}}";
        this.setWikiContent(wikiText);
        this.assertWiki(wikiText);
    }

    public void testCollapseAndExpandAllMacros() {
        this.typeText("no macro");
        this.clickMenu(MENU_MACRO);
        MacroSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_REFRESH));
        MacroSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_COLLAPSE_ALL));
        MacroSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_EXPAND_ALL));
        this.closeMenuContaining(MENU_REFRESH);
        this.setWikiContent("k\n\n{{html}}l{{/html}}\n\nm\n\n{{code}}n{{/code}}\n\no");
        this.clickMenu(MENU_MACRO);
        MacroSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_COLLAPSE_ALL));
        MacroSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_EXPAND_ALL));
        this.clickMenu(MENU_COLLAPSE_ALL);
        this.clickMenu(MENU_MACRO);
        MacroSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_COLLAPSE_ALL));
        MacroSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_EXPAND_ALL));
        this.clickMenu(MENU_EXPAND_ALL);
        this.clickMenu(MENU_MACRO);
        MacroSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_COLLAPSE_ALL));
        MacroSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_EXPAND_ALL));
        this.closeMenuContaining(MENU_REFRESH);
        this.clickMacro(0);
        this.clickMacro(0);
        this.runScript("XWE.selection.collapseToEnd()");
        this.triggerToolbarUpdate();
        this.clickMenu(MENU_MACRO);
        MacroSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_COLLAPSE_ALL));
        MacroSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_EXPAND_ALL));
    }

    public void testCollapseAndExpandSelectedMacros() {
        this.setWikiContent("o\n\n{{html}}n{{/html}}\n\nm\n\n{{code}}l{{/code}}\n\nk");
        this.clickMenu(MENU_MACRO);
        MacroSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_REFRESH));
        MacroSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_COLLAPSE));
        MacroSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_EXPAND));
        this.closeMenuContaining(MENU_REFRESH);
        this.clickMacro(0);
        this.clickMenu(MENU_MACRO);
        MacroSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_COLLAPSE));
        MacroSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_EXPAND));
        this.clickMenu(MENU_COLLAPSE);
        this.clickMenu(MENU_MACRO);
        MacroSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_COLLAPSE));
        MacroSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_EXPAND));
        this.clickMenu(MENU_EXPAND);
        this.getSelenium().controlKeyDown();
        this.clickMacro(1);
        this.getSelenium().controlKeyUp();
        this.clickMenu(MENU_MACRO);
        MacroSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_COLLAPSE));
        MacroSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_EXPAND));
        this.clickMenu(MENU_COLLAPSE);
        this.clickMenu(MENU_MACRO);
        MacroSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_COLLAPSE));
        MacroSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_EXPAND));
        this.clickMenu(MENU_EXPAND);
        this.clickMenu(MENU_MACRO);
        MacroSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_COLLAPSE));
        MacroSupportTest.assertFalse((boolean)this.isMenuEnabled(MENU_EXPAND));
        this.closeMenuContaining(MENU_COLLAPSE);
    }

    public void testClickToSelectMacroAndToggleCollapse() {
        this.setWikiContent("{{foo}}bar{{/foo}}");
        MacroSupportTest.assertFalse((boolean)this.getSelenium().isVisible(this.getMacroPlaceHolderLocator(0)));
        MacroSupportTest.assertTrue((boolean)this.getSelenium().isVisible(this.getMacroOutputLocator(0)));
        this.clickMacro(0);
        this.clickMacro(0);
        MacroSupportTest.assertTrue((boolean)this.getSelenium().isVisible(this.getMacroPlaceHolderLocator(0)));
        MacroSupportTest.assertFalse((boolean)this.getSelenium().isVisible(this.getMacroOutputLocator(0)));
        this.clickMacro(0);
        MacroSupportTest.assertFalse((boolean)this.getSelenium().isVisible(this.getMacroPlaceHolderLocator(0)));
        MacroSupportTest.assertTrue((boolean)this.getSelenium().isVisible(this.getMacroOutputLocator(0)));
    }

    public void testRefreshContentWithoutMacros() {
        this.typeText("a b");
        this.assertXHTML("a b<br class=\"spacer\">");
        this.refreshMacros();
        this.assertXHTML("<p>a b</p>");
    }

    public void testRefreshMacros() {
        this.setWikiContent("{{box}}p{{/box}}\n\n{{code}}q{{/code}}");
        MacroSupportTest.assertFalse((boolean)this.getSelenium().isVisible(this.getMacroPlaceHolderLocator(1)));
        MacroSupportTest.assertTrue((boolean)this.getSelenium().isVisible(this.getMacroOutputLocator(1)));
        this.clickMacro(1);
        this.clickMacro(1);
        MacroSupportTest.assertTrue((boolean)this.getSelenium().isVisible(this.getMacroPlaceHolderLocator(1)));
        MacroSupportTest.assertFalse((boolean)this.getSelenium().isVisible(this.getMacroOutputLocator(1)));
        this.runScript("XWE.selection.collapseToEnd()");
        this.triggerToolbarUpdate();
        this.refreshMacros();
        MacroSupportTest.assertFalse((boolean)this.getSelenium().isVisible(this.getMacroPlaceHolderLocator(1)));
        MacroSupportTest.assertTrue((boolean)this.getSelenium().isVisible(this.getMacroOutputLocator(1)));
    }

    public void testRefreshTocMacro() {
        this.setWikiContent("{{toc start=\"1\"/}}\n\n= Title 1\n\n== Title 2");
        String listItemCountExpression = "window." + this.getDOMLocator("getElementsByTagName('li')") + ".length";
        MacroSupportTest.assertEquals((String)"2", (String)this.getSelenium().getEval(listItemCountExpression));
        this.moveCaret(this.getDOMLocator("getElementsByTagName('h2')[0].firstChild.firstChild"), 7);
        this.typeEnter(2);
        this.typeText("Title 3");
        this.applyStyleTitle3();
        this.refreshMacros();
        MacroSupportTest.assertEquals((String)"3", (String)this.getSelenium().getEval(listItemCountExpression));
    }

    public void testEditHTMLMacro() {
        this.setWikiContent("{{html}}white{{/html}}");
        this.editMacro(0);
        this.setFieldValue("pd-content-input", "black");
        this.getSelenium().select("pd-wiki-input", "yes");
        this.applyMacroChanges();
        this.assertWiki("{{html wiki=\"true\"}}black{{/html}}");
        this.editMacro(0);
        MacroSupportTest.assertEquals((String)"true", (String)this.getSelenium().getValue("pd-wiki-input"));
        this.getSelenium().select("pd-wiki-input", "no");
        this.applyMacroChanges();
        this.assertWiki("{{html}}black{{/html}}");
    }

    public void testEditMacroWithSpecialCharactersInParameterValues() {
        this.setWikiContent("{{box title =  \"1\\\"2|-|3=\\\\\\\"4\\\\\" }}=\\\"|-|\\\\{{/box}}");
        this.editMacro(0);
        MacroSupportTest.assertEquals((String)"=\\\"|-|\\\\", (String)this.getSelenium().getValue("pd-content-input"));
        MacroSupportTest.assertEquals((String)"1\"2|-|3=\\\"4\\", (String)this.getSelenium().getValue("pd-title-input"));
        this.setFieldValue("pd-title-input", "a\"b|-|c=\\\"d\\");
        this.applyMacroChanges();
        this.assertWiki("{{box title=\"a\\\"b|-|c=\\\\\\\"d\\\\\"}}=\\\"|-|\\\\{{/box}}");
    }

    public void testEditUnregisteredMacro() {
        this.setWikiContent("{{foo}}bar{{/foo}}");
        this.editMacro(0);
        MacroSupportTest.assertTrue((boolean)this.getSelenium().isVisible("//div[@class = 'xDialogBody']/div[contains(@class, 'errormessage')]"));
    }

    public void testUndoMacroEdit() {
        this.setWikiContent("{{velocity}}$context.user{{/velocity}}");
        this.editMacro(0);
        this.setFieldValue("pd-content-input", "$util.date");
        this.applyMacroChanges();
        this.editMacro(0);
        this.setFieldValue("pd-content-input", "$xwiki.version");
        this.applyMacroChanges();
        this.clickUndoButton(2);
        this.clickRedoButton();
        this.assertWiki("{{velocity}}$util.date{{/velocity}}");
    }

    public void testInsertCodeMacro() {
        this.insertMacro("code");
        this.setFieldValue("pd-content-input", "function f(x) {\n  return x;\n}");
        this.applyMacroChanges();
        this.editMacro(0);
        this.setFieldValue("pd-title-input", "Identity function");
        this.applyMacroChanges();
        this.assertWiki("{{code title=\"Identity function\"}}function f(x) {\n  return x;\n}{{/code}}");
    }

    public void testInsertTOCMacro() {
        this.typeText("Title 1");
        this.applyStyleTitle1();
        this.typeEnter(2);
        this.typeText("Title 2");
        this.applyStyleTitle2();
        this.moveCaret("XWE.body.getElementsByTagName('h1')[0].firstChild", 7);
        this.typeEnter(2);
        this.insertMacro("toc");
        this.setFieldValue("pd-start-input", "2");
        this.applyMacroChanges();
        MacroSupportTest.assertEquals((String)"1", (String)this.getSelenium().getEval("window." + this.getDOMLocator("getElementsByTagName('li')") + ".length"));
        this.assertWiki("= Title 1 =\n\n{{toc/}}\n\n== Title 2 ==");
    }

    public void testInsertHTMLMacroWithBlockContentInANotEmptyParagraph() {
        this.typeText("beforeafter");
        this.applyStyleParagraph();
        this.moveCaret("XWE.body.firstChild.firstChild", 6);
        this.insertMacro("html");
        this.setFieldValue("pd-content-input", "<ul><li>xwiki</li></ul>");
        this.applyMacroChanges();
        String listItemCountExpression = "window." + this.getDOMLocator("getElementsByTagName('li')") + ".length";
        MacroSupportTest.assertEquals((String)"0", (String)this.getSelenium().getEval(listItemCountExpression));
        this.moveCaret("XWE.body.firstChild.firstChild", 6);
        this.typeEnter(2);
        this.moveCaret("XWE.body.lastChild.lastChild", 0);
        this.typeEnter(2);
        this.refreshMacros();
        MacroSupportTest.assertEquals((String)"1", (String)this.getSelenium().getEval(listItemCountExpression));
        this.assertWiki("before\n\n{{html}}<ul><li>xwiki</li></ul>{{/html}}\n\nafter");
    }

    public String getMacroLocator(int index) {
        return this.getDOMLocator("getElementsByTagName('button')[" + index + "]");
    }

    public String getMacroPlaceHolderLocator(int index) {
        return this.getMacroLocator(index) + ".childNodes[1]";
    }

    public String getMacroOutputLocator(int index) {
        return this.getMacroLocator(index) + ".childNodes[2]";
    }

    public void waitForRefresh() {
        this.waitForCondition("window.document.getElementsByTagName('iframe')[0].previousSibling.className == 'xToolbar'");
    }

    public void clickMacro(int index) {
        String locator = this.getMacroLocator(index);
        this.getSelenium().mouseOver(locator);
        this.getSelenium().mouseMove(locator);
        this.getSelenium().mouseDown(locator);
        this.getSelenium().mouseUp(locator);
        this.getSelenium().click(locator);
        this.getSelenium().mouseMove(locator);
        this.getSelenium().mouseOut(locator);
    }

    public void editMacro(int index) {
        this.clickMacro(index);
        this.clickMenu(MENU_MACRO);
        this.clickMenu(MENU_EDIT);
        this.waitForDialogToOpen();
    }

    public void insertMacro(String macroName) {
        this.clickMenu(MENU_MACRO);
        MacroSupportTest.assertTrue((boolean)this.isMenuEnabled(MENU_INSERT));
        this.clickMenu(MENU_INSERT);
        this.waitForDialogToOpen();
        this.getSelenium().click("//div[@class = 'xListBox']//div[text() = '" + macroName + "']");
        this.getSelenium().click("//div[@class = 'xDialogFooter']/button[text() = 'Select']");
        this.waitForDialogToOpen();
    }

    public void applyMacroChanges() {
        this.getSelenium().click("//div[@class = 'xDialogFooter']/button[text() = 'Apply']");
        this.waitForRefresh();
    }

    public void refreshMacros() {
        this.clickMenu(MENU_MACRO);
        this.clickMenu(MENU_REFRESH);
        this.waitForRefresh();
    }
}

