/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it.selenium.framework;

import com.xpn.xwiki.it.selenium.framework.AbstractXWikiTestCase;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Assert;
import org.apache.commons.logging.LogFactory;

public class AbstractWysiwygTestCase
extends AbstractXWikiTestCase {
    private static final String WYSIWYG_LOCATOR_FOR_KEY_EVENTS = "document.getElementsByTagName('iframe').item(0).contentDocument.documentElement";
    private static final String WYSIWYG_LOCATOR_FOR_HTML_CONTENT = "content";
    private static final String XWINDOWFOCUS_BINARY = "/home/maven/xwindowfocus";

    private void externalX11WindowFocus() throws Exception {
        if (new File(XWINDOWFOCUS_BINARY).exists()) {
            ProcessBuilder pb = new ProcessBuilder(XWINDOWFOCUS_BINARY, "Editing wysiwyg for WysiwygTest - Mozilla Firefox");
            pb.environment().put("DISPLAY", ":1.0");
            Process shell = pb.start();
            new StreamRedirector(shell.getInputStream(), System.out).start();
            new StreamRedirector(shell.getErrorStream(), System.err).start();
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.loginAsAdmin();
        if (!this.getSelenium().getLocation().equals("http://localhost:8080/xwiki/bin/edit/Main/WysiwygTest?editor=wysiwyg")) {
            this.open("Main", "WysiwygTest");
            this.clickLinkWithText("WYSIWYG");
        }
        if (!this.getSelenium().getValue("syntaxId").equals("xwiki/2.0")) {
            this.clickLinkWithText("Wiki");
            this.setFieldValue("syntaxId", "xwiki/2.0");
            this.clickEditSaveAndContinue();
            this.clickLinkWithText("WYSIWYG");
        }
        this.getSelenium().windowFocus();
        this.externalX11WindowFocus();
        this.resetContent();
    }

    protected void runScript(String script) {
        this.initJavascriptEnv();
        this.getSelenium().runScript(script);
    }

    protected String getEval(String script) {
        this.initJavascriptEnv();
        return this.getSelenium().getEval(script);
    }

    protected void initJavascriptEnv() {
        if (!this.getSelenium().getEval("typeof window.XWE").equals("object")) {
            this.getSelenium().runScript("var XWE = function() {\n  var iframe = window.document.getElementsByTagName('iframe').item(0);\n    return {\n    document : iframe.contentDocument,\n    window : iframe.contentWindow,\n    rootNode : iframe.contentDocument.documentElement,\n    body : iframe.contentDocument.body,\n    innerHTML : iframe.contentDocument.body.innerHTML,\t\t\n    selection : iframe.contentWindow.getSelection(),\n    focus : function() { iframe.contentWindow.focus() },\t\t\n    getRange : function() { \n        try {\n          var range = iframe.contentDocument.defaultView.getSelection().getRangeAt(0);\n        } catch(e) {\n          var range = iframe.contentDocument.createRange();   \n          iframe.contentDocument.defaultView.getSelection().addRange(range);\t\t\t\t\n        }\n        return range;\n      },\n    removeAllRanges : function() { iframe.contentWindow.getSelection().removeAllRanges(); },\n    selectAll : function() { iframe.contentWindow.document.execCommand('selectall', false, null) },\n  };\n}();");
        }
    }

    public void setContent(String html) {
        this.runScript("XWE.body.innerHTML = '" + html + "';");
        this.runScript("XWE.focus();");
        this.updateRichTextAreaFormField();
    }

    public void resetContent() {
        this.selectAllContent();
        this.typeBackspace();
        this.selectAllContent();
    }

    public void selectAllContent() {
        this.runScript("XWE.selectAll();");
        this.triggerToolbarUpdate();
    }

    private void selectElement(String tagName, int occurence, boolean includeElement) {
        String rangeMethod = "selectNode";
        if (!includeElement) {
            rangeMethod = "selectNodeContents";
        }
        this.runScript("XWE.focus();var elementNumber = " + occurence + ";\n" + "var children = XWE.body.childNodes;\n" + "var r = XWE.getRange();   \n" + "for (var i = 0; i < children.length; i++) {\n" + "  if (children[i].tagName == '" + tagName.toUpperCase() + "') {\n" + "    if (elementNumber == 1) {\n" + "      r." + rangeMethod + "(children[i]);\n" + "      XWE.focus();\n" + "      break;\n" + "    }\n" + "    elementNumber--;\n" + "  }\n" + "}" + "if (elementNumber > 1) {\n" + "  throw ('There is no element number <" + occurence + "> of type <" + tagName + "> ')\n" + "}\n");
    }

    public void selectElement(String tagName, int occurence) {
        this.selectElement(tagName, occurence, true);
    }

    public void selectElementContent(String tagName, int occurence) {
        this.selectElement(tagName, occurence, false);
    }

    public void resetSelection() {
        this.runScript("XWE.removeAllRanges();");
    }

    public void typeText(String text) {
        char[] chars = text.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char tChar = chars[i];
            this.typeKey(Character.toString(tChar), true);
        }
    }

    public void typeTextThenEnter(String text) {
        this.typeText(text);
        this.typeEnter();
    }

    public void typeTextThenEnterTwice(String text) {
        this.typeTextThenEnter(text);
        this.typeEnter();
    }

    public void typeKey(String key, boolean fireKeyPress, int count, boolean hold) {
        for (int i = 0; i < count; ++i) {
            this.getSelenium().keyDown(WYSIWYG_LOCATOR_FOR_KEY_EVENTS, key);
            if (fireKeyPress) {
                this.getSelenium().keyPress(WYSIWYG_LOCATOR_FOR_KEY_EVENTS, key);
            }
            if (hold) continue;
            this.getSelenium().keyUp(WYSIWYG_LOCATOR_FOR_KEY_EVENTS, key);
        }
        if (hold && count > 0) {
            this.getSelenium().keyUp(WYSIWYG_LOCATOR_FOR_KEY_EVENTS, key);
        }
    }

    public void typeKey(String key, boolean fireKeyPress) {
        this.typeKey(key, fireKeyPress, 1, false);
    }

    public void typeEnter() {
        this.typeEnter(1);
    }

    public void typeEnter(int nb) {
        this.typeKey("\\13", true, nb, false);
    }

    public void typeShiftEnter() {
        this.getSelenium().shiftKeyDown();
        this.typeEnter();
        this.getSelenium().shiftKeyUp();
    }

    public void typeBackspace() {
        this.typeBackspace(1);
    }

    public void typeBackspace(int count) {
        this.typeBackspace(count, false);
    }

    public void typeBackspace(int count, boolean hold) {
        this.typeKey("\\8", true, count, hold);
    }

    public void typeLeftArrow() {
        this.typeKey("\\37", false);
    }

    public void typeUpArrow() {
        this.typeKey("\\38", false);
    }

    public void typeRightArrow() {
        this.typeKey("\\39", false);
    }

    public void typeDownArrow() {
        this.typeKey("\\40", false);
    }

    public void typeDelete() {
        this.typeDelete(1);
    }

    public void typeDelete(int count) {
        this.typeDelete(count, false);
    }

    public void typeDelete(int count, boolean hold) {
        this.typeKey("\\46", true, count, hold);
    }

    public void typeTab() {
        this.typeTab(1);
    }

    public void typeTab(int count) {
        this.typeKey("\\9", true, count, false);
    }

    public void typeShiftTab() {
        this.getSelenium().shiftKeyDown();
        this.typeTab();
        this.getSelenium().shiftKeyUp();
    }

    public void typeShiftTab(int count) {
        for (int i = 0; i < count; ++i) {
            this.typeShiftTab();
        }
    }

    public void clickUnorderedListButton() {
        this.pushButton("//div[@title='Unordered list']");
    }

    public void clickOrderedListButton() {
        this.pushButton("//div[@title='Ordered list']");
    }

    public void clickIndentButton() {
        this.pushButton("//div[@title='Indent']");
    }

    public boolean isIndentButtonEnabled() {
        return this.isButtonEnabled("Indent");
    }

    public void clickOutdentButton() {
        this.pushButton("//div[@title='Outdent']");
    }

    public boolean isOutdentButtonEnabled() {
        return this.isButtonEnabled("Outdent");
    }

    public void clickBoldButton() {
        this.pushButton("//div[@title='Bold (CTRL+B)']");
    }

    public void clickItalicsButton() {
        this.pushButton("//div[@title='Italic (CTRL+I)']");
    }

    public void clickUnderlineButton() {
        this.pushButton("//div[@title='Underline (CTRL+U)']");
    }

    public void clickStrikethroughButton() {
        this.pushButton("//div[@title='Strikethrough']");
    }

    public void clickHRButton() {
        this.pushButton("//div[@title='Insert horizontal ruler']");
    }

    public void clickSubscriptButton() {
        this.pushButton("//div[@title='Subscript']");
    }

    public void clickSuperscriptButton() {
        this.pushButton("//div[@title='Superscript']");
    }

    public void clickUndoButton() {
        this.pushButton("//div[@title='Undo (CTRL+Z)']");
    }

    public void clickUndoButton(int count) {
        for (int i = 0; i < count; ++i) {
            this.clickUndoButton();
        }
    }

    public void clickRedoButton() {
        this.pushButton("//div[@title='Redo (CTRL+Y)']");
    }

    public void clickRedoButton(int count) {
        for (int i = 0; i < count; ++i) {
            this.clickRedoButton();
        }
    }

    public void clickSymbolButton() {
        this.pushButton("//div[@title='Insert custom character']");
    }

    public void clickInsertImageButton() {
        this.pushButton("//div[@title='Insert/Edit Image']");
    }

    public void clickInsertLinkButton() {
        this.pushButton("//div[@title='Insert link']");
    }

    public void clickUnlinkButton() {
        this.pushButton("//div[@title='Unlink']");
    }

    public void clickOfficeImporterButton() {
        this.pushButton("//div[@title='Import office content']");
    }

    public boolean isUnlinkButtonEnabled() {
        return this.isButtonEnabled("Unlink");
    }

    public boolean isInsertLinkButtonEnabled() {
        return this.isButtonEnabled("Insert link");
    }

    public void clickInsertTableButton() {
        this.pushButton("//div[@title='Inserts a new table']");
    }

    public void clickBackToEdit() {
        this.submit("//button[text()='Back To Edit']");
    }

    public void applyStyle(String style) {
        this.getSelenium().select("//select[@title=\"Apply Style\"]", style);
    }

    public void applyStyleInLine() {
        this.applyStyle("Inline");
    }

    public void applyStyleParagraph() {
        this.applyStyle("Paragraph");
    }

    public void applyStyleTitle1() {
        this.applyStyle("Title 1");
    }

    public void applyStyleTitle2() {
        this.applyStyle("Title 2");
    }

    public void applyStyleTitle3() {
        this.applyStyle("Title 3");
    }

    public void applyStyleTitle4() {
        this.applyStyle("Title 4");
    }

    public void applyStyleTitle5() {
        this.applyStyle("Title 5");
    }

    public void pushButton(String locator) {
        this.getSelenium().mouseOver(locator);
        this.getSelenium().mouseDown(locator);
        this.getSelenium().mouseUp(locator);
        this.getSelenium().mouseOut(locator);
    }

    public void clickButtonWithTitle(String buttonTitle) {
        this.getSelenium().click("//button[@title=\"" + buttonTitle + "\"]");
    }

    public void clickButtonWithText(String buttonText) {
        this.getSelenium().click("//button[. = \"" + buttonText + "\"]");
    }

    public void clickMenu(String menuLabel) {
        String selector = "//td[contains(@class, 'gwt-MenuItem') and . = '" + menuLabel + "']";
        this.getSelenium().mouseOver(selector);
        this.getSelenium().click(selector);
    }

    public void closeMenuContaining(String menuLabel) {
        this.getSelenium().keyDown("//td[contains(@class, 'gwt-MenuItem') and . = '" + menuLabel + "']", "\\27");
    }

    public void typeInInput(String inputTitle, String text) {
        this.getSelenium().type("//input[@title=\"" + inputTitle + "\"]", text);
    }

    public String getInputValue(String inputTitle) {
        return this.getSelenium().getValue("//input[@title=\"" + inputTitle + "\"]");
    }

    public boolean isButtonEnabled(String buttonTitle) {
        return this.getSelenium().isElementPresent("//div[@title='" + buttonTitle + "' and @class='gwt-PushButton gwt-PushButton-up']");
    }

    public boolean isToggleButtonDown(String toggleButtonTitle) {
        return this.getSelenium().isElementPresent("//div[@title='" + toggleButtonTitle + "' and @class='gwt-ToggleButton gwt-ToggleButton-down']");
    }

    public boolean isMenuEnabled(String menuLabel) {
        return this.getSelenium().isElementPresent("//td[contains(@class, 'gwt-MenuItem') and not(contains(@class, 'gwt-MenuItem-disabled')) and . = '" + menuLabel + "']");
    }

    public void assertXHTML(String xhtml) {
        this.updateRichTextAreaFormField();
        Assert.assertEquals((String)xhtml, (String)this.getSelenium().getValue(WYSIWYG_LOCATOR_FOR_HTML_CONTENT));
    }

    public void switchToWikiEditor() {
        this.updateRichTextAreaFormField();
        this.clickLinkWithText("Wiki", true);
    }

    public void switchToWysiwygEditor() {
        this.clickLinkWithText("WYSIWYG", true);
        if (this.getSelenium().isConfirmationPresent()) {
            AbstractWysiwygTestCase.assertEquals((String)"Your content contains HTML or special code that might be lost in the WYSIWYG Editor. Are you sure you want to switch editors?", (String)this.getSelenium().getConfirmation());
        }
    }

    public void clickEditPreview() {
        this.updateRichTextAreaFormField();
        super.clickEditPreview();
    }

    public void updateRichTextAreaFormField() {
        this.getSelenium().clickAt("title", "0,0");
        this.runScript("XWE.focus();");
    }

    public void moveCaret(String containerJSLocator, int offset) {
        StringBuffer script = new StringBuffer();
        script.append("var range = XWE.document.createRange();\n");
        script.append("range.setStart(");
        script.append(containerJSLocator);
        script.append(", ");
        script.append(offset);
        script.append(");\n");
        script.append("range.collapse(true);\n");
        script.append("XWE.selection.removeAllRanges();\n");
        script.append("XWE.selection.addRange(range);");
        this.runScript(script.toString());
        this.triggerToolbarUpdate();
    }

    public void select(String startContainerJSLocator, int startOffset, String endContainerJSLocator, int endOffset) {
        StringBuffer script = new StringBuffer();
        script.append("var range = XWE.document.createRange();\n");
        script.append("range.setStart(");
        script.append(startContainerJSLocator);
        script.append(", ");
        script.append(startOffset);
        script.append(");\n");
        script.append("range.setEnd(");
        script.append(endContainerJSLocator);
        script.append(", ");
        script.append(endOffset);
        script.append(");\n");
        script.append("XWE.selection.removeAllRanges();\n");
        script.append("XWE.selection.addRange(range);");
        this.runScript(script.toString());
        this.triggerToolbarUpdate();
    }

    public void selectNode(String jsLocator) {
        StringBuffer script = new StringBuffer();
        script.append("var range = XWE.document.createRange();\n");
        script.append("range.selectNode(");
        script.append(jsLocator);
        script.append(");\n");
        script.append("XWE.selection.removeAllRanges();\n");
        script.append("XWE.selection.addRange(range);");
        this.runScript(script.toString());
        this.triggerToolbarUpdate();
    }

    public void selectNodeContents(String jsLocator) {
        StringBuffer script = new StringBuffer();
        script.append("var range = XWE.document.createRange();\n");
        script.append("range.selectNodeContents(");
        script.append(jsLocator);
        script.append(");\n");
        script.append("XWE.selection.removeAllRanges();\n");
        script.append("XWE.selection.addRange(range);");
        this.runScript(script.toString());
        this.triggerToolbarUpdate();
    }

    public String getDOMLocator(String domLocator) {
        return "document.getElementsByTagName('iframe')[0].contentWindow.document." + domLocator;
    }

    protected void triggerToolbarUpdate() {
        this.typeLeftArrow();
    }

    public void assertWikiTextGeneratedByWysiwyg(String text) {
        this.switchToWikiEditor();
        AbstractWysiwygTestCase.assertEquals((String)text, (String)this.getFieldValue(WYSIWYG_LOCATOR_FOR_HTML_CONTENT));
    }

    public void assertWiki(String expected) {
        this.assertWikiTextGeneratedByWysiwyg(expected);
        this.switchToWysiwygEditor();
    }

    public void setWikiContent(String wikiText) {
        this.switchToWikiEditor();
        this.setFieldValue(WYSIWYG_LOCATOR_FOR_HTML_CONTENT, wikiText);
        this.switchToWysiwygEditor();
    }

    public void waitForDialogToClose() {
        this.waitForCondition("!selenium.isElementPresent('//div[contains(@class, \"xDialogBox\")]')");
    }

    public void waitForDialogToOpen() {
        this.waitForCondition("selenium.isElementPresent('//div[contains(@class, \"xDialogBox\")]')");
    }

    public void closeDialog() {
        this.getSelenium().click("//img[contains(@class, \"gwt-Image\") and contains(@class, \"xDialogCloseIcon\")]");
    }

    public boolean isBoldDetected() {
        return this.isToggleButtonDown("Bold (CTRL+B)");
    }

    public boolean isUnderlineDetected() {
        return this.isToggleButtonDown("Underline (CTRL+U)");
    }

    private class StreamRedirector
    extends Thread {
        private InputStream is;
        private OutputStream os;

        StreamRedirector(InputStream in, OutputStream out) {
            this.is = in;
            this.os = out;
        }

        public void run() {
            byte[] buf = new byte[512];
            try {
                while (true) {
                    int n;
                    if ((n = this.is.read(buf)) == 0) {
                        return;
                    }
                    this.os.write(buf, 0, n);
                }
            }
            catch (Exception e) {
                LogFactory.getLog(StreamRedirector.class).error((Object)("Error while reading/writing: " + e));
                return;
            }
        }
    }
}

