/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xmlrpc;

import java.net.MalformedURLException;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.xmlrpc.XmlRpcException;
import org.codehaus.swizzle.confluence.ServerInfo;
import org.codehaus.swizzle.confluence.SpaceSummary;
import org.xwiki.xmlrpc.TestUtils;
import org.xwiki.xmlrpc.XWikiXmlRpcClient;
import org.xwiki.xmlrpc.model.XWikiPage;

public class AuthenticationTest
extends TestCase {
    public void setUp() {
    }

    public void tearDown() {
    }

    public void testLoginLogout() throws MalformedURLException, XmlRpcException {
        XWikiXmlRpcClient rpc = new XWikiXmlRpcClient("http://localhost:8080/xwiki/xmlrpc");
        rpc.login("Admin", "admin");
        rpc.logout();
    }

    public void testLoginWithInvalidUser() throws MalformedURLException, XmlRpcException {
        XWikiXmlRpcClient rpc = new XWikiXmlRpcClient("http://localhost:8080/xwiki/xmlrpc", "confluence1");
        try {
            rpc.login("thisUserShouldNotExist", "foo");
            Assert.fail();
        }
        catch (XmlRpcException xmlRpcException) {
            // empty catch block
        }
    }

    public void testXWikiXmlRpcServiceWithoutLogin() throws MalformedURLException, XmlRpcException {
        XWikiXmlRpcClient rpc = new XWikiXmlRpcClient("http://localhost:8080/xwiki/xmlrpc", "confluence1");
        List spaces = rpc.getSpaces();
        TestUtils.banner("TEST: XWikiXmlRpcServiceWithoutLogin() (Anonymous access)");
        for (SpaceSummary spaceSummary : spaces) {
            System.out.format("%s\n", spaceSummary);
        }
        AuthenticationTest.assertTrue((spaces.size() != 0 ? 1 : 0) != 0);
    }

    public void testXWikiXmlRpcServiceWithoutLoginNoRights() throws MalformedURLException, XmlRpcException {
        XWikiXmlRpcClient rpc = new XWikiXmlRpcClient("http://localhost:8080/xwiki/xmlrpc", "confluence1");
        try {
            XWikiPage page = rpc.getPage("XWiki.Admin");
            Assert.fail();
        }
        catch (XmlRpcException xmlRpcException) {
            // empty catch block
        }
    }

    public void testGetServerInfo() throws MalformedURLException, XmlRpcException {
        XWikiXmlRpcClient rpc = new XWikiXmlRpcClient("http://localhost:8080/xwiki/xmlrpc", "confluence1");
        rpc.login("Admin", "admin");
        ServerInfo serverInfo = rpc.getServerInfo();
        TestUtils.banner("TEST: getServerInfo()");
        System.out.format("%s\n", serverInfo);
        rpc.logout();
    }
}

