/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it.xmlrpc;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.codec.binary.Base64;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.Page;
import org.codehaus.swizzle.confluence.PageSummary;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.w3c.css.css.DocumentParser;
import org.w3c.css.css.StyleReport;
import org.w3c.css.css.StyleReportFactory;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.HTTPURL;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XhtmlValidityTest
extends TestCase
implements ErrorHandler {
    private String fullPageName;
    private static Validator xv;
    private Confluence rpc;
    private int errors = 0;
    private PrintStream stdout;
    private ByteArrayOutputStream out;
    private PrintStream stderr;
    private ByteArrayOutputStream err;

    public XhtmlValidityTest(String fullPageName) {
        super("testValidityOfDocument");
        this.fullPageName = fullPageName;
    }

    public static Test suite() throws Exception {
        TestSuite suite = new TestSuite();
        String path = System.getProperty("localRepository") + "/" + System.getProperty("pathToXWikiXar");
        String patternFilter = System.getProperty("documentsToTest");
        List pageNames = XhtmlValidityTest.readXarContents(path, patternFilter);
        Iterator it = pageNames.iterator();
        while (it.hasNext()) {
            suite.addTest((Test)new XhtmlValidityTest((String)it.next()));
        }
        System.setProperty("javax.xml.validation.SchemaFactory:http://www.w3.org/2001/XMLSchema", "org.apache.xerces.jaxp.validation.XMLSchemaFactory");
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema xhtmlSchema = sf.newSchema(XhtmlValidityTest.class.getClassLoader().getResource("xhtml1-strict.xsd"));
        xv = xhtmlSchema.newValidator();
        return suite;
    }

    public String getName() {
        return "Validating " + this.fullPageName;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.rpc = new Confluence("http://127.0.0.1:8080/xwiki/xmlrpc");
        this.rpc.login("Admin", "admin");
        System.out.println(this.getName());
        this.stdout = System.out;
        this.out = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.out));
        this.stderr = System.err;
        this.err = new ByteArrayOutputStream();
        System.setErr(new PrintStream(this.err));
    }

    protected void tearDown() throws Exception {
        String output = this.out.toString();
        String errput = this.err.toString();
        System.setOut(this.stdout);
        System.out.print(output);
        System.setErr(this.stderr);
        System.err.print(errput);
        XhtmlValidityTest.assertFalse((String)"Errors found in the stdout output", (boolean)this.hasErrors(output));
        XhtmlValidityTest.assertFalse((String)"Warnings found in the stdout output", (boolean)this.hasWarnings(output));
        XhtmlValidityTest.assertFalse((String)"Errors found in the stderr output", (boolean)this.hasErrors(errput));
        XhtmlValidityTest.assertFalse((String)"Warnings found in the stderr output", (boolean)this.hasWarnings(errput));
        this.rpc.logout();
        super.tearDown();
    }

    public void testValidityOfDocument() throws Exception {
        Page page = this.rpc.getPage(this.fullPageName);
        String renderedContent = this.rpc.renderContent((PageSummary)page);
        XhtmlValidityTest.assertNotNull((Object)renderedContent);
        if (renderedContent.indexOf("<rdf:RDF") == -1) {
            xv.setErrorHandler(this);
            InputSource src = new InputSource(new StringReader(XhtmlValidityTest.completeXhtml(page.getTitle(), renderedContent)));
            SAXSource s = new SAXSource(src);
            try {
                xv.validate(s);
            }
            catch (SAXParseException ex) {
                System.err.println(ex.getMessage());
                ++this.errors;
            }
        }
        XhtmlValidityTest.assertTrue((this.errors == 0 ? 1 : 0) != 0);
    }

    private boolean hasErrors(String output) {
        return output.indexOf("ERROR") >= 0 || output.indexOf("ERR") >= 0;
    }

    private boolean hasWarnings(String output) {
        return output.indexOf("WARNING") >= 0 || output.indexOf("WARN") >= 0;
    }

    public static List readXarContents(String fileName, String patternFilter) throws Exception {
        ZipEntry entry;
        FileInputStream fileIS = new FileInputStream(fileName);
        ZipInputStream zipIS = new ZipInputStream(fileIS);
        Document tocDoc = null;
        while ((entry = zipIS.getNextEntry()) != null) {
            if (entry.getName().compareTo("package.xml") != 0) continue;
            SAXReader reader = new SAXReader();
            tocDoc = reader.read((InputStream)zipIS);
            break;
        }
        if (tocDoc == null) {
            return new ArrayList();
        }
        ArrayList<String> result = new ArrayList<String>();
        Element filesElement = tocDoc.getRootElement().element("files");
        List fileElementList = filesElement.elements("file");
        for (Element el : fileElementList) {
            String docFullName = el.getStringValue();
            if (patternFilter != null && !docFullName.matches(patternFilter)) continue;
            result.add(docFullName);
        }
        return result;
    }

    private static String completeXhtml(String title, String content) {
        return "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">\n<head>\n<title>" + title + "</title>\n" + "</head>\n" + "<body>\n<div>\n" + content.replaceAll("&nbsp;", "&#160;") + "\n</div>\n</body>\n</html>";
    }

    private static int assertCssValid(String url) throws Exception {
        ApplContext ac = new ApplContext("en");
        ac.setProfile("css21");
        ac.setCssVersion("css21");
        ac.setMedium("all");
        ac.setCredential("Basic " + new String(Base64.encodeBase64((byte[])"Admin:admin".getBytes())));
        String output = "text";
        int warningLevel = 2;
        String encoding = ac.getMsg().getString("output-encoding-name");
        PrintWriter out = encoding != null ? new PrintWriter(new OutputStreamWriter((OutputStream)System.out, encoding)) : new PrintWriter(new OutputStreamWriter(System.out));
        String uri = HTTPURL.getURL((String)url).toString();
        DocumentParser URLparser = new DocumentParser(ac, uri);
        StyleSheet styleSheet = URLparser.getStyleSheet();
        if (styleSheet == null) {
            throw new IOException(ac.getMsg().getServletString("process") + " " + uri);
        }
        styleSheet.findConflicts(ac);
        StyleReport style = StyleReportFactory.getStyleReport((ApplContext)ac, (String)uri, (StyleSheet)styleSheet, (String)output, (int)warningLevel);
        int errors = styleSheet.getErrors().getErrorCount();
        if (errors > 0) {
            style.print(out);
        }
        return errors;
    }

    public void error(SAXParseException exception) throws SAXException {
        ++this.errors;
        System.out.println(exception.getMessage());
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        ++this.errors;
        System.out.println(exception.getMessage());
        exception.printStackTrace();
    }

    public void warning(SAXParseException exception) throws SAXException {
        System.out.println(exception.getMessage());
    }
}

