/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xmlrpc;

import java.net.MalformedURLException;
import java.util.List;
import org.apache.xmlrpc.XmlRpcException;
import org.codehaus.swizzle.confluence.Comment;
import org.codehaus.swizzle.confluence.Page;
import org.xwiki.xmlrpc.AbstractXWikiXmlRpcTest;
import org.xwiki.xmlrpc.TestUtils;
import org.xwiki.xmlrpc.model.XWikiPage;

public class CommentsTest
extends AbstractXWikiXmlRpcTest {
    public void setUp() throws XmlRpcException, MalformedURLException {
        super.setUp();
        try {
            this.rpc.getPage("Test.Comments");
        }
        catch (Exception e) {
            XWikiPage page = new XWikiPage();
            page.setId("Test.Comments");
            page.setTitle("Test page");
            page.setContent("Test page");
            this.rpc.storePage((Page)page);
        }
    }

    public void testAddComment() throws XmlRpcException {
        String content = String.format("This is a new comment!!! %s", this.random.nextInt());
        Comment comment = new Comment();
        comment.setPageId("Test.Comments");
        comment.setContent(content);
        comment = this.rpc.addComment(comment);
        TestUtils.banner("TEST: getComments()");
        System.out.format("%s\n", comment);
        CommentsTest.assertNotSame((Object)"NEW", (Object)comment.getId());
        CommentsTest.assertEquals((String)content, (String)comment.getContent());
        CommentsTest.assertEquals((String)String.format("XWiki.%s", "Admin"), (String)comment.getCreator());
    }

    public void testGetComments() throws XmlRpcException {
        List comments = this.rpc.getComments("Test.Comments");
        TestUtils.banner("TEST: getComments()");
        for (Comment comment : comments) {
            System.out.format("%s\n", comment);
        }
        CommentsTest.assertFalse((boolean)comments.isEmpty());
    }

    public void testRemoveComment() throws XmlRpcException {
        List comments = this.rpc.getComments("Test.Comments");
        Comment comment = (Comment)comments.get(this.random.nextInt(comments.size()));
        Boolean result = this.rpc.removeComment(comment.getId());
        TestUtils.banner("TEST: removeComment()");
        System.out.format("Comment removed = %b\n", result);
        comments = this.rpc.getComments("Test.Comments");
        boolean found = false;
        for (Comment c : comments) {
            if (!c.getId().equals(comment.getId())) continue;
            found = true;
            break;
        }
        CommentsTest.assertFalse((boolean)found);
    }
}

