/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it.xmlrpc;

import com.xpn.xwiki.it.xmlrpc.framework.AbstractXmlRpcTestCase;
import java.util.List;
import org.codehaus.swizzle.confluence.Page;
import org.codehaus.swizzle.confluence.PageHistorySummary;
import org.codehaus.swizzle.confluence.PageSummary;
import org.codehaus.swizzle.confluence.Space;

public class PagesTest
extends AbstractXmlRpcTestCase {
    private String spaceKey;

    public void setUp() throws Exception {
        super.setUp();
        this.spaceKey = "ContainerSpace";
        Space space = new Space();
        space.setKey(this.spaceKey);
        space.setName("Some Name");
        this.rpc.addSpace(space);
    }

    public void tearDown() throws Exception {
        this.rpc.removeSpace(this.spaceKey);
        super.tearDown();
    }

    public void testAddModifyRemovePage() throws Exception {
        String title = "SomeNewPage";
        String content = "Some Content";
        Page p = new Page();
        p.setSpace(this.spaceKey);
        p.setTitle(title);
        p.setContent(content);
        Page resultPage = this.rpc.storePage(p);
        String id = resultPage.getId();
        PagesTest.assertEquals((String)title, (String)resultPage.getTitle());
        PagesTest.assertEquals((String)this.spaceKey, (String)resultPage.getSpace());
        PagesTest.assertEquals((String)content, (String)resultPage.getContent());
        PagesTest.assertNotNull((Object)id);
        List pages = this.rpc.getPages(this.spaceKey);
        boolean found = false;
        for (int i = 0; i < pages.size() && !found; ++i) {
            PageSummary summary = (PageSummary)pages.get(i);
            if (!summary.getTitle().equals(title)) continue;
            found = true;
            PagesTest.assertEquals((String)this.spaceKey, (String)summary.getSpace());
        }
        PagesTest.assertTrue((String)("Adding page failed. There should be a page entitled \"" + title + "\" in this space"), (boolean)found);
        Page page = this.rpc.getPage(id);
        PagesTest.assertEquals((String)id, (String)page.getId());
        PagesTest.assertEquals((String)title, (String)page.getTitle());
        PagesTest.assertEquals((String)this.spaceKey, (String)page.getSpace());
        PagesTest.assertEquals((String)content, (String)page.getContent());
        String newContent = "Some Other Content";
        resultPage.setContent(newContent);
        Page modifiedPage = this.rpc.storePage(resultPage);
        PagesTest.assertEquals((String)id, (String)modifiedPage.getId());
        PagesTest.assertEquals((String)title, (String)modifiedPage.getTitle());
        PagesTest.assertEquals((String)this.spaceKey, (String)modifiedPage.getSpace());
        PagesTest.assertEquals((String)newContent, (String)modifiedPage.getContent());
        PagesTest.assertTrue((resultPage.getVersion() < modifiedPage.getVersion() ? 1 : 0) != 0);
        modifiedPage = this.rpc.getPage(id);
        PagesTest.assertEquals((String)id, (String)modifiedPage.getId());
        PagesTest.assertEquals((String)title, (String)modifiedPage.getTitle());
        PagesTest.assertEquals((String)this.spaceKey, (String)modifiedPage.getSpace());
        PagesTest.assertEquals((String)newContent, (String)modifiedPage.getContent());
        PagesTest.assertTrue((resultPage.getVersion() < modifiedPage.getVersion() ? 1 : 0) != 0);
        List oldVersions = this.rpc.getPageHistory(id);
        PagesTest.assertEquals((int)2, (int)oldVersions.size());
        PageHistorySummary phs0 = (PageHistorySummary)oldVersions.get(0);
        PagesTest.assertEquals((int)resultPage.getVersion(), (int)phs0.getVersion());
        PagesTest.assertNotNull((Object)phs0.getModified());
        PagesTest.assertNotNull((Object)phs0.getId());
        Page page0 = this.rpc.getPage(phs0.getId());
        PagesTest.assertEquals((String)page.getContent(), (String)page0.getContent());
        PagesTest.assertEquals((int)page.getVersion(), (int)page0.getVersion());
        this.rpc.removePage(id);
        pages = this.rpc.getPages(this.spaceKey);
        found = false;
        for (int i = 0; i < pages.size() && !found; ++i) {
            PageSummary summary = (PageSummary)pages.get(i);
            PagesTest.assertFalse((String)"Remove page failed. Page still present.", (boolean)summary.getId().equals(id));
        }
    }

    public void testGetPageHistory() throws Exception {
        String title = "SomeOtherPage";
        String content1 = "Content v1";
        Page p = new Page();
        p.setSpace(this.spaceKey);
        p.setTitle(title);
        p.setContent(content1);
        Page page1 = this.rpc.storePage(p);
        String content2 = "Content v2";
        p.setContent(content2);
        p.setId(page1.getId());
        p.setVersion(page1.getVersion());
        Page page2 = this.rpc.storePage(p);
        String content3 = "Content v3";
        p.setContent(content3);
        p.setId(page2.getId());
        p.setVersion(page2.getVersion());
        Page page3 = this.rpc.storePage(p);
        List historyObjs = this.rpc.getPageHistory(page3.getId());
        PagesTest.assertEquals((int)3, (int)historyObjs.size());
        PageHistorySummary phs1 = (PageHistorySummary)historyObjs.get(1);
        PagesTest.assertEquals((int)(page1.getVersion() + 1), (int)phs1.getVersion());
        Thread.sleep(2000L);
        Page p1 = this.rpc.getPage(phs1.getId());
        PagesTest.assertEquals((int)page2.getVersion(), (int)p1.getVersion());
        PagesTest.assertEquals((String)page2.getContent(), (String)p1.getContent());
        PagesTest.assertEquals((Object)page2.getCreated(), (Object)p1.getCreated());
        PagesTest.assertEquals((String)page2.getCreator(), (String)p1.getCreator());
        PagesTest.assertEquals((Object)page2.getModified(), (Object)p1.getModified());
        PagesTest.assertEquals((String)page2.getModifier(), (String)p1.getModifier());
        PagesTest.assertEquals((String)page2.getParentId(), (String)p1.getParentId());
        PagesTest.assertEquals((String)page2.getSpace(), (String)p1.getSpace());
        PagesTest.assertEquals((String)page2.getTitle(), (String)p1.getTitle());
        PageHistorySummary phs2 = (PageHistorySummary)historyObjs.get(0);
        Page p2 = this.rpc.getPage(phs2.getId());
        historyObjs = this.rpc.getPageHistory(p2.getId());
        phs1 = (PageHistorySummary)historyObjs.get(0);
        PagesTest.assertEquals((int)page1.getVersion(), (int)phs1.getVersion());
        p1 = this.rpc.getPage(phs1.getId());
        PagesTest.assertEquals((int)page1.getVersion(), (int)p1.getVersion());
        PagesTest.assertEquals((String)page1.getContent(), (String)p1.getContent());
        PagesTest.assertEquals((Object)page1.getCreated(), (Object)p1.getCreated());
        PagesTest.assertEquals((String)page1.getCreator(), (String)p1.getCreator());
        PagesTest.assertEquals((String)page1.getModifier(), (String)p1.getModifier());
        PagesTest.assertEquals((String)page1.getParentId(), (String)p1.getParentId());
        PagesTest.assertEquals((String)page1.getSpace(), (String)p1.getSpace());
        PagesTest.assertEquals((String)page1.getTitle(), (String)p1.getTitle());
    }

    public void testRenderContentWithInvalidPageId() {
        try {
            this.rpc.renderContent("unused", "InvalidPageId", "Dummy content");
            PagesTest.fail((String)"Should have received an exception here since the page id format is invalid");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

