/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it.xmlrpc;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.Page;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrphanedPageTest
extends TestCase {
    private String fullPageName;
    private Confluence rpc;

    public OrphanedPageTest(String fullPageName) {
        super("testPageIsOrphaned");
        this.fullPageName = fullPageName;
    }

    public static Test suite() throws Exception {
        TestSuite suite = new TestSuite();
        String path = System.getProperty("localRepository") + "/" + System.getProperty("pathToXWikiXar");
        String patternFilter = System.getProperty("documentsToTest");
        List<String> pageNames = OrphanedPageTest.readXarContents(path, patternFilter);
        for (String pageName : pageNames) {
            suite.addTest((Test)new OrphanedPageTest(pageName));
        }
        return suite;
    }

    public static List<String> readXarContents(String fileName, String patternFilter) throws Exception {
        ZipEntry entry;
        FileInputStream fileIS = new FileInputStream(fileName);
        ZipInputStream zipIS = new ZipInputStream(fileIS);
        Document tocDoc = null;
        while ((entry = zipIS.getNextEntry()) != null) {
            if (entry.getName().compareTo("package.xml") != 0) continue;
            SAXReader reader = new SAXReader();
            tocDoc = reader.read((InputStream)zipIS);
            break;
        }
        if (tocDoc == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        Element filesElement = tocDoc.getRootElement().element("files");
        List fileElementList = filesElement.elements("file");
        for (Element el : fileElementList) {
            String docFullName = el.getStringValue();
            if (patternFilter != null && !docFullName.matches(patternFilter)) continue;
            result.add(docFullName);
        }
        return result;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.rpc = new Confluence("http://127.0.0.1:8080/xwiki/xmlrpc");
        this.rpc.login("Admin", "admin");
        System.out.println(this.getName());
    }

    protected void tearDown() throws Exception {
        this.rpc.logout();
        super.tearDown();
    }

    public String getName() {
        return "Checking orphans for " + this.fullPageName;
    }

    public void testPageIsOrphaned() throws Exception {
        Page page = this.rpc.getPage(this.fullPageName);
        OrphanedPageTest.assertTrue((String)("Page " + page.getId() + " is orphaned!"), (OrphanedPageTest.isRoot(page) || OrphanedPageTest.hasParent(page) ? 1 : 0) != 0);
    }

    public static boolean isRoot(Page page) {
        String pageId = page.getId();
        String pageName = pageId.substring(pageId.lastIndexOf(".") + 1);
        return pageName.equals("WebHome");
    }

    public static boolean hasParent(Page page) {
        String parentId = page.getParentId();
        return parentId != null && parentId.length() > 0;
    }
}

