/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xmlrpc;

import java.util.List;
import junit.framework.Assert;
import org.apache.xmlrpc.XmlRpcException;
import org.codehaus.swizzle.confluence.Space;
import org.codehaus.swizzle.confluence.SpaceSummary;
import org.xwiki.xmlrpc.AbstractXWikiXmlRpcTest;
import org.xwiki.xmlrpc.TestUtils;

public class SpacesTest
extends AbstractXWikiXmlRpcTest {
    public void testGetSpaces() throws Exception {
        List spaces = this.rpc.getSpaces();
        TestUtils.banner("TEST: getSpaces()");
        for (SpaceSummary spaceSummary : spaces) {
            System.out.format("%s\n", spaceSummary);
        }
        SpacesTest.assertTrue((spaces.size() != 0 ? 1 : 0) != 0);
    }

    public void testGetSpace() throws Exception {
        List spaces = this.rpc.getSpaces();
        Space space = this.rpc.getSpace(((SpaceSummary)spaces.get(0)).getKey());
        TestUtils.banner("TEST: getSpaceTest()");
        System.out.format("%s\n", space);
        SpacesTest.assertEquals((String)space.getKey(), (String)((SpaceSummary)spaces.get(0)).getKey());
    }

    public void testGetNonExistingSpace() throws Exception {
        try {
            Space space = this.rpc.getSpace("thisSpaceShouldNotExist");
            Assert.fail();
        }
        catch (XmlRpcException xmlRpcException) {
            // empty catch block
        }
    }

    public void testAddSpace() throws Exception {
        Space space = new Space();
        space.setKey(String.format("%s-%d", "TEST", Math.abs(this.random.nextInt())));
        space.setName("TEST Space");
        space = this.rpc.addSpace(space);
        TestUtils.banner("TEST: addSpace()");
        System.out.format("%s\n", space);
        List spaces = this.rpc.getSpaces();
        boolean found = false;
        for (SpaceSummary spaceSummary : spaces) {
            if (!spaceSummary.getKey().equals(space.getKey())) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
    }

    public void testAddDuplicatedSpace() throws Exception {
        Space space = new Space();
        space.setKey(String.format("%s-%d", "TEST", Math.abs(this.random.nextInt())));
        space.setName("TEST Space");
        try {
            space = this.rpc.addSpace(space);
            space = this.rpc.addSpace(space);
            Assert.fail();
        }
        catch (XmlRpcException xmlRpcException) {
            // empty catch block
        }
    }

    public void testGetSpaceWithoutRights() throws Exception {
        if ("Admin".equals("Admin")) {
            System.out.format("User admin can always access everything\n", new Object[0]);
            return;
        }
        try {
            Space space = this.rpc.getSpace("Scheduler");
        }
        catch (XmlRpcException xmlRpcException) {
            // empty catch block
        }
    }

    public void testRemoveSpace() throws Exception {
        List spaces = this.rpc.getSpaces();
        SpaceSummary spaceToBeRemoved = null;
        for (SpaceSummary spaceSummary : spaces) {
            if (!spaceSummary.getKey().startsWith("TEST")) continue;
            spaceToBeRemoved = spaceSummary;
            break;
        }
        Boolean result = this.rpc.removeSpace(spaceToBeRemoved.getKey());
        TestUtils.banner("TEST: removeSpace()");
        System.out.format("%s removed: %b\n", spaceToBeRemoved.getKey(), result);
        boolean found = false;
        spaces = this.rpc.getSpaces();
        for (SpaceSummary spaceSummary : spaces) {
            if (!spaceSummary.getKey().equals(spaceToBeRemoved.getKey())) continue;
            System.out.format("Page still existing: %s\n", spaceSummary);
            found = true;
            break;
        }
        Assert.assertFalse((boolean)found);
    }

    public void testRemoveNonExistingSpace() throws Exception {
        try {
            Boolean result = this.rpc.removeSpace("thisSpaceShouldNotExist");
            Assert.fail();
        }
        catch (XmlRpcException xmlRpcException) {
            // empty catch block
        }
    }
}

