/*
 * Isomorphic SmartClient
 * Version 7.2b (2009-08-08)
 * Copyright(c) 1998 and beyond Isomorphic Software, Inc. All rights reserved.
 * "SmartClient" is a trademark of Isomorphic Software, Inc.
 *
 * licensing@smartclient.com
 *
 * http://smartclient.com/license
 */

if(window.isc&&window.isc.module_Core&&!window.isc.module_SalesForce){isc.module_SalesForce=1;isc._moduleStart=isc._SalesForce_start=(isc.timestamp?isc.timestamp():new Date().getTime());if(isc._moduleEnd&&(!isc.Log||(isc.Log && isc.Log.logIsDebugEnabled('loadTime')))){isc._pTM={ message:'SalesForce load/parse time: ' + (isc._moduleStart-isc._moduleEnd) + 'ms', category:'loadTime'};
if(isc.Log && isc.Log.logDebug)isc.Log.logDebug(isc._pTM.message,'loadTime')
else if(isc._preLog)isc._preLog[isc._preLog.length]=isc._pTM
else isc._preLog=[isc._pTM]}isc.SchemaSet.create({
qualifyAll:true,
schemaNamespace:"urn:sobject.partner.soap.sforce.com",
serviceNamespace:"urn:partner.soap.sforce.com",
schema:[
isc.XSComplexType.create({
ID:"sObject",
mustQualify:true,
fields:{
type:{name:"type",type:"string",xmlRequired:true},
fieldsToNull:{name:"fieldsToNull",nillable:"true",type:"string",xmlRequired:false},
Id:{name:"Id",nillable:"true",type:"ID",xmlRequired:true}
}
})
]
})
isc.SchemaSet.create({
qualifyAll:true,
schemaNamespace:"urn:partner.soap.sforce.com",
serviceNamespace:"urn:partner.soap.sforce.com",
schema:[
isc.XSElement.create({
ID:"login",
mustQualify:true,
fields:{
username:{name:"username",type:"string",xmlRequired:true},
password:{name:"password",type:"string",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"loginResponse",
mustQualify:true,
fields:{
result:{name:"result",type:"LoginResult",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"describeSObject",
mustQualify:true,
fields:{
sObjectType:{name:"sObjectType",type:"string",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"describeSObjectResponse",
mustQualify:true,
fields:{
result:{name:"result",type:"DescribeSObjectResult",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"describeSObjects",
mustQualify:true,
fields:{
sObjectType:{name:"sObjectType",type:"string",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"describeSObjectsResponse",
mustQualify:true,
fields:{
result:{name:"result",type:"DescribeSObjectResult",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"describeGlobal",
mustQualify:true,
fields:{}
})
,
isc.XSElement.create({
ID:"describeGlobalResponse",
mustQualify:true,
fields:{
result:{name:"result",type:"DescribeGlobalResult",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"describeLayout",
mustQualify:true,
fields:{
sObjectType:{name:"sObjectType",type:"string",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"describeLayoutResponse",
mustQualify:true,
fields:{
result:{name:"result",type:"DescribeLayoutResult",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"describeTabs",
mustQualify:true,
fields:{}
})
,
isc.XSElement.create({
ID:"describeTabsResponse",
mustQualify:true,
fields:{
result:{name:"result",type:"DescribeTabSetResult",xmlRequired:false}
}
})
,
isc.XSElement.create({
ID:"create",
mustQualify:true,
fields:{
sObjects:{name:"sObjects",type:"sObject",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"createResponse",
mustQualify:true,
fields:{
result:{name:"result",type:"SaveResult",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"update",
mustQualify:true,
fields:{
sObjects:{name:"sObjects",type:"sObject",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"updateResponse",
mustQualify:true,
fields:{
result:{name:"result",type:"SaveResult",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"delete",
mustQualify:true,
fields:{
ids:{name:"ids",type:"ID",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"deleteResponse",
mustQualify:true,
fields:{
result:{name:"result",type:"DeleteResult",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"retrieve",
mustQualify:true,
fields:{
fieldList:{name:"fieldList",type:"string",xmlRequired:true},
sObjectType:{name:"sObjectType",type:"string",xmlRequired:true},
ids:{name:"ids",type:"ID",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"retrieveResponse",
mustQualify:true,
fields:{
result:{name:"result",nillable:"true",type:"sObject",xmlRequired:false}
}
})
,
isc.XSElement.create({
ID:"convertLead",
mustQualify:true,
fields:{
leadConverts:{name:"leadConverts",type:"LeadConvert",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"convertLeadResponse",
mustQualify:true,
fields:{
result:{name:"result",type:"LeadConvertResult",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"getUpdated",
mustQualify:true,
fields:{
sObjectType:{name:"sObjectType",type:"string",xmlRequired:true},
startDate:{name:"startDate",type:"dateTime",xmlRequired:true},
endDate:{name:"endDate",type:"dateTime",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"getUpdatedResponse",
mustQualify:true,
fields:{
result:{name:"result",type:"GetUpdatedResult",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"getDeleted",
mustQualify:true,
fields:{
sObjectType:{name:"sObjectType",type:"string",xmlRequired:true},
startDate:{name:"startDate",type:"dateTime",xmlRequired:true},
endDate:{name:"endDate",type:"dateTime",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"getDeletedResponse",
mustQualify:true,
fields:{
result:{name:"result",type:"GetDeletedResult",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"query",
mustQualify:true,
fields:{
queryString:{name:"queryString",type:"string",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"queryResponse",
mustQualify:true,
fields:{
result:{name:"result",type:"QueryResult",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"queryMore",
mustQualify:true,
fields:{
queryLocator:{name:"queryLocator",type:"QueryLocator",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"queryMoreResponse",
mustQualify:true,
fields:{
result:{name:"result",type:"QueryResult",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"search",
mustQualify:true,
fields:{
searchString:{name:"searchString",type:"string",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"searchResponse",
mustQualify:true,
fields:{
result:{name:"result",type:"SearchResult",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"getServerTimestamp",
mustQualify:true,
fields:{}
})
,
isc.XSElement.create({
ID:"getServerTimestampResponse",
mustQualify:true,
fields:{
result:{name:"result",type:"GetServerTimestampResult",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"setPassword",
mustQualify:true,
fields:{
userId:{name:"userId",type:"ID",xmlRequired:true},
password:{name:"password",type:"string",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"setPasswordResponse",
mustQualify:true,
fields:{
result:{name:"result",type:"SetPasswordResult",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"resetPassword",
mustQualify:true,
fields:{
userId:{name:"userId",type:"ID",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"resetPasswordResponse",
mustQualify:true,
fields:{
result:{name:"result",type:"ResetPasswordResult",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"getUserInfo",
mustQualify:true,
fields:{}
})
,
isc.XSElement.create({
ID:"getUserInfoResponse",
mustQualify:true,
fields:{
result:{name:"result",type:"GetUserInfoResult",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"SessionHeader",
mustQualify:true,
fields:{
sessionId:{name:"sessionId",type:"string",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"CallOptions",
mustQualify:true,
fields:{
client:{name:"client",type:"string",xmlRequired:true}
}
})
,
isc.XSElement.create({
ID:"QueryOptions",
mustQualify:true,
fields:{
batchSize:{name:"batchSize",type:"int",xmlRequired:false}
}
})
,
isc.XSElement.create({
ID:"AssignmentRuleHeader",
mustQualify:true,
fields:{
assignmentRuleId:{name:"assignmentRuleId",nillable:"true",type:"ID",xmlRequired:true},
useDefaultRule:{name:"useDefaultRule",nillable:"true",type:"boolean",xmlRequired:true}
}
})
,
isc.SimpleType.create({
inheritsFrom:"string",
name:"ID",
xmlNonEmpty:true,
validators:[
{
max:18,
min:18,
type:"lengthRange"
},
{expression:"[a-zA-Z0-9]{18}",type:"regexp"}
]
})
,
isc.SimpleType.create({inheritsFrom:"string",name:"QueryLocator"})
,
isc.XSComplexType.create({
ID:"QueryResult",
mustQualify:true,
fields:{
done:{name:"done",type:"boolean",xmlRequired:true},
queryLocator:{name:"queryLocator",nillable:"true",type:"QueryLocator",xmlRequired:true},
records:{name:"records",nillable:"true",type:"sObject",xmlRequired:false},
size:{name:"size",type:"int",xmlRequired:true}
}
})
,
isc.XSComplexType.create({
ID:"SearchResult",
mustQualify:true,
fields:{
searchRecords:{name:"searchRecords",type:"SearchRecord",xmlRequired:false},
sforceReserved:{name:"sforceReserved",type:"string",xmlRequired:false}
}
})
,
isc.XSComplexType.create({
ID:"SearchRecord",
mustQualify:true,
fields:{
record:{name:"record",type:"sObject",xmlRequired:true}
}
})
,
isc.XSComplexType.create({
ID:"GetUpdatedResult",
mustQualify:true,
fields:{
ids:{name:"ids",type:"ID",xmlRequired:false},
sforceReserved:{name:"sforceReserved",type:"string",xmlRequired:false}
}
})
,
isc.XSComplexType.create({
ID:"GetDeletedResult",
mustQualify:true,
fields:{
deletedRecords:{name:"deletedRecords",type:"DeletedRecord",xmlRequired:false},
sforceReserved:{name:"sforceReserved",type:"string",xmlRequired:false}
}
})
,
isc.XSComplexType.create({
ID:"DeletedRecord",
mustQualify:true,
fields:{
deletedDate:{name:"deletedDate",type:"dateTime",xmlRequired:true},
id:{name:"id",type:"ID",xmlRequired:true}
}
})
,
isc.XSComplexType.create({
ID:"GetServerTimestampResult",
mustQualify:true,
fields:{
timestamp:{name:"timestamp",type:"dateTime",xmlRequired:true}
}
})
,
isc.XSComplexType.create({
ID:"SetPasswordResult",
mustQualify:true,
fields:{}
})
,
isc.XSComplexType.create({
ID:"ResetPasswordResult",
mustQualify:true,
fields:{
password:{name:"password",type:"string",xmlRequired:true}
}
})
,
isc.XSComplexType.create({
ID:"GetUserInfoResult",
mustQualify:true,
fields:{
currencySymbol:{name:"currencySymbol",nillable:"true",type:"string",xmlRequired:true},
organizationId:{name:"organizationId",type:"ID",xmlRequired:true},
organizationMultiCurrency:{name:"organizationMultiCurrency",type:"boolean",xmlRequired:true},
organizationName:{name:"organizationName",type:"string",xmlRequired:true},
userDefaultCurrencyIsoCode:{name:"userDefaultCurrencyIsoCode",nillable:"true",type:"string",xmlRequired:true},
userEmail:{name:"userEmail",type:"string",xmlRequired:true},
userFullName:{name:"userFullName",type:"string",xmlRequired:true},
userId:{name:"userId",type:"ID",xmlRequired:true},
userLanguage:{name:"userLanguage",type:"string",xmlRequired:true},
userLocale:{name:"userLocale",type:"string",xmlRequired:true},
userTimeZone:{name:"userTimeZone",type:"string",xmlRequired:true}
}
})
,
isc.XSComplexType.create({
ID:"LoginResult",
mustQualify:true,
fields:{
passwordExpired:{name:"passwordExpired",type:"boolean",xmlRequired:true},
serverUrl:{name:"serverUrl",nillable:"true",type:"string",xmlRequired:true},
sessionId:{name:"sessionId",nillable:"true",type:"string",xmlRequired:true},
userId:{name:"userId",nillable:"true",type:"ID",xmlRequired:true},
userInfo:{name:"userInfo",type:"GetUserInfoResult",xmlRequired:true}
}
})
,
isc.SimpleType.create({
inheritsFrom:"string",
name:"StatusCode",
valueMap:["ASSIGNEE_TYPE_REQUIRED","BAD_CUSTOM_ENTITY_PARENT_DOMAIN",
"CANNOT_CASCADE_PRODUCT_ACTIVE","CANNOT_DEACTIVATE_DIVISION","CANNOT_INSERT_UPDATE_ACTIVATE_ENTITY",
"CANNOT_REPARENT_RECORD","CANNOT_RESOLVE_NAME","CANNOT_UPDATE_CONVERTED_LEAD","CANT_DISABLE_CORP_CURRENCY",
"CANT_UNSET_CORP_CURRENCY","CHILD_SHARE_FAILS_PARENT","CIRCULAR_DEPENDENCY","CUSTOM_ENTITY_OR_FIELD_LIMIT",
"CUSTOM_FIELD_INDEX_LIMIT_EXCEEDED","CUSTOM_INDEX_EXISTS","DELETE_FAILED","DELETE_REQUIRED_ON_CASCADE",
"DEPENDENCY_EXISTS","DUPLICATE_CASE_SOLUTION","DUPLICATE_CUSTOM_TAB_MOTIF","DUPLICATE_DEVELOPER_NAME",
"DUPLICATE_MASTER_LABEL","DUPLICATE_USERNAME","DUPLICATE_VALUE","ENTITY_FAILED_IFLASTMODIFIED_ON_UPDATE",
"ENTITY_IS_ARCHIVED","ENTITY_IS_DELETED","ENTITY_IS_LOCKED","FAILED_ACTIVATION",
"FIELD_INTEGRITY_EXCEPTION","INACTIVE_OWNER_OR_USER","INSUFFICIENT_ACCESS_ON_CROSS_REFERENCE_ENTITY",
"INSUFFICIENT_ACCESS_OR_READONLY","INVALID_ACCESS_LEVEL","INVALID_ARGUMENT_TYPE","INVALID_ASSIGNEE_TYPE",
"INVALID_ASSIGNMENT_RULE","INVALID_BATCH_OPERATION","INVALID_CREDIT_CARD_INFO","INVALID_CROSS_REFERENCE_KEY",
"INVALID_CROSS_REFERENCE_TYPE_FOR_FIELD","INVALID_CURRENCY_CONV_RATE","INVALID_CURRENCY_ISO","INVALID_EMAIL_ADDRESS",
"INVALID_EMPTY_KEY_OWNER","INVALID_FIELD","INVALID_FIELD_FOR_INSERT_UPDATE","INVALID_FILTER_ACTION",
"INVALID_ID_FIELD","INVALID_INET_ADDRESS","INVALID_LINEITEM_CLONE_STATE","INVALID_OPERATION",
"INVALID_OPERATOR","INVALID_OR_NULL_FOR_RESTRICTED_PICKLIST","INVALID_STATUS","INVALID_TYPE",
"INVALID_TYPE_FOR_OPERATION","INVALID_TYPE_ON_FIELD_IN_RECORD","LAST_MODIFIED_SINCE_TOO_OLD",
"LICENSE_LIMIT_EXCEEDED","MALFORMED_ID","MAXIMUM_CCEMAILS_EXCEEDED","MAXIMUM_DASHBOARD_COMPONENTS_EXCEEDED",
"MAXIMUM_SIZE_OF_ATTACHMENT","MAXIMUM_SIZE_OF_DOCUMENT","MAX_ACTIONS_PER_RULE_EXCEEDED",
"MAX_ACTIVE_RULES_EXCEEDED","MAX_TASK_DESCRIPTION_EXCEEEDED","MISSING_ARGUMENT","NONUNIQUE_SHIPPING_ADDRESS",
"NUMBER_OUTSIDE_VALID_RANGE","PRIVATE_CONTACT_ON_ASSET","REQUIRED_FIELD_MISSING","SHARE_NEEDED_FOR_CHILD_OWNER",
"STANDARD_PRICE_NOT_DEFINED","STORAGE_LIMIT_EXCEEDED","TEXT_DATA_OUTSIDE_SUPPORTED_CHARSET","TOO_MANY_ENUM_VALUE",
"TRANSFER_REQUIRES_READ","UNKNOWN_EXCEPTION","UNSPECIFIED_EMAIL_ADDRESS"]
})
,
isc.XSComplexType.create({
ID:"Error",
mustQualify:true,
fields:{
fields:{name:"fields",nillable:"true",type:"string",xmlRequired:false},
message:{name:"message",type:"string",xmlRequired:true},
statusCode:{name:"statusCode",type:"StatusCode",xmlRequired:true}
}
})
,
isc.XSComplexType.create({
ID:"SaveResult",
mustQualify:true,
fields:{
errors:{name:"errors",nillable:"true",type:"Error",xmlRequired:false},
id:{name:"id",nillable:"true",type:"ID",xmlRequired:true},
success:{name:"success",type:"boolean",xmlRequired:true}
}
})
,
isc.XSComplexType.create({
ID:"DeleteResult",
mustQualify:true,
fields:{
errors:{name:"errors",nillable:"true",type:"Error",xmlRequired:false},
id:{name:"id",nillable:"true",type:"ID",xmlRequired:true},
success:{name:"success",type:"boolean",xmlRequired:true}
}
})
,
isc.XSComplexType.create({
ID:"LeadConvert",
mustQualify:true,
fields:{
accountId:{name:"accountId",nillable:"true",type:"ID",xmlRequired:true},
contactId:{name:"contactId",nillable:"true",type:"ID",xmlRequired:true},
convertedStatus:{name:"convertedStatus",type:"string",xmlRequired:true},
doNotCreateOpportunity:{name:"doNotCreateOpportunity",type:"boolean",xmlRequired:true},
leadId:{name:"leadId",type:"ID",xmlRequired:true},
opportunityName:{name:"opportunityName",nillable:"true",type:"string",xmlRequired:true},
overwriteLeadSource:{name:"overwriteLeadSource",type:"boolean",xmlRequired:true},
ownerId:{name:"ownerId",nillable:"true",type:"ID",xmlRequired:true},
sendNotificationEmail:{name:"sendNotificationEmail",type:"boolean",xmlRequired:true}
}
})
,
isc.XSComplexType.create({
ID:"LeadConvertResult",
mustQualify:true,
fields:{
accountId:{name:"accountId",nillable:"true",type:"ID",xmlRequired:true},
contactId:{name:"contactId",nillable:"true",type:"ID",xmlRequired:true},
errors:{name:"errors",nillable:"true",type:"Error",xmlRequired:false},
leadId:{name:"leadId",nillable:"true",type:"ID",xmlRequired:true},
opportunityId:{name:"opportunityId",nillable:"true",type:"ID",xmlRequired:true},
success:{name:"success",type:"boolean",xmlRequired:true}
}
})
,
isc.XSComplexType.create({
ID:"DescribeSObjectResult",
mustQualify:true,
fields:{
activateable:{name:"activateable",type:"boolean",xmlRequired:true},
childRelationships:{name:"childRelationships",type:"ChildRelationship",xmlRequired:false},
createable:{name:"createable",type:"boolean",xmlRequired:true},
custom:{name:"custom",type:"boolean",xmlRequired:true},
deletable:{name:"deletable",type:"boolean",xmlRequired:true},
fields:{name:"fields",nillable:"true",type:"Field",xmlRequired:false},
keyPrefix:{name:"keyPrefix",nillable:"true",type:"string",xmlRequired:true},
label:{name:"label",type:"string",xmlRequired:true},
labelPlural:{name:"labelPlural",type:"string",xmlRequired:true},
layoutable:{name:"layoutable",type:"boolean",xmlRequired:true},
name:{name:"name",type:"string",xmlRequired:true},
queryable:{name:"queryable",type:"boolean",xmlRequired:true},
replicateable:{name:"replicateable",type:"boolean",xmlRequired:true},
retrieveable:{name:"retrieveable",type:"boolean",xmlRequired:true},
searchable:{name:"searchable",type:"boolean",xmlRequired:true},
undeletable:{name:"undeletable",type:"boolean",xmlRequired:true},
updateable:{name:"updateable",type:"boolean",xmlRequired:true},
urlDetail:{name:"urlDetail",nillable:"true",type:"string",xmlRequired:true},
urlEdit:{name:"urlEdit",nillable:"true",type:"string",xmlRequired:true},
urlNew:{name:"urlNew",nillable:"true",type:"string",xmlRequired:true}
}
})
,
isc.XSComplexType.create({
ID:"ChildRelationship",
mustQualify:true,
fields:{
cascadeDelete:{name:"cascadeDelete",type:"boolean",xmlRequired:true},
childSObject:{name:"childSObject",type:"string",xmlRequired:true},
field:{name:"field",type:"string",xmlRequired:true}
}
})
,
isc.XSComplexType.create({
ID:"DescribeGlobalResult",
mustQualify:true,
fields:{
encoding:{name:"encoding",nillable:"true",type:"string",xmlRequired:true},
maxBatchSize:{name:"maxBatchSize",type:"int",xmlRequired:true},
types:{name:"types",nillable:"true",type:"string",xmlRequired:false}
}
})
,
isc.SimpleType.create({
inheritsFrom:"string",
name:"fieldType",
valueMap:["string","picklist","multipicklist","combobox","reference","base64","boolean",
"currency","textarea","int","double","percent","phone","id","date","datetime","url",
"email"]
})
,
isc.SimpleType.create({
inheritsFrom:"string",
name:"soapType",
valueMap:["tns:ID","xsd:base64Binary","xsd:boolean","xsd:double","xsd:int","xsd:string",
"xsd:date","xsd:dateTime"]
})
,
isc.XSComplexType.create({
ID:"Field",
mustQualify:true,
fields:{
autoNumber:{name:"autoNumber",type:"boolean",xmlRequired:true},
byteLength:{name:"byteLength",type:"int",xmlRequired:true},
calculated:{name:"calculated",type:"boolean",xmlRequired:true},
createable:{name:"createable",type:"boolean",xmlRequired:true},
custom:{name:"custom",type:"boolean",xmlRequired:true},
defaultedOnCreate:{name:"defaultedOnCreate",type:"boolean",xmlRequired:true},
digits:{name:"digits",type:"int",xmlRequired:true},
filterable:{name:"filterable",type:"boolean",xmlRequired:true},
label:{name:"label",type:"string",xmlRequired:true},
length:{name:"length",type:"int",xmlRequired:true},
name:{name:"name",type:"string",xmlRequired:true},
nameField:{name:"nameField",type:"boolean",xmlRequired:true},
nillable:{name:"nillable",type:"boolean",xmlRequired:true},
picklistValues:{name:"picklistValues",nillable:"true",type:"PicklistEntry",xmlRequired:false},
precision:{name:"precision",type:"int",xmlRequired:true},
referenceTo:{name:"referenceTo",nillable:"true",type:"string",xmlRequired:false},
restrictedPicklist:{name:"restrictedPicklist",type:"boolean",xmlRequired:true},
scale:{name:"scale",type:"int",xmlRequired:true},
soapType:{name:"soapType",type:"soapType",xmlRequired:true},
type:{name:"type",type:"fieldType",xmlRequired:true},
updateable:{name:"updateable",type:"boolean",xmlRequired:true}
}
})
,
isc.XSComplexType.create({
ID:"PicklistEntry",
mustQualify:true,
fields:{
active:{name:"active",type:"boolean",xmlRequired:true},
defaultValue:{name:"defaultValue",type:"boolean",xmlRequired:true},
label:{name:"label",nillable:"true",type:"string",xmlRequired:true},
value:{name:"value",type:"string",xmlRequired:true}
}
})
,
isc.XSComplexType.create({
ID:"DescribeLayoutResult",
mustQualify:true,
fields:{
layouts:{name:"layouts",type:"DescribeLayout",xmlRequired:true},
recordTypeMappings:{name:"recordTypeMappings",type:"RecordTypeMapping",xmlRequired:false}
}
})
,
isc.XSComplexType.create({
ID:"DescribeLayout",
mustQualify:true,
fields:{
detailLayoutSections:{name:"detailLayoutSections",type:"DescribeLayoutSection",xmlRequired:false},
editLayoutSections:{name:"editLayoutSections",type:"DescribeLayoutSection",xmlRequired:false},
id:{name:"id",type:"ID",xmlRequired:true}
}
})
,
isc.XSComplexType.create({
ID:"DescribeLayoutSection",
mustQualify:true,
fields:{
columns:{name:"columns",type:"int",xmlRequired:true},
heading:{name:"heading",type:"string",xmlRequired:true},
layoutRows:{name:"layoutRows",type:"DescribeLayoutRow",xmlRequired:true},
rows:{name:"rows",type:"int",xmlRequired:true},
useCollapsibleSection:{name:"useCollapsibleSection",type:"boolean",xmlRequired:true},
useHeading:{name:"useHeading",type:"boolean",xmlRequired:true}
}
})
,
isc.XSComplexType.create({
ID:"DescribeLayoutRow",
mustQualify:true,
fields:{
layoutItems:{name:"layoutItems",type:"DescribeLayoutItem",xmlRequired:true},
numItems:{name:"numItems",type:"int",xmlRequired:true}
}
})
,
isc.XSComplexType.create({
ID:"DescribeLayoutItem",
mustQualify:true,
fields:{
editable:{name:"editable",type:"boolean",xmlRequired:true},
label:{name:"label",nillable:"true",type:"string",xmlRequired:true},
layoutComponents:{name:"layoutComponents",type:"DescribeLayoutComponent",xmlRequired:false},
placeholder:{name:"placeholder",type:"boolean",xmlRequired:true},
required:{name:"required",type:"boolean",xmlRequired:true}
}
})
,
isc.XSComplexType.create({
ID:"DescribeLayoutComponent",
mustQualify:true,
fields:{
tabOrder:{name:"tabOrder",type:"int",xmlRequired:true},
type:{name:"type",type:"layoutComponentType",xmlRequired:true},
value:{name:"value",type:"string",xmlRequired:true}
}
})
,
isc.SimpleType.create({
inheritsFrom:"string",
name:"layoutComponentType",
valueMap:["Field","Separator"]
})
,
isc.XSComplexType.create({
ID:"RecordTypeMapping",
mustQualify:true,
fields:{
available:{name:"available",type:"boolean",xmlRequired:true},
defaultRecordTypeMapping:{name:"defaultRecordTypeMapping",type:"boolean",xmlRequired:true},
layoutId:{name:"layoutId",type:"ID",xmlRequired:true},
name:{name:"name",type:"string",xmlRequired:true},
picklistsForRecordType:{name:"picklistsForRecordType",nillable:"true",type:"PicklistForRecordType",
xmlRequired:false},
recordTypeId:{name:"recordTypeId",nillable:"true",type:"ID",xmlRequired:true}
}
})
,
isc.XSComplexType.create({
ID:"PicklistForRecordType",
mustQualify:true,
fields:{
picklistName:{name:"picklistName",type:"string",xmlRequired:true},
picklistValues:{name:"picklistValues",nillable:"true",type:"PicklistEntry",xmlRequired:false}
}
})
,
isc.XSComplexType.create({
ID:"DescribeTabSetResult",
mustQualify:true,
fields:{
label:{name:"label",type:"string",xmlRequired:true},
logoUrl:{name:"logoUrl",type:"string",xmlRequired:true},
selected:{name:"selected",type:"boolean",xmlRequired:true},
tabs:{name:"tabs",type:"DescribeTab",xmlRequired:false}
}
})
,
isc.XSComplexType.create({
ID:"DescribeTab",
mustQualify:true,
fields:{
custom:{name:"custom",type:"boolean",xmlRequired:true},
label:{name:"label",type:"string",xmlRequired:true},
sobjectName:{name:"sobjectName",nillable:"true",type:"string",xmlRequired:true},
url:{name:"url",type:"string",xmlRequired:true}
}
})
]
})
isc.SchemaSet.create({
qualifyAll:true,
schemaNamespace:"urn:fault.partner.soap.sforce.com",
serviceNamespace:"urn:partner.soap.sforce.com",
schema:[
isc.SimpleType.create({
inheritsFrom:"string",
name:"ExceptionCode",
valueMap:["API_CURRENTLY_DISABLED","API_DISABLED_FOR_ORG","EMAIL_TO_CASE_LIMIT_EXCEEDED",
"EMAIL_TO_CASE_NOT_ENABLED","EXCEEDED_ID_LIMIT","EXCEEDED_LEAD_CONVERT_LIMIT","EXCEEDED_MAX_SIZE_REQUEST",
"EXCEEDED_MAX_TYPES_LIMIT","EXCEEDED_QUOTA","EXCEEDED_RATE_LIMIT","FUNCTIONALITY_NOT_ENABLED",
"IMAGE_TOO_LARGE","INACTIVE_OWNER_OR_USER","INSUFFICIENT_ACCESS","INVALID_ASSIGNMENT_RULE",
"INVALID_BATCH_SIZE","INVALID_CLIENT","INVALID_CROSS_REFERENCE_KEY","INVALID_FIELD","INVALID_ID_FIELD",
"INVALID_LOGIN","INVALID_NEW_PASSWORD","INVALID_OPERATION","INVALID_OPERATION_WITH_EXPIRED_PASSWORD",
"INVALID_QUERY_FILTER_OPERATOR","INVALID_QUERY_LOCATOR","INVALID_QUERY_SCOPE","INVALID_REPLICATION_DATE",
"INVALID_SEARCH","INVALID_SEARCH_SCOPE","INVALID_SESSION_ID","INVALID_SOAP_HEADER",
"INVALID_SSO_GATEWAY_URL","INVALID_TYPE","INVALID_TYPE_FOR_OPERATION","LOGIN_DURING_RESTRICTED_DOMAIN",
"LOGIN_DURING_RESTRICTED_TIME","MALFORMED_ID","MALFORMED_QUERY","MALFORMED_SEARCH","MISSING_ARGUMENT",
"OPERATION_TOO_LARGE","ORG_LOCKED","PASSWORD_LOCKOUT","QUERY_TIMEOUT","QUERY_TOO_COMPLICATED",
"SERVER_UNAVAILABLE","SSO_SERVICE_DOWN","TRIAL_EXPIRED","UNKNOWN_EXCEPTION","UNSUPPORTED_API_VERSION",
"UNSUPPORTED_CLIENT"]
})
,
isc.SimpleType.create({
inheritsFrom:"QName",
name:"FaultCode",
valueMap:["fns:API_CURRENTLY_DISABLED","fns:API_DISABLED_FOR_ORG",
"fns:EMAIL_TO_CASE_LIMIT_EXCEEDED","fns:EMAIL_TO_CASE_NOT_ENABLED","fns:EXCEEDED_ID_LIMIT",
"fns:EXCEEDED_LEAD_CONVERT_LIMIT","fns:EXCEEDED_MAX_SIZE_REQUEST","fns:EXCEEDED_MAX_TYPES_LIMIT","fns:EXCEEDED_QUOTA",
"fns:EXCEEDED_RATE_LIMIT","fns:FUNCTIONALITY_NOT_ENABLED","fns:IMAGE_TOO_LARGE","fns:INACTIVE_OWNER_OR_USER",
"fns:INSUFFICIENT_ACCESS","fns:INVALID_ASSIGNMENT_RULE","fns:INVALID_BATCH_SIZE","fns:INVALID_CLIENT",
"fns:INVALID_CROSS_REFERENCE_KEY","fns:INVALID_FIELD","fns:INVALID_ID_FIELD","fns:INVALID_LOGIN",
"fns:INVALID_NEW_PASSWORD","fns:INVALID_OPERATION","fns:INVALID_OPERATION_WITH_EXPIRED_PASSWORD",
"fns:INVALID_QUERY_FILTER_OPERATOR","fns:INVALID_QUERY_LOCATOR","fns:INVALID_QUERY_SCOPE","fns:INVALID_REPLICATION_DATE",
"fns:INVALID_SEARCH","fns:INVALID_SEARCH_SCOPE","fns:INVALID_SESSION_ID","fns:INVALID_SOAP_HEADER",
"fns:INVALID_SSO_GATEWAY_URL","fns:INVALID_TYPE","fns:INVALID_TYPE_FOR_OPERATION",
"fns:LOGIN_DURING_RESTRICTED_DOMAIN","fns:LOGIN_DURING_RESTRICTED_TIME","fns:MALFORMED_ID","fns:MALFORMED_QUERY",
"fns:MALFORMED_SEARCH","fns:MISSING_ARGUMENT","fns:OPERATION_TOO_LARGE","fns:ORG_LOCKED",
"fns:PASSWORD_LOCKOUT","fns:QUERY_TIMEOUT","fns:QUERY_TOO_COMPLICATED","fns:SERVER_UNAVAILABLE",
"fns:SSO_SERVICE_DOWN","fns:TRIAL_EXPIRED","fns:UNKNOWN_EXCEPTION","fns:UNSUPPORTED_API_VERSION",
"fns:UNSUPPORTED_CLIENT"]
})
,
isc.XSComplexType.create({
ID:"ApiFault",
mustQualify:true,
fields:{
exceptionCode:{name:"exceptionCode",type:"ExceptionCode",xmlRequired:true},
exceptionMessage:{name:"exceptionMessage",type:"string",xmlRequired:true}
}
})
,
isc.XSComplexType.create({
ID:"ApiQueryFault",
inheritsFrom:"ApiFault",
mustQualify:true,
useParentFieldOrder:true,
fields:{
row:{name:"row",type:"int",xmlRequired:true},
column:{name:"column",type:"int",xmlRequired:true}
}
})
,
isc.XSComplexType.create({
ID:"LoginFault",
inheritsFrom:"ApiFault",
mustQualify:true,
useParentFieldOrder:true,
fields:{}
})
,
isc.XSElement.create({
ID:"LoginFault",
inheritsFrom:"LoginFault",
mustQualify:true,
fields:{}
})
,
isc.XSComplexType.create({
ID:"InvalidQueryLocatorFault",
inheritsFrom:"ApiFault",
mustQualify:true,
useParentFieldOrder:true,
fields:{}
})
,
isc.XSElement.create({
ID:"InvalidQueryLocatorFault",
inheritsFrom:"InvalidQueryLocatorFault",
mustQualify:true,
fields:{}
})
,
isc.XSComplexType.create({
ID:"InvalidNewPasswordFault",
inheritsFrom:"ApiFault",
mustQualify:true,
useParentFieldOrder:true,
fields:{}
})
,
isc.XSElement.create({
ID:"InvalidNewPasswordFault",
inheritsFrom:"InvalidNewPasswordFault",
mustQualify:true,
fields:{}
})
,
isc.XSComplexType.create({
ID:"InvalidIdFault",
inheritsFrom:"ApiFault",
mustQualify:true,
useParentFieldOrder:true,
fields:{}
})
,
isc.XSElement.create({
ID:"InvalidIdFault",
inheritsFrom:"InvalidIdFault",
mustQualify:true,
fields:{}
})
,
isc.XSComplexType.create({
ID:"UnexpectedErrorFault",
inheritsFrom:"ApiFault",
mustQualify:true,
useParentFieldOrder:true,
fields:{}
})
,
isc.XSElement.create({
ID:"UnexpectedErrorFault",
inheritsFrom:"UnexpectedErrorFault",
mustQualify:true,
fields:{}
})
,
isc.XSComplexType.create({
ID:"InvalidFieldFault",
inheritsFrom:"ApiQueryFault",
mustQualify:true,
useParentFieldOrder:true,
fields:{}
})
,
isc.XSElement.create({
ID:"InvalidFieldFault",
inheritsFrom:"InvalidFieldFault",
mustQualify:true,
fields:{}
})
,
isc.XSComplexType.create({
ID:"InvalidSObjectFault",
inheritsFrom:"ApiQueryFault",
mustQualify:true,
useParentFieldOrder:true,
fields:{}
})
,
isc.XSElement.create({
ID:"InvalidSObjectFault",
inheritsFrom:"InvalidSObjectFault",
mustQualify:true,
fields:{}
})
,
isc.XSComplexType.create({
ID:"MalformedQueryFault",
inheritsFrom:"ApiQueryFault",
mustQualify:true,
useParentFieldOrder:true,
fields:{}
})
,
isc.XSElement.create({
ID:"MalformedQueryFault",
inheritsFrom:"MalformedQueryFault",
mustQualify:true,
fields:{}
})
,
isc.XSComplexType.create({
ID:"MalformedSearchFault",
inheritsFrom:"ApiQueryFault",
mustQualify:true,
useParentFieldOrder:true,
fields:{}
})
,
isc.XSElement.create({
ID:"MalformedSearchFault",
inheritsFrom:"MalformedSearchFault",
mustQualify:true,
fields:{}
})
]
})
isc.WebService.create({
dataURL:"https://www.salesforce.com/services/Soap/u/6.0",
serviceNamespace:"urn:partner.soap.sforce.com",
soapStyle:"document",
operations:[
{
inputEncoding:"literal",
inputMessage:"loginRequest",
name:"login",
outputEncoding:"literal",
outputMessage:"loginResponse",
soapAction:"",
inputHeaders:[
{encoding:"literal",message:"Header",part:"CallOptions"}
]
},
{
inputEncoding:"literal",
inputMessage:"describeSObjectRequest",
name:"describeSObject",
outputEncoding:"literal",
outputMessage:"describeSObjectResponse",
soapAction:"",
inputHeaders:[
{encoding:"literal",message:"Header",part:"SessionHeader"},
{encoding:"literal",message:"Header",part:"CallOptions"}
]
},
{
inputEncoding:"literal",
inputMessage:"describeSObjectsRequest",
name:"describeSObjects",
outputEncoding:"literal",
outputMessage:"describeSObjectsResponse",
soapAction:"",
inputHeaders:[
{encoding:"literal",message:"Header",part:"SessionHeader"},
{encoding:"literal",message:"Header",part:"CallOptions"}
]
},
{
inputEncoding:"literal",
inputMessage:"describeGlobalRequest",
name:"describeGlobal",
outputEncoding:"literal",
outputMessage:"describeGlobalResponse",
soapAction:"",
inputHeaders:[
{encoding:"literal",message:"Header",part:"SessionHeader"},
{encoding:"literal",message:"Header",part:"CallOptions"}
]
},
{
inputEncoding:"literal",
inputMessage:"describeLayoutRequest",
name:"describeLayout",
outputEncoding:"literal",
outputMessage:"describeLayoutResponse",
soapAction:"",
inputHeaders:[
{encoding:"literal",message:"Header",part:"SessionHeader"},
{encoding:"literal",message:"Header",part:"CallOptions"}
]
},
{
inputEncoding:"literal",
inputMessage:"describeTabsRequest",
name:"describeTabs",
outputEncoding:"literal",
outputMessage:"describeTabsResponse",
soapAction:"",
inputHeaders:[
{encoding:"literal",message:"Header",part:"SessionHeader"},
{encoding:"literal",message:"Header",part:"CallOptions"}
]
},
{
inputEncoding:"literal",
inputMessage:"createRequest",
name:"create",
outputEncoding:"literal",
outputMessage:"createResponse",
soapAction:"",
inputHeaders:[
{encoding:"literal",message:"Header",part:"SessionHeader"},
{encoding:"literal",message:"Header",part:"CallOptions"},
{encoding:"literal",message:"Header",part:"AssignmentRuleHeader"}
]
},
{
inputEncoding:"literal",
inputMessage:"updateRequest",
name:"update",
outputEncoding:"literal",
outputMessage:"updateResponse",
soapAction:"",
inputHeaders:[
{encoding:"literal",message:"Header",part:"SessionHeader"},
{encoding:"literal",message:"Header",part:"CallOptions"},
{encoding:"literal",message:"Header",part:"AssignmentRuleHeader"}
]
},
{
inputEncoding:"literal",
inputMessage:"deleteRequest",
name:"delete",
outputEncoding:"literal",
outputMessage:"deleteResponse",
soapAction:"",
inputHeaders:[
{encoding:"literal",message:"Header",part:"SessionHeader"},
{encoding:"literal",message:"Header",part:"CallOptions"}
]
},
{
inputEncoding:"literal",
inputMessage:"retrieveRequest",
name:"retrieve",
outputEncoding:"literal",
outputMessage:"retrieveResponse",
soapAction:"",
inputHeaders:[
{encoding:"literal",message:"Header",part:"SessionHeader"},
{encoding:"literal",message:"Header",part:"CallOptions"},
{encoding:"literal",message:"Header",part:"QueryOptions"}
]
},
{
inputEncoding:"literal",
inputMessage:"convertLeadRequest",
name:"convertLead",
outputEncoding:"literal",
outputMessage:"convertLeadResponse",
soapAction:"",
inputHeaders:[
{encoding:"literal",message:"Header",part:"SessionHeader"},
{encoding:"literal",message:"Header",part:"CallOptions"}
]
},
{
inputEncoding:"literal",
inputMessage:"getDeletedRequest",
name:"getDeleted",
outputEncoding:"literal",
outputMessage:"getDeletedResponse",
soapAction:"",
inputHeaders:[
{encoding:"literal",message:"Header",part:"SessionHeader"},
{encoding:"literal",message:"Header",part:"CallOptions"}
]
},
{
inputEncoding:"literal",
inputMessage:"getUpdatedRequest",
name:"getUpdated",
outputEncoding:"literal",
outputMessage:"getUpdatedResponse",
soapAction:"",
inputHeaders:[
{encoding:"literal",message:"Header",part:"SessionHeader"},
{encoding:"literal",message:"Header",part:"CallOptions"}
]
},
{
inputEncoding:"literal",
inputMessage:"queryRequest",
name:"query",
outputEncoding:"literal",
outputMessage:"queryResponse",
soapAction:"",
inputHeaders:[
{encoding:"literal",message:"Header",part:"SessionHeader"},
{encoding:"literal",message:"Header",part:"CallOptions"},
{encoding:"literal",message:"Header",part:"QueryOptions"}
]
},
{
inputEncoding:"literal",
inputMessage:"queryMoreRequest",
name:"queryMore",
outputEncoding:"literal",
outputMessage:"queryMoreResponse",
soapAction:"",
inputHeaders:[
{encoding:"literal",message:"Header",part:"SessionHeader"},
{encoding:"literal",message:"Header",part:"CallOptions"},
{encoding:"literal",message:"Header",part:"QueryOptions"}
]
},
{
inputEncoding:"literal",
inputMessage:"searchRequest",
name:"search",
outputEncoding:"literal",
outputMessage:"searchResponse",
soapAction:"",
inputHeaders:[
{encoding:"literal",message:"Header",part:"SessionHeader"},
{encoding:"literal",message:"Header",part:"CallOptions"}
]
},
{
inputEncoding:"literal",
inputMessage:"getServerTimestampRequest",
name:"getServerTimestamp",
outputEncoding:"literal",
outputMessage:"getServerTimestampResponse",
soapAction:"",
inputHeaders:[
{encoding:"literal",message:"Header",part:"SessionHeader"},
{encoding:"literal",message:"Header",part:"CallOptions"}
]
},
{
inputEncoding:"literal",
inputMessage:"setPasswordRequest",
name:"setPassword",
outputEncoding:"literal",
outputMessage:"setPasswordResponse",
soapAction:"",
inputHeaders:[
{encoding:"literal",message:"Header",part:"SessionHeader"},
{encoding:"literal",message:"Header",part:"CallOptions"}
]
},
{
inputEncoding:"literal",
inputMessage:"resetPasswordRequest",
name:"resetPassword",
outputEncoding:"literal",
outputMessage:"resetPasswordResponse",
soapAction:"",
inputHeaders:[
{encoding:"literal",message:"Header",part:"SessionHeader"},
{encoding:"literal",message:"Header",part:"CallOptions"}
]
},
{
inputEncoding:"literal",
inputMessage:"getUserInfoRequest",
name:"getUserInfo",
outputEncoding:"literal",
outputMessage:"getUserInfoResponse",
soapAction:"",
inputHeaders:[
{encoding:"literal",message:"Header",part:"SessionHeader"},
{encoding:"literal",message:"Header",part:"CallOptions"}
]
}
],
messages:[
isc.WSDLMessage.create({
ID:"message:Header",
fields:{
SessionHeader:{name:"SessionHeader",type:"SessionHeader",xmlRequired:true},
CallOptions:{name:"CallOptions",type:"CallOptions",xmlRequired:true},
QueryOptions:{name:"QueryOptions",type:"QueryOptions",xmlRequired:true},
AssignmentRuleHeader:{name:"AssignmentRuleHeader",type:"AssignmentRuleHeader",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:ApiFault",
fields:{
fault:{name:"fault",type:"ApiFault",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:LoginFault",
fields:{
LoginFault:{name:"LoginFault",type:"LoginFault",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:InvalidQueryLocatorFault",
fields:{
InvalidQueryLocatorFault:{name:"InvalidQueryLocatorFault",type:"InvalidQueryLocatorFault",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:InvalidNewPasswordFault",
fields:{
InvalidNewPasswordFault:{name:"InvalidNewPasswordFault",type:"InvalidNewPasswordFault",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:InvalidIdFault",
fields:{
InvalidIdFault:{name:"InvalidIdFault",type:"InvalidIdFault",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:UnexpectedErrorFault",
fields:{
UnexpectedErrorFault:{name:"UnexpectedErrorFault",type:"UnexpectedErrorFault",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:InvalidFieldFault",
fields:{
InvalidFieldFault:{name:"InvalidFieldFault",type:"InvalidFieldFault",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:InvalidSObjectFault",
fields:{
InvalidSObjectFault:{name:"InvalidSObjectFault",type:"InvalidSObjectFault",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:MalformedQueryFault",
fields:{
MalformedQueryFault:{name:"MalformedQueryFault",type:"MalformedQueryFault",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:MalformedSearchFault",
fields:{
MalformedSearchFault:{name:"MalformedSearchFault",type:"MalformedSearchFault",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:loginRequest",
fields:{
login:{name:"login",type:"login",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:loginResponse",
fields:{
loginResponse:{name:"loginResponse",type:"loginResponse",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:describeSObjectRequest",
fields:{
describeSObject:{name:"describeSObject",type:"describeSObject",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:describeSObjectResponse",
fields:{
describeSObjectResponse:{name:"describeSObjectResponse",type:"describeSObjectResponse",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:describeSObjectsRequest",
fields:{
describeSObjects:{name:"describeSObjects",type:"describeSObjects",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:describeSObjectsResponse",
fields:{
describeSObjectsResponse:{name:"describeSObjectsResponse",type:"describeSObjectsResponse",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:describeGlobalRequest",
fields:{
describeGlobal:{name:"describeGlobal",type:"describeGlobal",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:describeGlobalResponse",
fields:{
describeGlobalResponse:{name:"describeGlobalResponse",type:"describeGlobalResponse",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:describeLayoutRequest",
fields:{
describeLayout:{name:"describeLayout",type:"describeLayout",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:describeLayoutResponse",
fields:{
describeLayoutResponse:{name:"describeLayoutResponse",type:"describeLayoutResponse",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:describeTabsRequest",
fields:{
describeTabs:{name:"describeTabs",type:"describeTabs",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:describeTabsResponse",
fields:{
describeTabsResponse:{name:"describeTabsResponse",type:"describeTabsResponse",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:createRequest",
fields:{
create:{name:"create",type:"create",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:createResponse",
fields:{
createResponse:{name:"createResponse",type:"createResponse",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:updateRequest",
fields:{
update:{name:"update",type:"update",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:updateResponse",
fields:{
updateResponse:{name:"updateResponse",type:"updateResponse",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:deleteRequest",
fields:{
"delete":{name:"delete",type:"delete",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:deleteResponse",
fields:{
deleteResponse:{name:"deleteResponse",type:"deleteResponse",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:retrieveRequest",
fields:{
retrieve:{name:"retrieve",type:"retrieve",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:retrieveResponse",
fields:{
retrieveResponse:{name:"retrieveResponse",type:"retrieveResponse",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:convertLeadRequest",
fields:{
convertLead:{name:"convertLead",type:"convertLead",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:convertLeadResponse",
fields:{
convertLeadResponse:{name:"convertLeadResponse",type:"convertLeadResponse",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:getDeletedRequest",
fields:{
getDeleted:{name:"getDeleted",type:"getDeleted",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:getDeletedResponse",
fields:{
getDeletedResponse:{name:"getDeletedResponse",type:"getDeletedResponse",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:getUpdatedRequest",
fields:{
getUpdated:{name:"getUpdated",type:"getUpdated",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:getUpdatedResponse",
fields:{
getUpdatedResponse:{name:"getUpdatedResponse",type:"getUpdatedResponse",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:queryRequest",
fields:{
query:{name:"query",type:"query",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:queryResponse",
fields:{
queryResponse:{name:"queryResponse",type:"queryResponse",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:queryMoreRequest",
fields:{
queryMore:{name:"queryMore",type:"queryMore",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:queryMoreResponse",
fields:{
queryMoreResponse:{name:"queryMoreResponse",type:"queryMoreResponse",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:searchRequest",
fields:{
search:{name:"search",type:"search",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:searchResponse",
fields:{
searchResponse:{name:"searchResponse",type:"searchResponse",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:getServerTimestampRequest",
fields:{
getServerTimestamp:{name:"getServerTimestamp",type:"getServerTimestamp",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:getServerTimestampResponse",
fields:{
getServerTimestampResponse:{name:"getServerTimestampResponse",type:"getServerTimestampResponse",
xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:setPasswordRequest",
fields:{
setPassword:{name:"setPassword",type:"setPassword",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:setPasswordResponse",
fields:{
setPasswordResponse:{name:"setPasswordResponse",type:"setPasswordResponse",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:resetPasswordRequest",
fields:{
resetPassword:{name:"resetPassword",type:"resetPassword",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:resetPasswordResponse",
fields:{
resetPasswordResponse:{name:"resetPasswordResponse",type:"resetPasswordResponse",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:getUserInfoRequest",
fields:{
getUserInfo:{name:"getUserInfo",type:"getUserInfo",xmlRequired:true}
}
})
,
isc.WSDLMessage.create({
ID:"message:getUserInfoResponse",
fields:{
getUserInfoResponse:{name:"getUserInfoResponse",type:"getUserInfoResponse",xmlRequired:true}
}
})
]
})
isc.SForce=isc.WebService.get("urn:partner.soap.sforce.com");if(isc.SForce){isc.A=isc.SForce.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.detailFields=["Id","Type","ParentId","LastModifiedDate","LastModifiedById","LastActivityDate","CreatedDate","CreatedById"];isc.A.hiddenFields=["SystemModstamp"];isc.B.push(isc.A.getHeaderData=function(_1){var _2={};if(_1.operationType=="fetch")_2.QueryOptions={batchSize:75};if(this.sessionId!=null)_2.SessionHeader={sessionId:this.sessionId};return _2}
,isc.A.login=function(_1,_2,_3){this.callOperation("login",{username:_1,password:_2},"//default:result",{target:this,methodName:"loginReply"},{willHandleError:true,$40z:_3,showPrompt:true,prompt:"Logging into SalesForce.."})}
,isc.A.loginReply=function(_1,_2,_3,_4){if(_3.status<0){return this.fireCallback(_4.$40z,"loginData",[false])}
var _5=_1[0];this.logDebug("login data: "+this.echo(_5));this.dataURL=_5.serverUrl;this.sessionId=_5.sessionId;this.logInfo("got sessionID: "+this.sessionId);this.fireCallback(_4.$40z,"loginData",[_5])}
,isc.A.ensureLoggedIn=function(_1,_2,_3){if(this.sessionId)return this.fireCallback(_1);var _4=this;isc.showLoginDialog(function(_5,_6){if(_5==null)return;_4.login(_5.username,_5.password,function(_7){_6(_7);if(_7)isc.Class.fireCallback(_1)})},isc.addProperties({title:"Please log in to SalesForce",dismissable:_2},_3))}
,isc.A.getEntityList=function(_1){this.$400=_1;this.callOperation("describeGlobal",null,"//default:types",{target:this,methodName:"describeGlobalReply"})}
,isc.A.describeGlobalReply=function(_1){this.fireCallback(this.$400,"list",[_1])}
,isc.A.getEntity=function(_1,_2){var _3=this;this.callOperation("describeSObjects",{sObjectType:_1},null,function(_4){_3.describeObjectReply(_4,_1,_2)})}
,isc.A.describeObjectReply=function(_1,_2,_3){var _4=_1.result,_5=_4.fields;var _6=this.convertSchema(_4,_2);if(this.logIsDebugEnabled()){this.logDebug("converted schema: "+this.echoAll(_6.getFields()))}
_6.sfFields=_4.fields;this.fireCallback(_3,"schema",[_6])}
,isc.A.convertSchema=function(_1,_2){var _3=_1.fields,_4=[];for(var i=0;i<_3.length;i++){var _6=_3[i],_7={};_7.name=_6.name;if(this.detailFields.contains(_7.name))_7.detail=true;if(this.hiddenFields.contains(_7.name))_7.hidden=true;var _8=_6.soapType;if(_8.contains(":"))_8=_8.substring(_8.indexOf(":")+1);_7.type=_8;_7.title=_6.label;_7.canEdit=_6.updateable;if(_6.type=="id")_7.primaryKey=true;if(_6.length!=0)_7.length=_6.length;_4.add(_7)}
var _9=_1.childRelationships,_10=[];if(_9){for(var i=0;i<_9.length;i++){var _11=_9[i];_10.add({dsName:_11.childSObject,fieldName:_11.field})}}
return isc.SFDataSource.create({sfName:_1.name,ID:_2,childRelations:_10,fields:_4})}
,isc.A.deploySControl=function(_1,_2){if(this.SControlDS==null){this.getEntity("SControl",function(_3){isc.SForce.SControlDS=_3;isc.SForce.deploySControl(_1,_2)});return}
var _3=this.SControlDS;_3.fetchData({Name:_1},function(_4,_5){isc.SForce.installSControl(_1,_2,_5,_3)})}
,isc.A.installSControl=function(_1,_2,_3,_4){var _5=this.getSControlHTML(_2);if(_3.length>0){_4.updateData({Id:_3[0].Id,HTMLWrapper:_5})}else{_4.addData({Name:_1,HTMLWrapper:_5})}}
,isc.A.getSControlHTML=function(_1){if(this.htmlPrefix==null){var _2=this.controlIsomorphicDir;this.htmlPrefix=["<HTML>\r<BODY>\r<SCRIPT>window.isomorphicDir = '",_2,"'</SCRIPT>\r","<SCRIPT src='",_2,"system/modules/ISC_Core.js'></SCRIPT>\r","<SCRIPT src='",_2,"system/modules/ISC_Foundation.js'></SCRIPT>\r","<SCRIPT src='",_2,"system/modules/ISC_Containers.js'></SCRIPT>\r","<SCRIPT src='",_2,"system/modules/ISC_Grids.js'></SCRIPT>\r","<SCRIPT src='",_2,"system/modules/ISC_Forms.js'></SCRIPT>\r","<SCRIPT src='",_2,"system/modules/ISC_DataBinding.js'></SCRIPT>\r","<SCRIPT src='",_2,"system/modules/ISC_SalesForce.js'></SCRIPT>\r","<SCRIPT src='",_2,"system/modules/ISC_Kapow.js'></SCRIPT>\r","<SCRIPT src='",_2,"skins/",this.controlSkin,"/load_skin.js'></SCRIPT>\r","<SCRIPT>\r",'   var service = isc.WebService.get("urn:partner.soap.sforce.com");\r','   service.sessionId = "{!User_Session_ID}";\r','   service.dataURL = "{!API_Partner_Server_URL_60}";\r\r'].join("")}
return this.htmlPrefix+_1+'</SCRIPT>\r</BODY></HTML>'}
);isc.B._maxIndex=isc.C+12;isc.defineClass("SFResultSet","ResultSet");isc.A=isc.SFResultSet.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.B.push(isc.A.transformData=function(_1,_2){this.context=this.context||{};this.context.queryLocator=_2.queryLocator}
,isc.A.setCriteria=function(_1){var _2=this.Super("setCriteria",arguments);if(_2){this.context=this.context||{};this.context.queryLocator=null}}
);isc.B._maxIndex=isc.C+2;isc.defineClass("SFDataSource","DataSource");isc.A=isc.SFDataSource.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.serviceNamespace="urn:partner.soap.sforce.com";isc.A.operationBindings=[{operationType:"fetch",wsOperation:"query",recordXPath:"//schema:records"},{operationType:"fetch",operationId:"queryMore",wsOperation:"queryMore",recordXPath:"//schema:records"},{operationType:"update",wsOperation:"update",recordName:"SaveResult"},{operationType:"add",wsOperation:"create",recordName:"SaveResult"},{operationType:"remove",wsOperation:"delete",recordName:"DeleteResult"}];isc.A.resultSetClass="SFResultSet";isc.A.autoLogin=true;isc.B.push(isc.A.transformRequest=function(_1){var _2=_1.data;if(!isc.isAn.Array(_2))_2=[_2];if(_1.operationType=="remove"){return{ids:_2.getProperty("Id")}}
if(_1.operationType!="fetch"){_2.setProperty("type",this.sfName||this.ID);return{sObjects:_2}}
if(_1.queryLocator){_1.operationId="queryMore";return{queryLocator:_1.queryLocator}}
var _3=_1.data,_4="select "+this.getFieldNames().join(",")+" "+"from "+(this.sfName||this.ID);if(_3!=null&&!isc.isAn.emptyObject(_3)){_4+=" where ";for(var _5 in _3){_4+=_5+"='"+_3[_5]+"' "}}
return{queryString:_4}}
,isc.A.transformResponse=function(_1,_2,_3){var _4=_2.operationType;if(_4!="fetch"){var _5=_3.selectString("//default:success");if(_5!="true"){_1.errors=this.convertValidationErrors(_3);this.logWarn("save failed, errors are: "+this.echo(_1.errors));_1.status=-1;return _1}
if(_4!="remove"){var _6=isc.addProperties({},_2.oldValues,_2.data.sObjects[0]);if(_4=="add"){_6.Id=_1.data[0].id}
_1.data=_6}else{var _7=_1.data[0].id;_1.data={Id:_7};this.logWarn("cache sync data on remove: "+this.echo(_1.data))}
return _1}
var _8=_3.selectString("//default:queryLocator");if(_8!=null&&!isc.isAn.emptyString(_8)){_1.queryLocator=_8}
_1.totalRows=_3.selectNumber("//default:size");var _9=_1.data;for(var i=0;i<_9.length;i++){if(isc.isAn.Array(_9[i].Id))_9[i].Id=_9[i].Id[0]}
return _1}
,isc.A.fetchData=function(_1,_2,_3,_4){var _5=this;if(this.autoLogin&&!_4){isc.SForce.ensureLoggedIn(function(){_5.fetchData(_1,_2,_3,true)});return}
return this.Super("fetchData",arguments)}
,isc.A.convertValidationErrors=function(_1){var _2=_1.selectNodes("//default:errors"),_3={};for(var i=0;i<_2.length;i++){var _5=_2[i];_5=isc.xml.toJS(_5);_3[_5.fields]=_5.message}
return _3}
);isc.B._maxIndex=isc.C+4}
isc._moduleEnd=isc._SalesForce_end=(isc.timestamp?isc.timestamp():new Date().getTime());if(isc.Log&&isc.Log.logIsInfoEnabled('loadTime'))isc.Log.logInfo('SalesForce module init time: ' + (isc._moduleEnd-isc._moduleStart) + 'ms','loadTime');}else{if(window.isc && isc.Log && isc.Log.logWarn)isc.Log.logWarn("Duplicate load of module 'SalesForce'.");}
/*
 * Isomorphic SmartClient
 * Version 7.2b (2009-08-08)
 * Copyright(c) 1998 and beyond Isomorphic Software, Inc. All rights reserved.
 * "SmartClient" is a trademark of Isomorphic Software, Inc.
 *
 * licensing@smartclient.com
 *
 * http://smartclient.com/license
 */

