/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.platform.yui.compressor.javascript;

import com.yahoo.platform.yui.compressor.javascript.BaseFunction;
import com.yahoo.platform.yui.compressor.javascript.Context;
import com.yahoo.platform.yui.compressor.javascript.Decompiler;
import com.yahoo.platform.yui.compressor.javascript.EvaluatorException;
import com.yahoo.platform.yui.compressor.javascript.NativeCall;
import com.yahoo.platform.yui.compressor.javascript.ScriptRuntime;
import com.yahoo.platform.yui.compressor.javascript.Scriptable;
import com.yahoo.platform.yui.compressor.javascript.UintMap;
import com.yahoo.platform.yui.compressor.javascript.debug.DebuggableScript;

public abstract class NativeFunction
extends BaseFunction {
    public final void initScriptFunction(Context cx, Scriptable scope) {
        ScriptRuntime.setFunctionProtoAndParent(this, scope);
    }

    final String decompile(int indent, int flags) {
        String encodedSource = this.getEncodedSource();
        if (encodedSource == null) {
            return super.decompile(indent, flags);
        }
        UintMap properties = new UintMap(1);
        properties.put(1, indent);
        return Decompiler.decompile(encodedSource, flags, properties);
    }

    public int getLength() {
        int paramCount = this.getParamCount();
        if (this.getLanguageVersion() != 120) {
            return paramCount;
        }
        Context cx = Context.getContext();
        NativeCall activation = ScriptRuntime.findFunctionActivation(cx, this);
        if (activation == null) {
            return paramCount;
        }
        return activation.originalArgs.length;
    }

    public int getArity() {
        return this.getParamCount();
    }

    public String jsGet_name() {
        return this.getFunctionName();
    }

    public String getEncodedSource() {
        return null;
    }

    public DebuggableScript getDebuggableView() {
        return null;
    }

    public Object resumeGenerator(Context cx, Scriptable scope, int operation, Object state, Object value) {
        throw new EvaluatorException("resumeGenerator() not implemented");
    }

    protected abstract int getLanguageVersion();

    protected abstract int getParamCount();

    protected abstract int getParamAndVarCount();

    protected abstract String getParamOrVarName(int var1);

    protected boolean getParamOrVarConst(int index) {
        return false;
    }
}

