/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.platform.yui.compressor.javascript;

import com.yahoo.platform.yui.compressor.javascript.FunctionNode;
import com.yahoo.platform.yui.compressor.javascript.Kit;
import com.yahoo.platform.yui.compressor.javascript.Node;
import com.yahoo.platform.yui.compressor.javascript.ObjArray;
import com.yahoo.platform.yui.compressor.javascript.ScriptOrFnNode;
import com.yahoo.platform.yui.compressor.javascript.ScriptRuntime;
import java.util.ArrayList;
import java.util.List;

public class NodeTransformer {
    private ObjArray loops;
    private ObjArray loopEnds;
    private boolean hasFinally;

    public final void transform(ScriptOrFnNode tree) {
        this.transformCompilationUnit(tree);
        for (int i = 0; i != tree.getFunctionCount(); ++i) {
            FunctionNode fn = tree.getFunctionNode(i);
            this.transform(fn);
        }
    }

    private void transformCompilationUnit(ScriptOrFnNode tree) {
        this.loops = new ObjArray();
        this.loopEnds = new ObjArray();
        this.hasFinally = false;
        boolean createScopeObjects = tree.getType() != 108 || ((FunctionNode)tree).requiresActivation();
        tree.flattenSymbolTable(!createScopeObjects);
        this.transformCompilationUnit_r(tree, tree, tree, createScopeObjects);
    }

    private void transformCompilationUnit_r(ScriptOrFnNode tree, Node parent, Node.Scope scope, boolean createScopeObjects) {
        Node node = null;
        block16: while (true) {
            Node previous = null;
            if (node == null) {
                node = parent.getFirstChild();
            } else {
                previous = node;
                node = node.getNext();
            }
            if (node == null) break;
            int type = node.getType();
            if (createScopeObjects && (type == 128 || type == 131 || type == 156) && node instanceof Node.Scope) {
                Node.Scope newScope = (Node.Scope)node;
                if (newScope.symbolTable != null) {
                    Node let = new Node(type == 156 ? 157 : 152);
                    Node innerLet = new Node(152);
                    let.addChildToBack(innerLet);
                    for (String name : newScope.symbolTable.keySet()) {
                        innerLet.addChildToBack(Node.newString(39, name));
                    }
                    newScope.symbolTable = null;
                    Node oldNode = node;
                    node = NodeTransformer.replaceCurrent(parent, previous, node, let);
                    type = node.getType();
                    let.addChildToBack(oldNode);
                }
            }
            switch (type) {
                case 113: 
                case 129: 
                case 131: {
                    this.loops.push(node);
                    this.loopEnds.push(((Node.Jump)node).target);
                    break;
                }
                case 122: {
                    this.loops.push(node);
                    Node leave = node.getNext();
                    if (leave.getType() != 3) {
                        Kit.codeBug();
                    }
                    this.loopEnds.push(leave);
                    break;
                }
                case 80: {
                    Node.Jump jump = (Node.Jump)node;
                    Node finallytarget = jump.getFinally();
                    if (finallytarget == null) break;
                    this.hasFinally = true;
                    this.loops.push(node);
                    this.loopEnds.push(finallytarget);
                    break;
                }
                case 3: 
                case 130: {
                    if (this.loopEnds.isEmpty() || this.loopEnds.peek() != node) break;
                    this.loopEnds.pop();
                    this.loops.pop();
                    break;
                }
                case 72: {
                    ((FunctionNode)tree).addResumptionPoint(node);
                    break;
                }
                case 4: {
                    Node n;
                    boolean isGenerator;
                    boolean bl = isGenerator = tree.getType() == 108 && ((FunctionNode)tree).isGenerator();
                    if (isGenerator) {
                        node.putIntProp(20, 1);
                    }
                    if (!this.hasFinally) break;
                    Node unwindBlock = null;
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        Node unwind;
                        n = (Node)this.loops.get(i);
                        int elemtype = n.getType();
                        if (elemtype != 80 && elemtype != 122) continue;
                        if (elemtype == 80) {
                            Node jsrtarget;
                            Node.Jump jsrnode = new Node.Jump(134);
                            jsrnode.target = jsrtarget = ((Node.Jump)n).getFinally();
                            unwind = jsrnode;
                        } else {
                            unwind = new Node(3);
                        }
                        if (unwindBlock == null) {
                            unwindBlock = new Node(128, node.getLineno());
                        }
                        unwindBlock.addChildToBack(unwind);
                    }
                    if (unwindBlock == null) break;
                    Node returnNode = node;
                    Node returnExpr = returnNode.getFirstChild();
                    node = NodeTransformer.replaceCurrent(parent, previous, node, unwindBlock);
                    if (returnExpr == null || isGenerator) {
                        unwindBlock.addChildToBack(returnNode);
                        continue block16;
                    }
                    Node store = new Node(133, returnExpr);
                    unwindBlock.addChildToFront(store);
                    returnNode = new Node(64);
                    unwindBlock.addChildToBack(returnNode);
                    this.transformCompilationUnit_r(tree, store, scope, createScopeObjects);
                    continue block16;
                }
                case 119: 
                case 120: {
                    Node n;
                    Node.Jump jump = (Node.Jump)node;
                    Node.Jump jumpStatement = jump.getJumpStatement();
                    if (jumpStatement == null) {
                        Kit.codeBug();
                    }
                    int i = this.loops.size();
                    while (true) {
                        if (i == 0) {
                            throw Kit.codeBug();
                        }
                        if ((n = (Node)this.loops.get(--i)) == jumpStatement) break;
                        int elemtype = n.getType();
                        if (elemtype == 122) {
                            Node leave = new Node(3);
                            previous = NodeTransformer.addBeforeCurrent(parent, previous, node, leave);
                            continue;
                        }
                        if (elemtype != 80) continue;
                        Node.Jump tryNode = (Node.Jump)n;
                        Node.Jump jsrFinally = new Node.Jump(134);
                        jsrFinally.target = tryNode.getFinally();
                        previous = NodeTransformer.addBeforeCurrent(parent, previous, node, jsrFinally);
                    }
                    jump.target = type == 119 ? jumpStatement.target : jumpStatement.getContinue();
                    jump.setType(5);
                    break;
                }
                case 38: {
                    this.visitCall(node, tree);
                    break;
                }
                case 30: {
                    this.visitNew(node, tree);
                    break;
                }
                case 152: 
                case 157: {
                    Node child = node.getFirstChild();
                    if (child.getType() == 152) {
                        boolean createWith = tree.getType() != 108 || ((FunctionNode)tree).requiresActivation();
                        node = this.visitLet(createWith, parent, previous, node);
                        break;
                    }
                }
                case 121: 
                case 153: {
                    Node result = new Node(128);
                    Node cursor = node.getFirstChild();
                    while (cursor != null) {
                        Node n = cursor;
                        cursor = cursor.getNext();
                        if (n.getType() == 39) {
                            if (!n.hasChildren()) continue;
                            Node init = n.getFirstChild();
                            n.removeChild(init);
                            n.setType(49);
                            n = new Node(type == 153 ? 154 : 8, n, init);
                        } else if (n.getType() != 157) {
                            throw Kit.codeBug();
                        }
                        Node pop = new Node(132, n, node.getLineno());
                        result.addChildToBack(pop);
                    }
                    node = NodeTransformer.replaceCurrent(parent, previous, node, result);
                    break;
                }
                case 136: {
                    Node.Scope defining = scope.getDefiningScope(node.getString());
                    if (defining == null) break;
                    node.setScope(defining);
                    break;
                }
                case 7: 
                case 32: {
                    Node child = node.getFirstChild();
                    if (type == 7) {
                        while (child.getType() == 26) {
                            child = child.getFirstChild();
                        }
                        if (child.getType() == 12 || child.getType() == 13) {
                            Node first = child.getFirstChild();
                            Node last = child.getLastChild();
                            if (first.getType() == 39 && first.getString().equals("undefined")) {
                                child = last;
                            } else if (last.getType() == 39 && last.getString().equals("undefined")) {
                                child = first;
                            }
                        }
                    }
                    if (child.getType() != 33) break;
                    child.setType(34);
                    break;
                }
                case 8: 
                case 31: 
                case 39: 
                case 154: {
                    String name;
                    Node.Scope defining;
                    Node nameSource;
                    Node n;
                    if (createScopeObjects) break;
                    if (type == 39) {
                        nameSource = node;
                    } else {
                        nameSource = node.getFirstChild();
                        if (nameSource.getType() != 49) {
                            if (type == 31) break;
                            throw Kit.codeBug();
                        }
                    }
                    if (nameSource.getScope() != null || (defining = scope.getDefiningScope(name = nameSource.getString())) == null) break;
                    nameSource.setScope(defining);
                    if (type == 39) {
                        node.setType(55);
                        break;
                    }
                    if (type == 8) {
                        node.setType(56);
                        nameSource.setType(41);
                        break;
                    }
                    if (type == 154) {
                        node.setType(155);
                        nameSource.setType(41);
                        break;
                    }
                    if (type == 31) {
                        n = new Node(44);
                        node = NodeTransformer.replaceCurrent(parent, previous, node, n);
                        break;
                    }
                    throw Kit.codeBug();
                }
            }
            this.transformCompilationUnit_r(tree, node, node instanceof Node.Scope ? (Node.Scope)node : scope, createScopeObjects);
        }
    }

    protected void visitNew(Node node, ScriptOrFnNode tree) {
    }

    protected void visitCall(Node node, ScriptOrFnNode tree) {
    }

    protected Node visitLet(boolean createWith, Node parent, Node previous, Node scopeNode) {
        Node result;
        boolean isExpression;
        Node vars = scopeNode.getFirstChild();
        Node body = vars.getNext();
        scopeNode.removeChild(vars);
        scopeNode.removeChild(body);
        boolean bl = isExpression = scopeNode.getType() == 157;
        if (createWith) {
            result = new Node(isExpression ? 158 : 128);
            result = NodeTransformer.replaceCurrent(parent, previous, scopeNode, result);
            ArrayList<Object> list = new ArrayList<Object>();
            Node objectLiteral = new Node(66);
            for (Node v = vars.getFirstChild(); v != null; v = v.getNext()) {
                Node current = v;
                if (current.getType() == 157) {
                    List destructuringNames = (List)current.getProp(22);
                    Node c = current.getFirstChild();
                    if (c.getType() != 152) {
                        throw Kit.codeBug();
                    }
                    body = isExpression ? new Node(88, c.getNext(), body) : new Node(128, new Node(132, c.getNext()), body);
                    if (destructuringNames != null) {
                        list.addAll(destructuringNames);
                        for (int i = 0; i < destructuringNames.size(); ++i) {
                            objectLiteral.addChildToBack(new Node(125, Node.newNumber(0.0)));
                        }
                    }
                    current = c.getFirstChild();
                }
                if (current.getType() != 39) {
                    throw Kit.codeBug();
                }
                list.add(ScriptRuntime.getIndexObject(current.getString()));
                Node init = current.getFirstChild();
                if (init == null) {
                    init = new Node(125, Node.newNumber(0.0));
                }
                objectLiteral.addChildToBack(init);
            }
            objectLiteral.putProp(12, list.toArray());
            Node newVars = new Node(2, objectLiteral);
            result.addChildToBack(newVars);
            result.addChildToBack(new Node(122, body));
            result.addChildToBack(new Node(3));
        } else {
            result = new Node(isExpression ? 88 : 128);
            result = NodeTransformer.replaceCurrent(parent, previous, scopeNode, result);
            Node newVars = new Node(88);
            for (Node v = vars.getFirstChild(); v != null; v = v.getNext()) {
                Node current = v;
                if (current.getType() == 157) {
                    Node c = current.getFirstChild();
                    if (c.getType() != 152) {
                        throw Kit.codeBug();
                    }
                    body = isExpression ? new Node(88, c.getNext(), body) : new Node(128, new Node(132, c.getNext()), body);
                    Node.Scope.joinScopes((Node.Scope)current, (Node.Scope)scopeNode);
                    current = c.getFirstChild();
                }
                if (current.getType() != 39) {
                    throw Kit.codeBug();
                }
                Node stringNode = Node.newString(current.getString());
                stringNode.setScope((Node.Scope)scopeNode);
                Node init = current.getFirstChild();
                if (init == null) {
                    init = new Node(125, Node.newNumber(0.0));
                }
                newVars.addChildToBack(new Node(56, stringNode, init));
            }
            if (isExpression) {
                result.addChildToBack(newVars);
                scopeNode.setType(88);
                result.addChildToBack(scopeNode);
                scopeNode.addChildToBack(body);
            } else {
                result.addChildToBack(new Node(132, newVars));
                scopeNode.setType(128);
                result.addChildToBack(scopeNode);
                scopeNode.addChildrenToBack(body);
            }
        }
        return result;
    }

    private static Node addBeforeCurrent(Node parent, Node previous, Node current, Node toAdd) {
        if (previous == null) {
            if (current != parent.getFirstChild()) {
                Kit.codeBug();
            }
            parent.addChildToFront(toAdd);
        } else {
            if (current != previous.getNext()) {
                Kit.codeBug();
            }
            parent.addChildAfter(toAdd, previous);
        }
        return toAdd;
    }

    private static Node replaceCurrent(Node parent, Node previous, Node current, Node replacement) {
        if (previous == null) {
            if (current != parent.getFirstChild()) {
                Kit.codeBug();
            }
            parent.replaceChild(current, replacement);
        } else if (previous.next == current) {
            parent.replaceChildAfter(previous, replacement);
        } else {
            parent.replaceChild(current, replacement);
        }
        return replacement;
    }
}

