/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.ysql;

import com.yugabyte.ysql.ClusterAwareLoadBalancer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class TopologyAwareLoadBalancer
extends ClusterAwareLoadBalancer {
    private final String placements;
    private final Map<Integer, Set<CloudPlacement>> allowedPlacements = new HashMap<Integer, Set<CloudPlacement>>();
    private final Map<Integer, ArrayList<String>> fallbackPrivateIPs = new HashMap<Integer, ArrayList<String>>();
    private final Map<Integer, ArrayList<String>> fallbackPublicIPs = new HashMap<Integer, ArrayList<String>>();
    private final int PRIMARY_PLACEMENTS = 1;
    private final int FIRST_FALLBACK = 2;
    private final int REST_OF_CLUSTER = -1;

    public TopologyAwareLoadBalancer(String placementValues) {
        this.placements = placementValues;
        this.parseGeoLocations();
    }

    @Override
    protected String loadBalancingNodes() {
        return this.placements;
    }

    private void populatePlacementSet(String placements, Set<CloudPlacement> allowedPlacements) {
        String[] pStrings;
        for (String pl : pStrings = placements.split(",")) {
            String[] placementParts = pl.split("\\.");
            if (placementParts.length != 3 || placementParts[0].equals("*") || placementParts[1].equals("*")) {
                LOGGER.log(Level.WARNING, "Malformed topology-keys property value: " + pl);
                throw new IllegalArgumentException("Malformed topology-keys property value: " + pl);
            }
            CloudPlacement cp = new CloudPlacement(placementParts[0], placementParts[1], placementParts[2]);
            LOGGER.log(Level.FINE, "Adding placement " + cp + " to allowed list");
            allowedPlacements.add(cp);
        }
    }

    private void parseGeoLocations() {
        String[] values;
        for (String value : values = this.placements.split(",")) {
            String[] v = value.split(":");
            if (v.length > 2 || value.endsWith(":")) {
                throw new IllegalArgumentException("Invalid value part for property topology-keys: " + value);
            }
            if (v.length == 1) {
                Set primary = this.allowedPlacements.computeIfAbsent(1, k -> new HashSet());
                this.populatePlacementSet(v[0], primary);
                continue;
            }
            int pref = Integer.valueOf(v[1]);
            if (pref == 1) {
                Set<CloudPlacement> primary = this.allowedPlacements.get(1);
                if (primary == null) {
                    primary = new HashSet<CloudPlacement>();
                    this.allowedPlacements.put(1, primary);
                }
                this.populatePlacementSet(v[0], primary);
                continue;
            }
            if (pref > 1 && pref <= 10) {
                Set<CloudPlacement> fallbackPlacements = this.allowedPlacements.get(pref);
                if (fallbackPlacements == null) {
                    fallbackPlacements = new HashSet<CloudPlacement>();
                    this.allowedPlacements.put(pref, fallbackPlacements);
                }
                this.populatePlacementSet(v[0], fallbackPlacements);
                continue;
            }
            throw new IllegalArgumentException("Invalid preference value for property topology-keys: " + value);
        }
    }

    @Override
    protected void clearHostIPLists() {
        super.clearHostIPLists();
        for (ArrayList<String> hosts : this.fallbackPrivateIPs.values()) {
            hosts.clear();
        }
        for (ArrayList<String> publicIPs : this.fallbackPublicIPs.values()) {
            publicIPs.clear();
        }
    }

    @Override
    protected void updateCurrentHostList(ArrayList<String> currentPrivateIps, String host, String publicIp, String cloud, String region, String zone) {
        CloudPlacement cp = new CloudPlacement(cloud, region, zone);
        if (cp.isContainedIn(this.allowedPlacements.get(1))) {
            LOGGER.log(Level.FINE, this.getLoadBalancerType() + ": allowedPlacements set: " + this.allowedPlacements + " returned contains true for cp: " + cp);
            currentPrivateIps.add(host);
            if (!publicIp.trim().isEmpty()) {
                this.currentPublicIps.add(publicIp);
            }
        } else {
            for (Map.Entry<Integer, Set<CloudPlacement>> allowedCPs : this.allowedPlacements.entrySet()) {
                if (!cp.isContainedIn(allowedCPs.getValue())) continue;
                LOGGER.fine("CloudPlacement " + cp + " is part of fallback level " + (allowedCPs.getKey() - 1));
                ArrayList hosts = this.fallbackPrivateIPs.computeIfAbsent(allowedCPs.getKey(), k -> new ArrayList());
                hosts.add(host);
                if (!publicIp.trim().isEmpty()) {
                    ArrayList publicIPs = this.fallbackPublicIPs.computeIfAbsent(allowedCPs.getKey(), k -> new ArrayList());
                    publicIPs.add(publicIp);
                }
                return;
            }
            ArrayList remainingHosts = this.fallbackPrivateIPs.computeIfAbsent(-1, k -> new ArrayList());
            remainingHosts.add(host);
            ArrayList remainingPublicIPs = this.fallbackPublicIPs.computeIfAbsent(-1, k -> new ArrayList());
            remainingPublicIPs.add(publicIp);
            LOGGER.log(Level.FINE, this.getLoadBalancerType() + ": allowedPlacements set: " + this.allowedPlacements + " returned contains false for cp: " + cp);
        }
    }

    @Override
    public boolean hasMorePreferredNode(String chosenHost) {
        Integer chosenHostPriority;
        if (this.hostToPriorityMap.containsKey(chosenHost) && (chosenHostPriority = (Integer)this.hostToPriorityMap.get(chosenHost)) != null) {
            for (int i = 1; i < chosenHostPriority; ++i) {
                if (!this.hostToPriorityMap.values().contains(i)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void updatePriorityMap(String host, String cloud, String region, String zone) {
        if (!this.unreachableHosts.containsKey(host)) {
            int priority = this.getPriority(cloud, region, zone);
            LOGGER.log(Level.FINE, "Priority of host " + host + " = " + priority);
            this.hostToPriorityMap.put(host, priority);
        }
    }

    private int getPriority(String cloud, String region, String zone) {
        CloudPlacement cp = new CloudPlacement(cloud, region, zone);
        return this.getKeysByValue(cp);
    }

    private int getKeysByValue(CloudPlacement cp) {
        for (int i = 1; i <= 10; ++i) {
            if (this.allowedPlacements.get(i) == null || this.allowedPlacements.get(i).isEmpty() || !cp.isContainedIn(this.allowedPlacements.get(i))) continue;
            LOGGER.log(Level.FINE, "Returning priority" + i);
            return i;
        }
        LOGGER.log(Level.FINE, "CloudPlacement " + cp + " does not belong to Primary_Placement or any of the Fallback_Placements so returning " + 10 + 1 + " as priority");
        return 11;
    }

    @Override
    public synchronized void updateFailedHosts(String chosenHost) {
        super.updateFailedHosts(chosenHost);
        for (int i = 2; i <= 10; ++i) {
            if (this.fallbackPrivateIPs.get(i) != null && !this.fallbackPrivateIPs.get(i).isEmpty() && this.fallbackPrivateIPs.get(i).contains(chosenHost)) {
                ArrayList hosts = this.fallbackPrivateIPs.computeIfAbsent(i, k -> new ArrayList());
                hosts.remove(chosenHost);
                LOGGER.log(Level.FINE, this.getLoadBalancerType() + ": Removing failed host " + chosenHost + " from fallback level " + (i - 1));
                return;
            }
            if (this.fallbackPublicIPs.get(i) == null || this.fallbackPublicIPs.get(i).isEmpty() || !this.fallbackPublicIPs.get(i).contains(chosenHost)) continue;
            ArrayList hosts = this.fallbackPublicIPs.computeIfAbsent(i, k -> new ArrayList());
            hosts.remove(chosenHost);
            LOGGER.log(Level.FINE, this.getLoadBalancerType() + ": Removing failed host " + chosenHost + " from fallback level " + (i - 1));
            return;
        }
        if (this.fallbackPrivateIPs.get(-1) != null && this.fallbackPrivateIPs.get(-1).contains(chosenHost)) {
            ArrayList hosts = this.fallbackPrivateIPs.computeIfAbsent(-1, k -> new ArrayList());
            hosts.remove(chosenHost);
            return;
        }
        if (this.fallbackPublicIPs.get(-1) != null && this.fallbackPublicIPs.get(-1).contains(chosenHost)) {
            ArrayList hosts = this.fallbackPublicIPs.computeIfAbsent(-1, k -> new ArrayList());
            hosts.remove(chosenHost);
        }
    }

    @Override
    public synchronized void decrementHostToNumConnCount(String chosenHost) {
        LOGGER.log(Level.FINE, this.getLoadBalancerType() + ": decreasing connection count of {0} in hostToNumConnCount by 1 as this connection is closed and a new connection to a host with higher priority will be created", new String[]{chosenHost});
        Integer currentCount = (Integer)this.hostToNumConnCount.get(chosenHost);
        if (currentCount != null && currentCount != 0) {
            this.hostToNumConnCount.put(chosenHost, currentCount - 1);
        }
    }

    @Override
    protected ArrayList<String> getPrivateOrPublicServers(ArrayList<String> privateHosts, ArrayList<String> publicHosts) {
        ArrayList<String> servers = super.getPrivateOrPublicServers(privateHosts, publicHosts);
        if (servers != null && !servers.isEmpty()) {
            return servers;
        }
        for (int i = 2; i <= 10; ++i) {
            if (this.fallbackPrivateIPs.get(i) == null || this.fallbackPrivateIPs.get(i).isEmpty()) continue;
            LOGGER.info("Attempting to connect servers in fallback level-" + (i - 1) + " ...");
            return super.getPrivateOrPublicServers(this.fallbackPrivateIPs.get(i), this.fallbackPublicIPs.get(i));
        }
        boolean limitFallbackToGivenTKs = Boolean.getBoolean("explicit-fallback-only");
        if (limitFallbackToGivenTKs) {
            return servers;
        }
        if (this.fallbackPrivateIPs.get(-1) != null) {
            LOGGER.fine("Returning servers from rest of the cluster: " + this.fallbackPrivateIPs.get(-1));
        }
        return super.getPrivateOrPublicServers(this.fallbackPrivateIPs.get(-1), this.fallbackPublicIPs.get(-1));
    }

    @Override
    protected String getLoadBalancerType() {
        return "TopologyAwareLoadBalancer";
    }

    static class CloudPlacement {
        private final String cloud;
        private final String region;
        private final String zone;

        CloudPlacement(String cloud, String region, String zone) {
            this.cloud = cloud;
            this.region = region;
            this.zone = zone;
        }

        public boolean isContainedIn(Set<CloudPlacement> set) {
            if (this.zone.equals("*")) {
                for (CloudPlacement cp : set) {
                    if (!cp.cloud.equalsIgnoreCase(this.cloud) || !cp.region.equalsIgnoreCase(this.region)) continue;
                    return true;
                }
            } else {
                for (CloudPlacement cp : set) {
                    if (!cp.cloud.equalsIgnoreCase(this.cloud) || !cp.region.equalsIgnoreCase(this.region) || !cp.zone.equalsIgnoreCase(this.zone) && !cp.zone.equals("*")) continue;
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.cloud.hashCode() ^ this.region.hashCode() ^ this.zone.hashCode();
        }

        public boolean equals(Object other) {
            boolean equal = false;
            ClusterAwareLoadBalancer.LOGGER.log(Level.FINE, "equals called for this: " + this + " and other = " + other);
            if (other instanceof CloudPlacement) {
                CloudPlacement o = (CloudPlacement)other;
                equal = this.cloud.equalsIgnoreCase(o.cloud) && this.region.equalsIgnoreCase(o.region) && this.zone.equalsIgnoreCase(o.zone);
            }
            ClusterAwareLoadBalancer.LOGGER.log(Level.FINE, "equals returning: " + equal);
            return equal;
        }

        public String toString() {
            return "Placement: " + this.cloud + "." + this.region + "." + this.zone;
        }
    }
}

