/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.classfile.AttrInfo;
import com.yworks.yguard.obf.classfile.ClassFile;
import com.yworks.yguard.obf.classfile.ConstantPool;
import com.yworks.yguard.obf.classfile.NameAndTypeCpInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;

public class EnclosingMethodAttrInfo
extends AttrInfo {
    private int u2classIndex;
    private int u2nameAndTypeIndex;

    protected EnclosingMethodAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected String getAttrName() {
        return "EnclosingMethod";
    }

    protected int getClassIndex() {
        return this.u2classIndex;
    }

    protected void setClassIndex(int index) {
        this.u2classIndex = index;
    }

    protected int getNameAndTypeIndex() {
        return this.u2nameAndTypeIndex;
    }

    protected void setNameAndTypeIndex(int index) {
        this.u2nameAndTypeIndex = index;
    }

    @Override
    protected void markUtf8RefsInInfo(ConstantPool pool) {
        if (this.u2nameAndTypeIndex > 0) {
            NameAndTypeCpInfo ntcpi = (NameAndTypeCpInfo)pool.getCpEntry(this.u2nameAndTypeIndex);
            ntcpi.incRefCount();
        }
    }

    @Override
    protected void readInfo(DataInput din) throws IOException {
        this.u2classIndex = din.readUnsignedShort();
        this.u2nameAndTypeIndex = din.readUnsignedShort();
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException {
        dout.writeShort(this.u2classIndex);
        dout.writeShort(this.u2nameAndTypeIndex);
    }

    public void dump(PrintWriter pw, ClassFile cf, int index) {
        pw.println("  EnclosingMethod ");
    }
}

