/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yshrink.ant.filters;

import com.yworks.common.ant.PatternMatchedSection;
import com.yworks.common.ant.TypePatternSet;
import com.yworks.yshrink.ant.ClassSection;
import com.yworks.yshrink.ant.filters.PatternMatchedFilter;
import com.yworks.yshrink.model.ClassDescriptor;
import com.yworks.yshrink.model.FieldDescriptor;
import com.yworks.yshrink.model.MethodDescriptor;
import com.yworks.yshrink.model.Model;
import com.yworks.yshrink.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.Project;

public class ClassFilter
extends PatternMatchedFilter {
    private List<ClassSection> sections;

    public ClassFilter(Project project) {
        super(project);
    }

    @Override
    public boolean isEntryPointClass(Model model, ClassDescriptor cd) {
        boolean r = false;
        for (ClassSection cs : this.sections) {
            if (!this.matches(cs, model, cd)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(ClassSection cs, Model model, ClassDescriptor cd) {
        boolean self;
        String entryClassName;
        String className = cd.getName();
        boolean r = true;
        if (!(null == cs.getClassAccess() || cs.getName() != null && cs.getName() != "" || cs.getClassAccess().equals((Object)PatternMatchedSection.Access.NONE))) {
            r &= cs.getClassAccess().isAccessLevel(cd.getAccess());
        }
        r = null == (entryClassName = cs.getName()) || entryClassName.length() == 0 ? (r &= this.match(TypePatternSet.Type.NAME, Util.toJavaClass(className), cs) || this.match(TypePatternSet.Type.NAME, className, cs)) : (r &= entryClassName.equals(className));
        if (null != cs.getExtends()) {
            self = cs.getExtends().equals(cd.getName());
            if (!self) {
                Set<String> ancestors = cd.getAllAncestorClasses(model);
                r &= ancestors.contains(cs.getExtends());
            } else {
                r &= self;
            }
        }
        if (null != cs.getImplements()) {
            self = cs.getImplements().equals(cd.getName());
            if (!self) {
                Set<String> interfaces = cd.getAllImplementedInterfaces(model);
                r &= interfaces.contains(cs.getImplements());
            } else {
                r &= self;
            }
        }
        return r;
    }

    private List<ClassSection> getAllMatchingClassSections(Model model, ClassDescriptor cd) {
        ArrayList<ClassSection> matchingSections = new ArrayList<ClassSection>();
        for (ClassSection cs : this.sections) {
            if (!this.matches(cs, model, cd)) continue;
            matchingSections.add(cs);
        }
        return matchingSections;
    }

    @Override
    public boolean isEntryPointField(Model model, ClassDescriptor cd, FieldDescriptor fd) {
        for (ClassSection cs : this.getAllMatchingClassSections(model, cd)) {
            boolean r = false;
            PatternMatchedSection.Access acc = cs.getFieldAccess();
            if (null != acc) {
                r = acc.isAccessLevel(fd.getAccess());
            }
            if (!r) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEntryPointMethod(Model model, ClassDescriptor cd, MethodDescriptor md) {
        for (ClassSection cs : this.getAllMatchingClassSections(model, cd)) {
            boolean r = true;
            PatternMatchedSection.Access acc = cs.getMethodAccess();
            if (null != acc) {
                boolean bl = r = r && acc.isAccessLevel(md.getAccess());
            }
            if (!r) continue;
            return true;
        }
        return false;
    }

    public void addClassSection(ClassSection cs) {
        if (null == this.sections) {
            this.sections = new ArrayList<ClassSection>(5);
        }
        this.sections.add(cs);
    }
}

