/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.proxy;

import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class StatementProxy
implements Statement {
    protected final IHikariConnectionProxy connection;
    protected final Statement delegate;
    private boolean isClosed;

    protected StatementProxy(IHikariConnectionProxy connection, Statement statement) {
        this.connection = connection;
        this.delegate = statement;
    }

    protected final void checkException(SQLException e) {
        this.connection.checkException(e);
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.connection.untrackStatement(this);
        try {
            this.delegate.close();
        }
        catch (SQLException e) {
            this.connection.checkException(e);
            throw e;
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            return this.delegate.executeQuery(sql);
        }
        catch (SQLException e) {
            this.connection.checkException(e);
            throw e;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            return this.delegate.getResultSet();
        }
        catch (SQLException e) {
            this.connection.checkException(e);
            throw e;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            return this.delegate.getGeneratedKeys();
        }
        catch (SQLException e) {
            this.connection.checkException(e);
            throw e;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this.delegate)) {
            return (T)this.delegate;
        }
        throw new SQLException("Wrapped connection is not an instance of " + iface);
    }
}

