/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.pool;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.pool.BaseHikariPool;
import com.zaxxer.hikari.pool.PoolBagEntry;
import com.zaxxer.hikari.util.ConcurrentBag;
import com.zaxxer.hikari.util.IBagStateListener;
import com.zaxxer.hikari.util.Java8ConcurrentBag;
import com.zaxxer.hikari.util.UtilityElf;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public final class HikariPool
extends BaseHikariPool {
    public HikariPool(HikariConfig configuration) {
        this(configuration, configuration.getUsername(), configuration.getPassword());
    }

    public HikariPool(HikariConfig configuration, String username, String password) {
        super(configuration, username, password);
    }

    @Override
    public void addBagItem() {
        this.addConnectionExecutor.execute(() -> {
            long sleepBackoff = 200L;
            int maxPoolSize = this.configuration.getMaximumPoolSize();
            while (this.poolState == 0 && this.totalConnections.get() < maxPoolSize && !this.addConnection()) {
                UtilityElf.quietlySleep(sleepBackoff);
                sleepBackoff = Math.min(this.connectionTimeout / 2L, (long)((double)sleepBackoff * 1.5));
            }
        });
    }

    @Override
    public void softEvictConnections() {
        this.connectionBag.values(1).forEach(bagEntry -> {
            bagEntry.evicted = true;
        });
        this.connectionBag.values(0).stream().filter(p -> this.connectionBag.reserve(p)).forEach(bagEntry -> this.closeConnection((PoolBagEntry)bagEntry));
    }

    @Override
    protected void closeConnection(PoolBagEntry bagEntry) {
        bagEntry.cancelMaxLifeTermination();
        if (this.connectionBag.remove(bagEntry)) {
            int tc = this.totalConnections.decrementAndGet();
            if (tc < 0) {
                this.LOGGER.warn("Internal accounting inconsistency, totalConnections={}", (Object)tc, (Object)new Exception());
            }
            Connection connection = bagEntry.connection;
            this.closeConnectionExecutor.execute(() -> this.poolUtils.quietlyCloseConnection(connection));
        }
        bagEntry.connection = null;
    }

    @Override
    protected boolean isConnectionAlive(Connection connection) {
        try {
            int timeoutSec = (int)TimeUnit.MILLISECONDS.toSeconds(this.validationTimeout);
            if (this.isUseJdbc4Validation) {
                return connection.isValid(timeoutSec);
            }
            int originalTimeout = this.poolUtils.getAndSetNetworkTimeout(connection, this.validationTimeout);
            try (Statement statement = connection.createStatement();){
                this.poolUtils.setQueryTimeout(statement, timeoutSec);
                statement.executeQuery(this.configuration.getConnectionTestQuery());
            }
            if (this.isIsolateInternalQueries && !this.isAutoCommit) {
                connection.rollback();
            }
            this.poolUtils.setNetworkTimeout(connection, originalTimeout);
            return true;
        }
        catch (SQLException e) {
            this.LOGGER.warn("Exception during keep alive check, that means the connection ({}) must be dead.", (Object)connection, (Object)e);
            return false;
        }
    }

    @Override
    protected void abortActiveConnections(ExecutorService assassinExecutor) throws InterruptedException {
        this.connectionBag.values(1).stream().forEach(bagEntry -> {
            try {
                bagEntry.evicted = true;
                bagEntry.aborted = true;
                bagEntry.connection.abort(assassinExecutor);
            }
            catch (AbstractMethodError | NoSuchMethodError | SQLException e) {
                this.poolUtils.quietlyCloseConnection(bagEntry.connection);
            }
            finally {
                bagEntry.connection = null;
                if (this.connectionBag.remove(bagEntry)) {
                    this.totalConnections.decrementAndGet();
                }
            }
        });
    }

    @Override
    protected Runnable getHouseKeeper() {
        return new HouseKeeper();
    }

    @Override
    protected ConcurrentBag<PoolBagEntry> createConcurrentBag(IBagStateListener listener) {
        return new Java8ConcurrentBag(listener);
    }

    private class HouseKeeper
    implements Runnable {
        private HouseKeeper() {
        }

        @Override
        public void run() {
            HikariPool.this.logPoolState("Before cleanup ");
            HikariPool.this.connectionTimeout = HikariPool.this.configuration.getConnectionTimeout();
            HikariPool.this.validationTimeout = HikariPool.this.configuration.getValidationTimeout();
            long now = System.currentTimeMillis();
            long idleTimeout = HikariPool.this.configuration.getIdleTimeout();
            HikariPool.this.connectionBag.values(0).stream().filter(p -> HikariPool.this.connectionBag.reserve(p)).forEach(bagEntry -> {
                if (bagEntry.evicted || idleTimeout > 0L && now > bagEntry.lastAccess + idleTimeout) {
                    HikariPool.this.closeConnection((PoolBagEntry)bagEntry);
                } else {
                    HikariPool.this.connectionBag.unreserve(bagEntry);
                }
            });
            HikariPool.this.logPoolState("After cleanup ");
            HikariPool.this.fillPool();
        }
    }
}

