/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.dataprovider;

import com.zebrunner.carina.utils.R;
import com.zebrunner.carina.utils.StringGenerator;
import com.zebrunner.carina.utils.config.Configuration;
import com.zebrunner.carina.utils.config.ConfigurationOption;
import com.zebrunner.carina.utils.config.StandardConfigurationOption;
import com.zebrunner.carina.utils.exception.InvalidArgsException;
import com.zebrunner.carina.utils.parser.xls.XLSParser;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestNGMethod;

public class DataProviderParameterGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Pattern GENERATE_UUID_PATTERN = Pattern.compile("\\{generate_uuid\\}");
    private static final Pattern GENERATE_PATTERN = Pattern.compile("\\{generate:\\d*\\}");
    private static final Pattern GENERATEAN_PATTERN = Pattern.compile("\\{generatean:\\d*\\}");
    private static final Pattern GENERATEN_PATTERN = Pattern.compile("\\{generaten:\\d*\\}");
    private static final Pattern TESTDATA_PATTERN = Pattern.compile("\\{testdata:.*\\}");
    private static final Pattern ENV_PATTERN = Pattern.compile("\\{env:.*\\}");
    private static final Pattern EXCEL_PATTERN = Pattern.compile("\\{excel:.*\\}");
    private static String uuid;

    private DataProviderParameterGenerator() {
    }

    public static Object process(String param) {
        try {
            if (param == null || param.equalsIgnoreCase("nil")) {
                return null;
            }
            Matcher matcher = GENERATE_UUID_PATTERN.matcher(param);
            if (matcher.find()) {
                return StringUtils.replace((String)param, (String)matcher.group(), (String)uuid);
            }
            matcher = GENERATE_PATTERN.matcher(param);
            if (matcher.find()) {
                int start = param.indexOf(58) + 1;
                int end = param.indexOf(125);
                int size = Integer.parseInt(param.substring(start, end));
                return StringUtils.replace((String)param, (String)matcher.group(), (String)StringGenerator.generateWord((int)size));
            }
            matcher = GENERATEAN_PATTERN.matcher(param);
            if (matcher.find()) {
                int start = param.indexOf(58) + 1;
                int end = param.indexOf(125);
                int size = Integer.parseInt(param.substring(start, end));
                return StringUtils.replace((String)param, (String)matcher.group(), (String)StringGenerator.generateWordAN((int)size));
            }
            matcher = GENERATEN_PATTERN.matcher(param);
            if (matcher.find()) {
                int start = param.indexOf(58) + 1;
                int end = param.indexOf(125);
                int size = Integer.parseInt(param.substring(start, end));
                return StringUtils.replace((String)param, (String)matcher.group(), (String)StringGenerator.generateNumeric((int)size));
            }
            matcher = ENV_PATTERN.matcher(param);
            if (matcher.find()) {
                int start = param.indexOf(58) + 1;
                int end = param.indexOf(125);
                String key = param.substring(start, end);
                return StringUtils.replace((String)param, (String)matcher.group(), (String)Configuration.get((String)key, (ConfigurationOption[])new ConfigurationOption[]{StandardConfigurationOption.ENVIRONMENT}).orElse(""));
            }
            matcher = TESTDATA_PATTERN.matcher(param);
            if (matcher.find()) {
                int start = param.indexOf(58) + 1;
                int end = param.indexOf(125);
                String key = param.substring(start, end);
                return StringUtils.replace((String)param, (String)matcher.group(), (String)R.TESTDATA.get(key));
            }
            matcher = EXCEL_PATTERN.matcher(param);
            if (matcher.find()) {
                int start = param.indexOf(58) + 1;
                int end = param.indexOf(125);
                String key = param.substring(start, end);
                return StringUtils.replace((String)param, (String)matcher.group(), (String)DataProviderParameterGenerator.getValueFromXLS(key));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return param;
    }

    public static void processMap(Map<String, String> paramsMap) {
        paramsMap.entrySet().stream().filter(Objects::nonNull).forEach(entry -> {
            String value = (String)entry.getValue();
            if (value == null) {
                return;
            }
            Object param = DataProviderParameterGenerator.process(value);
            if (param == null) {
                return;
            }
            String newValue = param.toString();
            if (!value.equals(newValue)) {
                entry.setValue(newValue);
            }
        });
    }

    private static String getValueFromXLS(String xlsSheetKey) {
        if (StringUtils.isEmpty((CharSequence)xlsSheetKey)) {
            throw new InvalidArgsException("Invalid excel key, should be 'xls_file#sheet#key'.");
        }
        String xls = xlsSheetKey.split("#")[0];
        String sheet = xlsSheetKey.split("#")[1];
        String key = xlsSheetKey.split("#")[2];
        return XLSParser.parseValue(xls, sheet, key);
    }

    public static String getUUID() {
        return uuid;
    }

    public static void setUUID(String uUID) {
        uuid = uUID;
    }

    public static String hash(Object[] args, ITestNGMethod method) {
        Object toHash = "";
        toHash = (String)toHash + Arrays.hashCode(args);
        toHash = (String)toHash + method.getMethodName();
        toHash = (String)toHash + method.getRealClass();
        return String.valueOf(((String)toHash).hashCode());
    }
}

