/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils.parser.xls;

import com.zebrunner.carina.dataprovider.DataLoadingException;
import com.zebrunner.carina.utils.exception.InvalidArgsException;
import com.zebrunner.carina.utils.parser.xls.XLSCache;
import com.zebrunner.carina.utils.parser.xls.XLSChildTable;
import com.zebrunner.carina.utils.parser.xls.XLSTable;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.model.ExternalLinksTable;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFTable;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLSParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final DataFormatter df = new DataFormatter();
    private static FormulaEvaluator evaluator;

    private XLSParser() {
    }

    public static String parseValue(String locatorKey, String xlsPath, Locale locale) {
        String value;
        Workbook wb = XLSCache.getWorkbook(xlsPath);
        Sheet sheet = wb.getSheetAt(0);
        List<String> locales = XLSParser.getLocales(sheet);
        if (!locales.contains(locale.getCountry())) {
            throw new RuntimeException(String.format("Can't find locale '%s' in xls '%s'!", locale.getCountry(), xlsPath));
        }
        int cellN = locales.indexOf(locale.getCountry()) + 1;
        List<String> locatorKeys = XLSParser.getLocatorKeys(sheet);
        if (!locatorKeys.contains(locatorKey)) {
            throw new RuntimeException(String.format("Can't find locatorKey '%s' in xls '%s'!", locatorKey, xlsPath));
        }
        int rowN = locatorKeys.indexOf(locatorKey) + 1;
        try {
            value = XLSParser.getCellValue(sheet.getRow(rowN).getCell(cellN));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Can't find value for locatorKey '%s' with locale '%s' in xls '%s'!", locatorKey, locale.getCountry(), xlsPath));
        }
        return value;
    }

    private static List<String> getLocales(Sheet sheet) {
        ArrayList<String> locales = new ArrayList<String>();
        int lastCell = sheet.getRow(0).getLastCellNum();
        for (int i = 1; i < lastCell; ++i) {
            locales.add(XLSParser.getCellValue(sheet.getRow(0).getCell(i)));
        }
        return locales;
    }

    private static List<String> getLocatorKeys(Sheet sheet) {
        ArrayList<String> locatorKeys = new ArrayList<String>();
        int lastRow = sheet.getLastRowNum();
        for (int i = 1; i <= lastRow; ++i) {
            locatorKeys.add(XLSParser.getCellValue(sheet.getRow(i).getCell(0)));
        }
        return locatorKeys;
    }

    public static String parseValue(String xls, String sheetName, String key) {
        String value = null;
        Workbook wb = XLSCache.getWorkbook(xls);
        Sheet sheet = wb.getSheet(sheetName);
        if (sheet == null) {
            throw new InvalidArgsException(String.format("No sheet: '%s' in excel file: '%s'!", sheetName, xls));
        }
        boolean isKeyFound = false;
        for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
            if (!key.equals(XLSParser.getCellValue(sheet.getRow(i).getCell(0)))) continue;
            value = XLSParser.getCellValue(sheet.getRow(i).getCell(1));
            isKeyFound = true;
            break;
        }
        if (!isKeyFound) {
            throw new InvalidArgsException(String.format("No key: '%s' on sheet '%s' in excel file: '%s'!", key, sheetName, xls));
        }
        return value;
    }

    public static XLSTable parseSpreadSheet(String xls, String sheetName) {
        return XLSParser.parseSpreadSheet(xls, sheetName, null, null);
    }

    public static XLSTable parseSpreadSheet(String xls, String sheetName, String executeColumn, String executeValue) {
        XLSTable dataTable = XLSParser.prepareDataTable(executeColumn, executeValue);
        Workbook wb = XLSCache.getWorkbook(xls);
        evaluator = wb.getCreationHelper().createFormulaEvaluator();
        Sheet sheet = wb.getSheet(sheetName);
        if (sheet == null) {
            throw new InvalidArgsException(String.format("No sheet: '%s' in excel file: '%s'!", sheetName, xls));
        }
        try {
            for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
                if (i == 0) {
                    dataTable.setHeaders(sheet.getRow(i));
                    continue;
                }
                dataTable.addDataRow(sheet.getRow(i), wb, sheet);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while parsing spreadsheet!", (Throwable)e);
        }
        return dataTable;
    }

    public static String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case STRING: {
                return df.formatCellValue(cell).trim();
            }
            case NUMERIC: {
                return df.formatCellValue(cell).trim();
            }
            case BOOLEAN: {
                return df.formatCellValue(cell).trim();
            }
            case FORMULA: {
                return cell.getCellFormula().contains("[") && cell.getCellFormula().contains("]") ? null : df.formatCellValue(cell, evaluator).trim();
            }
            case BLANK: {
                return "";
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XLSChildTable parseCellLinks(Cell cell, Workbook wb, Sheet sheet) {
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() != CellType.FORMULA) return null;
        if (cell.getCellFormula().contains("#This Row")) {
            if (cell.getCellFormula().contains("!")) {
                List<String> paths = Arrays.asList(cell.getCellFormula().split("!"));
                int externalLinkNumber = Integer.parseInt(paths.get(0).replaceAll("\\D+", "")) - 1;
                String tableName = paths.get(1).split("\\[")[0];
                if (!(wb instanceof XSSFWorkbook)) throw new DataLoadingException("Unsupported format. External links supports only for .xlsx documents.");
                ExternalLinksTable link = (ExternalLinksTable)((XSSFWorkbook)wb).getExternalLinksTable().get(externalLinkNumber);
                File file = new File(Objects.requireNonNull(XLSCache.getWorkbookPath(wb)));
                XSSFWorkbook childWb = (XSSFWorkbook)XLSCache.getWorkbook(file.getParent() + "/" + link.getLinkedFileName());
                if (childWb == null) {
                    throw new DataLoadingException(String.format("WorkBook '%s' doesn't exist!", link.getLinkedFileName()));
                }
                for (int i = 0; i < childWb.getNumberOfSheets(); ++i) {
                    XSSFSheet childSheet = childWb.getSheetAt(i);
                    for (XSSFTable table : childSheet.getTables()) {
                        if (!table.getName().equals(tableName)) continue;
                        return XLSParser.createChildTable((Sheet)childSheet, cell.getRowIndex());
                    }
                }
                return null;
            } else {
                List<String> paths = Arrays.asList(cell.getCellFormula().replace("=", "").split("\\["));
                if (!(wb instanceof XSSFWorkbook)) throw new DataLoadingException("Unsupported format. Links with table name supports only for .xlsx documents.");
                for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                    XSSFSheet childSheet = (XSSFSheet)wb.getSheetAt(i);
                    for (XSSFTable table : childSheet.getTables()) {
                        if (!table.getName().equals(paths.get(0))) continue;
                        return XLSParser.createChildTable((Sheet)childSheet, cell.getRowIndex());
                    }
                }
            }
            return null;
        } else {
            String cellValue = cell.getCellFormula().replace("=", "").replace("[", "").replace("]", "!").replace("'", "");
            List<String> paths = Arrays.asList(cellValue.split("!"));
            int rowNumber = 0;
            Sheet childSheet = null;
            switch (paths.size()) {
                case 1: {
                    rowNumber = Integer.parseInt(paths.get(0).replaceAll("\\D+", "")) - 1;
                    return XLSParser.createChildTable(sheet, rowNumber);
                }
                case 2: {
                    childSheet = wb.getSheet(paths.get(0));
                    if (childSheet == null) {
                        throw new DataLoadingException(String.format("Sheet '%s' doesn't exist!", paths.get(0)));
                    }
                    rowNumber = Integer.parseInt(paths.get(1).replaceAll("\\D+", "")) - 1;
                    return XLSParser.createChildTable(childSheet, rowNumber);
                }
                case 3: {
                    if (!(wb instanceof XSSFWorkbook)) throw new DataLoadingException("Unsupported format. External links supports only for .xlsx documents.");
                    ExternalLinksTable link = (ExternalLinksTable)((XSSFWorkbook)wb).getExternalLinksTable().get(Integer.parseInt(paths.get(0)) - 1);
                    File file = new File(Objects.requireNonNull(XLSCache.getWorkbookPath(wb)));
                    XSSFWorkbook childWb = (XSSFWorkbook)XLSCache.getWorkbook(file.getParent() + "/" + link.getLinkedFileName());
                    if (childWb == null) {
                        throw new DataLoadingException(String.format("WorkBook '%s' doesn't exist!", paths.get(0)));
                    }
                    childSheet = childWb.getSheet(paths.get(1));
                    if (childSheet == null) {
                        throw new DataLoadingException(String.format("Sheet '%s' doesn't exist!", paths.get(0)));
                    }
                    rowNumber = Integer.parseInt(paths.get(2).replaceAll("\\D+", "")) - 1;
                    return XLSParser.createChildTable(childSheet, rowNumber);
                }
            }
            return null;
        }
    }

    private static XLSChildTable createChildTable(Sheet sheet, int rowNumber) {
        XLSChildTable childTable = new XLSChildTable();
        childTable.setHeaders(sheet.getRow(0));
        childTable.addDataRow(sheet.getRow(rowNumber));
        return childTable;
    }

    private static XLSTable prepareDataTable(String executeColumn, String executeValue) {
        return executeColumn != null && executeValue != null ? new XLSTable(executeColumn, executeValue) : new XLSTable();
    }
}

