/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils;

import com.zebrunner.carina.utils.exception.PlaceholderResolverException;
import java.lang.invoke.MethodHandles;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlaceholderResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Pattern PATTERN = Pattern.compile("\\$\\{[^\\{\\}]*\\}");

    private PlaceholderResolver() {
    }

    public static String resolve(Properties properties, String key) {
        String value = properties.getProperty(key);
        if (value != null) {
            Matcher matcher = PATTERN.matcher(value);
            while (matcher.find()) {
                String placeholder = matcher.group();
                String placeholderKey = placeholder.replace("${", "").replace("}", "");
                String resolvedValue = PlaceholderResolver.resolve(properties, placeholderKey);
                if (resolvedValue == null) continue;
                value = value.replace(placeholder, resolvedValue);
            }
        }
        return value;
    }

    public static boolean isValid(Properties properties) {
        Set<Object> keys = properties.keySet();
        for (Object key : keys) {
            try {
                PlaceholderResolver.resolve(properties, (String)key);
            }
            catch (StackOverflowError e) {
                LOGGER.error("Infinit placeholder loop was found for '{}'", (Object)properties.getProperty((String)key));
                return false;
            }
            catch (PlaceholderResolverException e) {
                LOGGER.error(e.getMessage());
                return false;
            }
        }
        return true;
    }
}

