/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils.config;

import com.zebrunner.carina.utils.R;
import com.zebrunner.carina.utils.config.ConfigurationOption;
import com.zebrunner.carina.utils.config.IParameter;
import com.zebrunner.carina.utils.config.StandardConfigurationOption;
import com.zebrunner.carina.utils.encryptor.EncryptorUtils;
import com.zebrunner.carina.utils.exception.InvalidConfigurationException;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

public class Configuration {
    private static final String REQUIRE_VALUE_ERROR_MESSAGE = "Getting the value of parameter '%s' as required failed: the value is missing.";
    private static final ConfigurationOption[] DEFAULT_CONFIG_OPTIONS = Set.of(StandardConfigurationOption.ENVIRONMENT, StandardConfigurationOption.GLOBAL).toArray(new ConfigurationOption[0]);

    public static Optional<String> get(IParameter parameter) {
        return Configuration.get(parameter, DEFAULT_CONFIG_OPTIONS);
    }

    public static Optional<String> get(IParameter parameter, ConfigurationOption ... options) {
        return Configuration.get(parameter.getKey(), options);
    }

    public static Optional<String> get(String parameter) {
        return Configuration.get(parameter, DEFAULT_CONFIG_OPTIONS);
    }

    public static Optional<String> get(String parameter, ConfigurationOption ... options) {
        Optional<String> envValue;
        Optional<String> globalValue;
        String value = null;
        if (!ArrayUtils.contains((Object[])options, (Object)StandardConfigurationOption.GLOBAL) && !ArrayUtils.contains((Object[])options, (Object)StandardConfigurationOption.ENVIRONMENT)) {
            options = (ConfigurationOption[])ArrayUtils.addAll((Object[])options, (Object[])DEFAULT_CONFIG_OPTIONS);
        }
        if (ArrayUtils.contains((Object[])options, (Object)StandardConfigurationOption.GLOBAL) && (globalValue = Configuration.getGlobalParameter(parameter)).isPresent()) {
            value = globalValue.get();
        }
        if (ArrayUtils.contains((Object[])options, (Object)StandardConfigurationOption.ENVIRONMENT) && !Parameter.ENV.getKey().equals(parameter) && (envValue = Configuration.getEnvironmentParameter(parameter)).isPresent()) {
            value = envValue.get();
        }
        if (value == null) {
            return Optional.empty();
        }
        if (ArrayUtils.contains((Object[])options, (Object)StandardConfigurationOption.DECRYPT)) {
            value = EncryptorUtils.decrypt(value);
        }
        return Optional.of(value);
    }

    protected static Optional<String> getGlobalParameter(String parameter) {
        String value = R.CONFIG.get(parameter);
        if (value == null || "NULL".equalsIgnoreCase(value) || value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    protected static Optional<String> getEnvironmentParameter(String parameter) {
        String environment = R.CONFIG.get(Parameter.ENV.getKey());
        if (environment == null || "NULL".equalsIgnoreCase(environment) || environment.isEmpty()) {
            return Optional.empty();
        }
        String value = R.CONFIG.get(environment + "." + parameter);
        if (value == null || "NULL".equalsIgnoreCase(value) || value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static <T> Optional<T> get(IParameter parameter, Class<T> clazz) {
        return Configuration.get(parameter.getKey(), clazz, DEFAULT_CONFIG_OPTIONS);
    }

    public static <T> Optional<T> get(IParameter parameter, Class<T> clazz, ConfigurationOption ... options) {
        return Configuration.get(parameter.getKey(), clazz, options);
    }

    public static <T> Optional<T> get(String parameter, Class<T> clazz) {
        return Configuration.get(parameter, clazz, DEFAULT_CONFIG_OPTIONS);
    }

    public static <T> Optional<T> get(String parameter, Class<T> clazz, ConfigurationOption ... options) {
        Object value;
        Optional<String> optionalValue = Configuration.get(parameter, options);
        if (optionalValue.isEmpty()) {
            return Optional.empty();
        }
        String stringValue = optionalValue.get().trim();
        if (clazz == String.class) {
            value = stringValue;
        } else if (clazz == Integer.class) {
            value = Integer.valueOf(stringValue);
        } else if (clazz == Long.class) {
            value = Long.valueOf(stringValue);
        } else if (clazz == Double.class) {
            value = Double.valueOf(stringValue);
        } else if (clazz == Boolean.class) {
            value = Boolean.valueOf(stringValue);
        } else if (clazz == Short.class) {
            value = Short.valueOf(stringValue);
        } else if (clazz == Byte.class) {
            value = Byte.valueOf(stringValue);
        } else {
            throw new IllegalArgumentException(String.format("Cannot get parameter value with specific type. Class '%s' is unsupported by method.", clazz));
        }
        return Optional.of(clazz.cast(value));
    }

    public static String getRequired(IParameter parameter) {
        return Configuration.getRequired(parameter, DEFAULT_CONFIG_OPTIONS);
    }

    public static String getRequired(IParameter parameter, ConfigurationOption ... options) {
        return Configuration.get(parameter, options).orElseThrow(() -> new InvalidConfigurationException(String.format(REQUIRE_VALUE_ERROR_MESSAGE, parameter.getKey())));
    }

    public static String getRequired(String parameter) {
        return Configuration.getRequired(parameter, DEFAULT_CONFIG_OPTIONS);
    }

    public static String getRequired(String parameter, ConfigurationOption ... options) {
        return Configuration.get(parameter, options).orElseThrow(() -> new InvalidConfigurationException(String.format(REQUIRE_VALUE_ERROR_MESSAGE, parameter)));
    }

    public static <T> T getRequired(IParameter parameter, Class<T> clazz) {
        return Configuration.getRequired(parameter, clazz, DEFAULT_CONFIG_OPTIONS);
    }

    public static <T> T getRequired(IParameter parameter, Class<T> clazz, ConfigurationOption ... options) {
        return Configuration.get(parameter.getKey(), clazz, options).orElseThrow(() -> new InvalidConfigurationException(String.format(REQUIRE_VALUE_ERROR_MESSAGE, parameter)));
    }

    public static <T> T getRequired(String parameter, Class<T> clazz) {
        return Configuration.getRequired(parameter, clazz, DEFAULT_CONFIG_OPTIONS);
    }

    public static <T> T getRequired(String parameter, Class<T> clazz, ConfigurationOption ... options) {
        return Configuration.get(parameter, clazz, options).orElseThrow(() -> new InvalidConfigurationException(String.format(REQUIRE_VALUE_ERROR_MESSAGE, parameter)));
    }

    protected Optional<String> asString(IParameter[] parameters) {
        String lineFormat = "%s=%s%n";
        StringBuilder asString = new StringBuilder();
        for (IParameter param : parameters) {
            String str = "";
            Optional<String> global = Configuration.get(param);
            if (global.isPresent() && R.CONFIG.isOverwritten(param.getKey())) {
                String string = str = param.hidden() ? "*****" : global.get();
            }
            if (str.isEmpty()) continue;
            asString.append(String.format(lineFormat, param.getKey(), str));
        }
        if (asString.length() <= 0) {
            return Optional.empty();
        }
        return Optional.of(asString.toString());
    }

    public String toString() {
        Optional<String> asString = this.asString(Parameter.values());
        if (asString.isEmpty()) {
            return "";
        }
        return "\n============= Basic configuration =============\n" + asString.get();
    }

    public static enum Parameter implements IParameter
    {
        ENV("env"),
        PROJECT_REPORT_DIRECTORY("project_report_directory");

        private final String name;

        private Parameter(String name) {
            this.name = name;
        }

        @Override
        public String getKey() {
            return this.name;
        }
    }
}

