/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.rsql.parser.ast;

import cz.jirutka.rsql.parser.UnknownOperatorException;
import cz.jirutka.rsql.parser.ast.AndNode;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import cz.jirutka.rsql.parser.ast.LogicalNode;
import cz.jirutka.rsql.parser.ast.LogicalOperator;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.OrNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public class NodesFactory {
    private final Map<String, ComparisonOperator> comparisonOperators;

    public NodesFactory(Set<ComparisonOperator> operators) {
        this.comparisonOperators = new HashMap<String, ComparisonOperator>(operators.size());
        for (ComparisonOperator op : operators) {
            String[] stringArray = op.getSymbols();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String sym = stringArray[n2];
                this.comparisonOperators.put(sym, op);
                ++n2;
            }
        }
    }

    public LogicalNode createLogicalNode(LogicalOperator operator, List<Node> children) {
        switch (operator) {
            case AND: {
                return new AndNode(children);
            }
            case OR: {
                return new OrNode(children);
            }
        }
        throw new IllegalStateException("Unknown operator: " + (Object)((Object)operator));
    }

    public ComparisonNode createComparisonNode(String operatorToken, String selector, List<String> arguments) throws UnknownOperatorException {
        ComparisonOperator op = this.comparisonOperators.get(operatorToken);
        if (op != null) {
            return new ComparisonNode(op, selector, arguments);
        }
        throw new UnknownOperatorException(operatorToken);
    }
}

