/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.jquery.function;

import de.agilecoders.wicket.jquery.function.IFunction;
import de.agilecoders.wicket.jquery.function.JavaScriptInlineFunction;
import de.agilecoders.wicket.jquery.util.CharSequenceWrapper;
import de.agilecoders.wicket.jquery.util.Generics2;
import java.util.List;

public abstract class AbstractFunction
implements IFunction {
    private final CharSequence functionName;
    private final List<CharSequence> parameters;

    protected AbstractFunction(CharSequence functionName) {
        this.functionName = functionName;
        this.parameters = Generics2.newArrayList(new Object[0]);
    }

    @Override
    public String build() {
        return this.functionName + "(" + this.buildParameters() + ")";
    }

    protected final char getSeparator() {
        return ',';
    }

    protected String buildParameters() {
        return Generics2.join(this.parameters, this.getSeparator());
    }

    protected final void addParameter(CharSequence parameter) {
        this.parameters.add(parameter);
    }

    protected final CharSequence toParameterValue(Object value) {
        return CharSequenceWrapper.toParameterValue(value);
    }

    protected final CharSequence toParameterValue(JavaScriptInlineFunction value) {
        return CharSequenceWrapper.toParameterValue(value);
    }

    protected final CharSequence toParameterValue(Long value) {
        return CharSequenceWrapper.toParameterValue(value);
    }

    protected final CharSequence toParameterValue(Integer value) {
        return CharSequenceWrapper.toParameterValue(value);
    }

    protected final CharSequence toParameterValue(Float value) {
        return CharSequenceWrapper.toParameterValue(value);
    }

    protected final CharSequence toParameterValue(Boolean value) {
        return CharSequenceWrapper.toParameterValue(value);
    }
}

