/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.form;

import com.google.common.base.Function;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.core.util.Components;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.FeedbackMessages;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.border.Border;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.iterator.ComponentHierarchyIterator;
import org.apache.wicket.util.string.Strings;

public class FormGroup
extends Border {
    private Component label;
    private Component help;
    private Component feedback;
    private String stateClassName;
    private boolean useFormComponentLabel = true;
    private Size size;
    private final IModel<String> labelModel;
    private final IModel<String> helpModel;
    private static final List<Integer> messageTypes = Arrays.asList(500, 400, 300, 250, 200, 100, 0);

    public FormGroup(String id) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)"")), (IModel<String>)Model.of((Serializable)((Object)"")));
    }

    public FormGroup(String id, IModel<String> label) {
        this(id, label, (IModel<String>)Model.of((Serializable)((Object)"")));
    }

    public FormGroup(String id, IModel<String> label, IModel<String> help) {
        super(id, (IModel)Model.of((Serializable)((Object)"")));
        this.labelModel = label;
        this.helpModel = help;
        this.stateClassName = "";
    }

    public FormGroup useFormComponentLabel(boolean value) {
        this.useFormComponentLabel = value;
        return this;
    }

    public FormGroup size(Size size) {
        this.size = size;
        return this;
    }

    protected Function<FeedbackMessage, String> newFeedbackMessageToCssClassNameTransformer() {
        return new FeedbackMessageToCssClassNameTransformer();
    }

    protected Component newLabel(String id, IModel<String> model) {
        return new Label(id, model);
    }

    protected Component newFeedbackMessageContainer(String id) {
        return new Label(id, (IModel)new Model());
    }

    protected Component newHelpLabel(String id, IModel<String> model) {
        return new Label(id, model);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "div");
        Attributes.addClass(tag, "form-group", this.stateClassName);
        if (this.size != null) {
            Attributes.addClass(tag, this.size.cssClassName());
        }
    }

    protected void onInitialize() {
        super.onInitialize();
        this.label = this.newLabel("label", this.labelModel);
        this.help = this.newHelpLabel("help", this.helpModel);
        this.feedback = this.newFeedbackMessageContainer("error");
        this.addToBorder(new Component[]{this.label, this.help, this.feedback});
        List<FormComponent<?>> formComponents = this.findFormComponents();
        int size = formComponents.size();
        if (size > 0) {
            this.addOutputMarkupId(formComponents);
            final FormComponent<?> formComponent = formComponents.get(size - 1);
            this.label.add(new Behavior[]{new AttributeModifier("for", (Serializable)((Object)formComponent.getMarkupId()))});
            if (this.useFormComponentLabel) {
                this.label.setDefaultModel((IModel)new LoadableDetachableModel<String>(){

                    protected String load() {
                        if (formComponent.getLabel() != null && !Strings.isEmpty((CharSequence)((CharSequence)formComponent.getLabel().getObject()))) {
                            return (String)formComponent.getLabel().getObject();
                        }
                        String text = formComponent.getDefaultLabel("wicket:unknown");
                        if (!"wicket:unknown".equals(text) && !Strings.isEmpty((CharSequence)text)) {
                            return text;
                        }
                        return (String)FormGroup.this.labelModel.getObject();
                    }
                });
            }
        }
    }

    protected void addOutputMarkupId(List<FormComponent<?>> formComponents) {
        for (FormComponent<?> fc : formComponents) {
            fc.setOutputMarkupId(true);
        }
    }

    protected void onConfigure() {
        super.onConfigure();
        Components.show(this.help, this.label, this.feedback);
        this.stateClassName = "";
        this.feedback.setDefaultModelObject((Object)"");
        List<FormComponent<?>> formComponents = this.findFormComponents();
        for (FormComponent<?> fc : formComponents) {
            FeedbackMessages messages = fc.getFeedbackMessages();
            if (messages.isEmpty()) continue;
            FeedbackMessage worstMessage = this.getWorstMessage(messages);
            worstMessage.markRendered();
            this.stateClassName = this.toClassName(worstMessage);
            this.feedback.setDefaultModelObject((Object)worstMessage.getMessage());
            break;
        }
        Components.hideIfModelIsEmpty(this.help);
        Components.hideIfModelIsEmpty(this.label);
        Components.hideIfModelIsEmpty(this.feedback);
    }

    private List<FormComponent<?>> findFormComponents() {
        ComponentHierarchyIterator it = this.getBodyContainer().visitChildren(FormComponent.class);
        ArrayList components = new ArrayList();
        while (it.hasNext()) {
            components.add((FormComponent)it.next());
        }
        return components;
    }

    private FeedbackMessage getWorstMessage(FeedbackMessages messages) {
        for (Integer messageType : messageTypes) {
            FeedbackMessage ret = messages.first(messageType.intValue());
            if (ret == null) continue;
            return ret;
        }
        return messages.first();
    }

    private String toClassName(FeedbackMessage message) {
        return (String)this.newFeedbackMessageToCssClassNameTransformer().apply((Object)message);
    }

    public static class FeedbackMessageToCssClassNameTransformer
    implements Function<FeedbackMessage, String> {
        public String apply(FeedbackMessage message) {
            if (message == null) {
                return "";
            }
            switch (message.getLevel()) {
                case 400: 
                case 500: {
                    return "has-error";
                }
                case 300: {
                    return "has-warning";
                }
                case 200: 
                case 250: {
                    return "has-success";
                }
            }
            return "";
        }
    }

    public static enum Size implements ICssClassNameProvider
    {
        Small("sm"),
        Large("lg");

        private final String cssName;

        private Size(String cssName) {
            this.cssName = cssName;
        }

        @Override
        public String cssClassName() {
            return "form-group-" + this.cssName;
        }
    }
}

