/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.button;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.IBootstrapButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.html.panel.PanelMarkupSourcingStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class BootstrapAjaxLink<T>
extends AjaxLink<T>
implements IBootstrapButton<BootstrapAjaxLink<T>> {
    private final Icon icon;
    private final Component label;
    private final Component splitter;
    private final ButtonBehavior buttonBehavior;

    public BootstrapAjaxLink(String id, Buttons.Type type) {
        this(id, null, type);
    }

    public BootstrapAjaxLink(String id, IModel<T> model, Buttons.Type type) {
        this(id, model, type, (IModel)Model.of((Serializable)((Object)"")));
    }

    public <L extends Serializable> BootstrapAjaxLink(String id, IModel<T> model, Buttons.Type type, IModel<L> labelModel) {
        super(id, model);
        Behavior[] behaviorArray = new Behavior[1];
        this.buttonBehavior = new ButtonBehavior(type, Buttons.Size.Medium);
        behaviorArray[0] = this.buttonBehavior;
        this.add(behaviorArray);
        Component[] componentArray = new Component[1];
        this.icon = this.newIcon("icon");
        componentArray[0] = this.icon;
        this.add(componentArray);
        this.splitter = this.newSplitter("splitter");
        this.add(new Component[]{this.splitter});
        this.label = this.newLabel("label", labelModel);
        this.add(new Component[]{this.label});
    }

    protected Icon newIcon(String markupId) {
        return new Icon(markupId, (IconType)null);
    }

    protected <L extends Serializable> Component newLabel(String markupId, IModel<L> model) {
        return new Label(markupId, model).setRenderBodyOnly(true);
    }

    protected Component newSplitter(String markupId) {
        return new WebMarkupContainer(markupId).setRenderBodyOnly(true).setEscapeModelStrings(false);
    }

    protected IMarkupSourcingStrategy newMarkupSourcingStrategy() {
        return new PanelMarkupSourcingStrategy(true);
    }

    protected void onConfigure() {
        super.onConfigure();
        this.splitter.setVisible(this.icon.hasIconType() && StringUtils.isNotEmpty((CharSequence)this.label.getDefaultModelObjectAsString()));
    }

    public <L extends Serializable> BootstrapAjaxLink<T> setLabel(IModel<L> label) {
        this.label.setDefaultModel(label);
        return this;
    }

    public BootstrapAjaxLink<T> setIconType(IconType iconType) {
        this.icon.setType(iconType);
        return this;
    }

    @Override
    public BootstrapAjaxLink<T> setSize(Buttons.Size size) {
        this.buttonBehavior.setSize(size);
        return this;
    }

    @Override
    public BootstrapAjaxLink<T> setType(Buttons.Type type) {
        this.buttonBehavior.setType(type);
        return this;
    }
}

