/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.button;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.IBootstrapButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.core.util.Models;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.html.panel.PanelMarkupSourcingStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class BootstrapExternalLink
extends ExternalLink
implements IBootstrapButton<BootstrapExternalLink> {
    private final Icon icon;
    private final Component label;
    private final Component splitter;
    private final ButtonBehavior buttonBehavior;
    private final IModel<String> target = Model.of((Serializable)((Object)""));

    public BootstrapExternalLink(String id, IModel<String> href) {
        this(id, href, Buttons.Type.Link);
    }

    public BootstrapExternalLink(String id, IModel<String> model, Buttons.Type type) {
        super(id, model);
        Behavior[] behaviorArray = new Behavior[1];
        this.buttonBehavior = new ButtonBehavior(type, Buttons.Size.Medium);
        behaviorArray[0] = this.buttonBehavior;
        this.add(behaviorArray);
        Component[] componentArray = new Component[1];
        this.icon = this.newIcon("icon");
        componentArray[0] = this.icon;
        this.add(componentArray);
        this.splitter = this.newSplitter("splitter");
        this.add(new Component[]{this.splitter});
        this.label = this.newLabel("label");
        this.add(new Component[]{this.label});
    }

    protected Icon newIcon(String markupId) {
        return new Icon(markupId, (IconType)null);
    }

    protected Component newLabel(String markupId) {
        return new Label(markupId, (IModel)new Model((Serializable)((Object)""))).setRenderBodyOnly(true);
    }

    protected Component newSplitter(String markupId) {
        return new WebMarkupContainer(markupId).setRenderBodyOnly(true).setEscapeModelStrings(false);
    }

    protected void onComponentTag(ComponentTag tag) {
        if (!Models.isNullOrEmpty(this.target)) {
            tag.put("target", (CharSequence)this.target.getObject());
        }
        super.onComponentTag(tag);
    }

    protected final IMarkupSourcingStrategy newMarkupSourcingStrategy() {
        return new PanelMarkupSourcingStrategy(true);
    }

    protected void onConfigure() {
        super.onConfigure();
        this.splitter.setVisible(this.icon.hasIconType() && StringUtils.isNotEmpty((CharSequence)this.label.getDefaultModelObjectAsString()));
    }

    public BootstrapExternalLink setLabel(IModel<?> label) {
        this.label.setDefaultModel(label);
        return this;
    }

    public BootstrapExternalLink setIconType(IconType iconType) {
        this.icon.setType(iconType);
        return this;
    }

    @Override
    public BootstrapExternalLink setSize(Buttons.Size size) {
        this.buttonBehavior.setSize(size);
        return this;
    }

    @Override
    public BootstrapExternalLink setType(Buttons.Type type) {
        this.buttonBehavior.setType(type);
        return this;
    }

    public BootstrapExternalLink setTarget(Target target) {
        if (target == null || target == Target.none) {
            this.target.setObject((Object)"");
        } else {
            this.target.setObject((Object)("_" + target.name()));
        }
        return this;
    }

    public static enum Target {
        blank,
        self,
        parent,
        top,
        none;

    }
}

