/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.form;

import de.agilecoders.wicket.core.util.Attributes;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.model.IModel;

public class BootstrapCheckbox
extends FormComponentPanel<Boolean> {
    private final WebMarkupContainer wrapper;
    private final IModel<?> labelModel;
    private boolean inline = false;
    private CheckBox checkbox;

    public BootstrapCheckbox(String id) {
        this(id, null);
    }

    public BootstrapCheckbox(String id, IModel<Boolean> model) {
        this(id, model, null);
    }

    public BootstrapCheckbox(String id, IModel<Boolean> model, IModel<?> labelModel) {
        super(id, model);
        this.setType(Boolean.class);
        this.labelModel = labelModel;
        this.setRenderBodyOnly(true);
        this.wrapper = new WebMarkupContainer("wrapper");
        this.add(new Component[]{this.wrapper});
        MarkupContainer label = this.newLabelContainer("label");
        this.wrapper.add(new Component[]{label});
        label.add(new Component[]{this.newLabel("post-label")});
        this.checkbox = this.newCheckBox("checkbox", (IModel<Boolean>)this.getModel());
        label.add(new Component[]{this.checkbox});
    }

    protected void onDetach() {
        super.onDetach();
        if (this.labelModel != null) {
            this.labelModel.detach();
        }
    }

    protected CheckBox newCheckBox(String id, IModel<Boolean> model) {
        return new CheckBox(id, model);
    }

    protected Component newLabel(String id) {
        return new Label(id, this.labelModel){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(BootstrapCheckbox.this.labelModel != null && BootstrapCheckbox.this.labelModel.getObject() != null);
            }
        };
    }

    protected MarkupContainer newLabelContainer(String id) {
        return new WebMarkupContainer(id){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (BootstrapCheckbox.this.isInline()) {
                    Attributes.addClass(tag, "checkbox-inline");
                }
            }
        };
    }

    public boolean isInline() {
        return this.inline;
    }

    public BootstrapCheckbox setInline(boolean inline) {
        this.inline = inline;
        this.wrapper.setRenderBodyOnly(inline);
        return this;
    }

    public BootstrapCheckbox setLabel(IModel<String> label) {
        this.checkbox.setLabel(label);
        return this;
    }

    public IModel<String> getLabel() {
        return this.checkbox.getLabel();
    }

    protected void convertInput() {
        this.setConvertedInput(this.checkbox.getConvertedInput());
    }
}

