/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.button;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.IBootstrapButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.html.panel.PanelMarkupSourcingStrategy;
import org.apache.wicket.model.IModel;

public class BootstrapButton
extends Button
implements IBootstrapButton<BootstrapButton> {
    private final Icon icon;
    private final Component label;
    private final Component splitter;
    private final ButtonBehavior buttonBehavior;
    private boolean useSplitter = true;

    public BootstrapButton(String componentId, Buttons.Type type) {
        this(componentId, null, type);
    }

    public BootstrapButton(String componentId, IModel<String> model, Buttons.Type type) {
        super(componentId, model);
        Behavior[] behaviorArray = new Behavior[1];
        this.buttonBehavior = new ButtonBehavior(type, Buttons.Size.Medium);
        behaviorArray[0] = this.buttonBehavior;
        this.add(behaviorArray);
        Component[] componentArray = new Component[1];
        this.icon = this.newIcon("icon");
        componentArray[0] = this.icon;
        this.add(componentArray);
        this.splitter = this.newSplitter("splitter");
        this.add(new Component[]{this.splitter});
        this.label = this.newLabel("label", model);
        this.add(new Component[]{this.label});
    }

    protected Icon newIcon(String markupId) {
        return new Icon(markupId, (IconType)null);
    }

    protected Component newLabel(String markupId, IModel<String> model) {
        return new Label(markupId, model).setRenderBodyOnly(true);
    }

    protected Component newSplitter(String markupId) {
        return new WebMarkupContainer(markupId).setRenderBodyOnly(true).setEscapeModelStrings(false).setVisible(false);
    }

    protected void onConfigure() {
        super.onConfigure();
        if (this.useSplitter) {
            this.splitter.setVisible(this.icon.hasIconType() && StringUtils.isNotEmpty((CharSequence)((CharSequence)this.getModelObject())));
        }
    }

    protected IMarkupSourcingStrategy newMarkupSourcingStrategy() {
        return new PanelMarkupSourcingStrategy(true);
    }

    public BootstrapButton setLabel(IModel<String> label) {
        this.label.setDefaultModel(label);
        this.setModel(label);
        return this;
    }

    public BootstrapButton setIconType(IconType iconType) {
        this.icon.setType(iconType);
        return this;
    }

    @Override
    public BootstrapButton setSize(Buttons.Size size) {
        this.buttonBehavior.setSize(size);
        return this;
    }

    @Override
    public BootstrapButton setType(Buttons.Type type) {
        this.buttonBehavior.setType(type);
        return this;
    }

    public BootstrapButton setBlock(boolean block) {
        this.buttonBehavior.setBlock(block);
        return this;
    }

    public BootstrapButton useSplitter(boolean value) {
        this.useSplitter = value;
        return this;
    }
}

