/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os;

import de.flapdoodle.os.Architecture;
import de.flapdoodle.os.CommonArchitecture;
import de.flapdoodle.os.Distribution;
import de.flapdoodle.os.common.HasPecularities;
import de.flapdoodle.os.common.Peculiarity;
import de.flapdoodle.os.common.attributes.Attributes;
import de.flapdoodle.os.common.collections.Immutables;
import de.flapdoodle.os.common.matcher.Matchers;
import de.flapdoodle.os.freebsd.FreeBSDDistribution;
import de.flapdoodle.os.linux.LinuxDistribution;
import de.flapdoodle.os.osx.OS_X_Distribution;
import de.flapdoodle.os.solaris.SolarisDistribution;
import de.flapdoodle.os.windows.WindowsDistribution;
import java.util.List;

public enum OS implements HasPecularities
{
    Linux(CommonArchitecture.class, LinuxDistribution.class, OS.osNameMatches("Linux")),
    Windows(CommonArchitecture.class, WindowsDistribution.class, OS.osNameMatches("Windows.*")),
    OS_X(CommonArchitecture.class, OS_X_Distribution.class, OS.osNameMatches("Mac OS X")),
    Solaris(CommonArchitecture.class, SolarisDistribution.class, OS.osNameMatches(".*SunOS.*")),
    FreeBSD(CommonArchitecture.class, FreeBSDDistribution.class, OS.osNameMatches("FreeBSD"));

    private final List<Peculiarity<?>> peculiarities;
    private final List<Distribution> distributions;
    private final List<Architecture> architectures;

    private <A extends Enum<A>, T extends Enum<T>> OS(Class<A> architecureClazz, Class<T> clazz, Peculiarity<?> ... peculiarities) {
        this.peculiarities = HasPecularities.asList(peculiarities);
        this.architectures = Immutables.asList(architecureClazz.getEnumConstants());
        this.distributions = Immutables.asList(clazz.getEnumConstants());
    }

    public List<Distribution> distributions() {
        return this.distributions;
    }

    public List<Architecture> architectures() {
        return this.architectures;
    }

    @Override
    public List<Peculiarity<?>> pecularities() {
        return this.peculiarities;
    }

    private static Peculiarity<String> osNameMatches(String pattern) {
        return Peculiarity.of(Attributes.systemProperty("os.name"), Matchers.matchPattern(pattern));
    }
}

