/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.mongo.packageresolver.NumericVersion;
import de.flapdoodle.embed.mongo.packageresolver.ToolVersionRange;
import java.util.ArrayList;
import java.util.Objects;

public final class ImmutableToolVersionRange
extends ToolVersionRange {
    private final NumericVersion min;
    private final NumericVersion max;

    private ImmutableToolVersionRange(NumericVersion min, NumericVersion max) {
        this.min = Objects.requireNonNull(min, "min");
        this.max = Objects.requireNonNull(max, "max");
    }

    private ImmutableToolVersionRange(ImmutableToolVersionRange original, NumericVersion min, NumericVersion max) {
        this.min = min;
        this.max = max;
    }

    @Override
    NumericVersion min() {
        return this.min;
    }

    @Override
    NumericVersion max() {
        return this.max;
    }

    public final ImmutableToolVersionRange withMin(NumericVersion value) {
        if (this.min == value) {
            return this;
        }
        NumericVersion newValue = Objects.requireNonNull(value, "min");
        return ImmutableToolVersionRange.validate(new ImmutableToolVersionRange(this, newValue, this.max));
    }

    public final ImmutableToolVersionRange withMax(NumericVersion value) {
        if (this.max == value) {
            return this;
        }
        NumericVersion newValue = Objects.requireNonNull(value, "max");
        return ImmutableToolVersionRange.validate(new ImmutableToolVersionRange(this, this.min, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableToolVersionRange && this.equalsByValue((ImmutableToolVersionRange)another);
    }

    private boolean equalsByValue(ImmutableToolVersionRange another) {
        return this.min.equals(another.min) && this.max.equals(another.max);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.min.hashCode();
        h += (h << 5) + this.max.hashCode();
        return h;
    }

    public String toString() {
        return "ToolVersionRange{min=" + this.min + ", max=" + this.max + "}";
    }

    public static ImmutableToolVersionRange of(NumericVersion min, NumericVersion max) {
        return ImmutableToolVersionRange.validate(new ImmutableToolVersionRange(min, max));
    }

    private static ImmutableToolVersionRange validate(ImmutableToolVersionRange instance) {
        instance.check();
        return instance;
    }

    public static ImmutableToolVersionRange copyOf(ToolVersionRange instance) {
        if (instance instanceof ImmutableToolVersionRange) {
            return (ImmutableToolVersionRange)instance;
        }
        return ImmutableToolVersionRange.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MIN = 1L;
        private static final long INIT_BIT_MAX = 2L;
        private long initBits = 3L;
        private NumericVersion min;
        private NumericVersion max;

        private Builder() {
        }

        public final Builder from(ToolVersionRange instance) {
            Objects.requireNonNull(instance, "instance");
            this.min(instance.min());
            this.max(instance.max());
            return this;
        }

        public final Builder min(NumericVersion min) {
            this.min = Objects.requireNonNull(min, "min");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder max(NumericVersion max) {
            this.max = Objects.requireNonNull(max, "max");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableToolVersionRange build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableToolVersionRange.validate(new ImmutableToolVersionRange(null, this.min, this.max));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("min");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("max");
            }
            return "Cannot build ToolVersionRange, some of required attributes are not set " + attributes;
        }
    }
}

