/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.mongo.packageresolver.Command;
import de.flapdoodle.embed.mongo.packageresolver.ExplainRules;
import de.flapdoodle.embed.mongo.packageresolver.HasPlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.OSXPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRule;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRules;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.embed.mongo.packageresolver.SolarisPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.WindowsPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.linux.LinuxPackageFinder;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.PackageResolver;
import de.flapdoodle.os.CommonOS;
import de.flapdoodle.os.OS;
import java.util.Optional;

public class PlatformPackageResolver
implements PackageResolver,
HasPlatformMatchRules {
    private final Command command;
    private final PackageFinderRules rules;

    public PlatformPackageResolver(Command command) {
        this.command = command;
        this.rules = PackageFinderRules.empty().with(PackageFinderRule.of(PlatformMatch.withOs((OS)CommonOS.Windows), new WindowsPackageFinder(command))).with(PackageFinderRule.of(PlatformMatch.withOs((OS)CommonOS.OS_X), new OSXPackageFinder(command))).with(PackageFinderRule.of(PlatformMatch.withOs((OS)CommonOS.Linux), new LinuxPackageFinder(command))).with(PackageFinderRule.of(PlatformMatch.withOs((OS)CommonOS.Solaris), new SolarisPackageFinder(command)));
    }

    public Package packageFor(Distribution distribution) {
        Optional<Package> result = this.rules.packageFor(distribution);
        return result.orElseThrow(() -> {
            String message = "could not resolve package for " + distribution + System.lineSeparator() + "--------------" + System.lineSeparator() + this.explain();
            return new IllegalArgumentException(message);
        });
    }

    @Override
    public PackageFinderRules rules() {
        return this.rules;
    }

    public String explain() {
        return ExplainRules.explain(this.rules);
    }
}

