/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.store;

import de.flapdoodle.embed.process.builder.AbstractBuilder;
import de.flapdoodle.embed.process.builder.IProperty;
import de.flapdoodle.embed.process.builder.TypedProperty;
import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.extract.ITempNaming;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.store.ArtifactStore;
import de.flapdoodle.embed.process.store.CachingArtifactStore;
import de.flapdoodle.embed.process.store.IArtifactStore;
import java.util.logging.Logger;

public class ArtifactStoreBuilder
extends AbstractBuilder<IArtifactStore> {
    private static Logger logger = Logger.getLogger(ArtifactStoreBuilder.class.getName());
    private static final TypedProperty<ITempNaming> EXECUTABLE_NAMING = TypedProperty.with("ExecutableNaming", ITempNaming.class);
    private static final TypedProperty<IDirectory> TEMP_DIR_FACTORY = TypedProperty.with("TempDir", IDirectory.class);
    private static final TypedProperty<IDownloadConfig> DOWNLOAD_CONFIG = TypedProperty.with("DownloadConfig", IDownloadConfig.class);
    private static final TypedProperty<Boolean> USE_CACHE = TypedProperty.with("UseCache", Boolean.class);

    public ArtifactStoreBuilder download(AbstractBuilder<IDownloadConfig> downloadConfigBuilder) {
        return this.download(downloadConfigBuilder.build());
    }

    public ArtifactStoreBuilder download(IDownloadConfig downloadConfig) {
        this.set(DOWNLOAD_CONFIG, downloadConfig);
        return this;
    }

    protected IProperty<IDownloadConfig> download() {
        return this.property(DOWNLOAD_CONFIG);
    }

    public ArtifactStoreBuilder tempDir(IDirectory tempDirFactory) {
        this.set(TEMP_DIR_FACTORY, tempDirFactory);
        return this;
    }

    protected IProperty<IDirectory> tempDir() {
        return this.property(TEMP_DIR_FACTORY);
    }

    public ArtifactStoreBuilder executableNaming(ITempNaming execNaming) {
        this.set(EXECUTABLE_NAMING, execNaming);
        return this;
    }

    protected IProperty<ITempNaming> executableNaming() {
        return this.property(EXECUTABLE_NAMING);
    }

    public ArtifactStoreBuilder useCache(boolean cache) {
        this.set(USE_CACHE, cache);
        return this;
    }

    protected IProperty<Boolean> useCache() {
        return this.property(USE_CACHE);
    }

    @Deprecated
    public ArtifactStoreBuilder cache(boolean cache) {
        return this.useCache(cache);
    }

    @Override
    public IArtifactStore build() {
        boolean useCache = this.get(USE_CACHE, true);
        logger.severe("Build ArtifactStore(useCache:" + useCache + ")");
        IArtifactStore artifactStore = new ArtifactStore(this.get(DOWNLOAD_CONFIG), this.get(TEMP_DIR_FACTORY), this.get(EXECUTABLE_NAMING));
        if (useCache) {
            artifactStore = new CachingArtifactStore(artifactStore);
        }
        return artifactStore;
    }
}

