/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.store;

import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import de.flapdoodle.embed.process.store.IArtifactStore;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class CachingArtifactStore
implements IArtifactStore {
    private static Logger _logger = Logger.getLogger(CachingArtifactStore.class.getName());
    private final IArtifactStore _delegate;
    Object _lock = new Object();
    HashMap<Distribution, FileWithCounter> _distributionFiles = new HashMap();

    public CachingArtifactStore(IArtifactStore delegate) {
        this._delegate = delegate;
        ProcessControl.addShutdownHook(new CacheCleaner());
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new CustomThreadFactory());
        executor.scheduleAtFixedRate(new RemoveUnused(), 10L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public boolean checkDistribution(Distribution distribution) throws IOException {
        return this._delegate.checkDistribution(distribution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File extractExe(Distribution distribution) throws IOException {
        FileWithCounter fileWithCounter;
        Object object = this._lock;
        synchronized (object) {
            fileWithCounter = this._distributionFiles.get(distribution);
            if (fileWithCounter == null) {
                _logger.fine("cache NOT found for " + distribution);
                fileWithCounter = new FileWithCounter(distribution);
                this._distributionFiles.put(distribution, fileWithCounter);
            } else {
                _logger.fine("cache found for " + distribution);
            }
        }
        return fileWithCounter.use();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExecutable(Distribution distribution, File executable) {
        FileWithCounter fileWithCounter;
        Object object = this._lock;
        synchronized (object) {
            fileWithCounter = this._distributionFiles.get(distribution);
        }
        if (fileWithCounter != null) {
            fileWithCounter.free(executable);
        } else {
            _logger.warning("Allready removed " + executable + " for " + distribution + ", emergency shutdown?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAll() {
        Object object = this._lock;
        synchronized (object) {
            for (FileWithCounter fc : this._distributionFiles.values()) {
                fc.forceDelete();
            }
            this._distributionFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUnused() {
        Object object = this._lock;
        synchronized (object) {
            for (FileWithCounter fc : this._distributionFiles.values()) {
                fc.cleanup();
            }
        }
    }

    class CustomThreadFactory
    implements ThreadFactory {
        ThreadFactory factory = Executors.defaultThreadFactory();

        CustomThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread ret = this.factory.newThread(runnable);
            ret.setDaemon(true);
            return ret;
        }
    }

    class CacheCleaner
    implements Runnable {
        CacheCleaner() {
        }

        @Override
        public void run() {
            CachingArtifactStore.this.removeAll();
        }
    }

    class RemoveUnused
    implements Runnable {
        RemoveUnused() {
        }

        @Override
        public void run() {
            CachingArtifactStore.this.removeUnused();
        }
    }

    class FileWithCounter {
        private File _file;
        int _counter = 0;
        private final Distribution _distribution;

        public FileWithCounter(Distribution distribution) {
            this._distribution = distribution;
        }

        public synchronized void free(File executable) {
            if (executable != this._file) {
                throw new RuntimeException("Files does not match: " + this._file + " != " + executable);
            }
            _logger.fine("Free " + this._counter + " " + this._file);
            --this._counter;
        }

        public synchronized File use() throws IOException {
            ++this._counter;
            if (this._file == null) {
                this._file = CachingArtifactStore.this._delegate.extractExe(this._distribution);
                _logger.fine("Not Cached " + this._counter + " " + this._file);
            } else {
                _logger.fine("Cached " + this._counter + " " + this._file);
            }
            return this._file;
        }

        public synchronized void cleanup() {
            if (this._counter <= 0) {
                if (this._counter < 0) {
                    _logger.warning("Counter < 0 for " + this._distribution + " and " + this._file);
                }
                if (this._file != null) {
                    _logger.fine("cleanup for " + this._distribution + " and " + this._file);
                    CachingArtifactStore.this._delegate.removeExecutable(this._distribution, this._file);
                    this._file = null;
                }
            }
        }

        public synchronized void forceDelete() {
            if (this._file != null) {
                _logger.fine("force delete for " + this._distribution + " and " + this._file);
                CachingArtifactStore.this._delegate.removeExecutable(this._distribution, this._file);
                this._file = null;
                this._counter = 0;
            }
        }
    }
}

