/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.types;

import de.flapdoodle.embed.process.types.ProcessConfig;
import java.util.ArrayList;
import java.util.Objects;

public final class ImmutableProcessConfig
implements ProcessConfig {
    private final boolean daemonProcess;
    private final long stopTimeoutInMillis;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableProcessConfig(Builder builder) {
        if (builder.daemonProcessIsSet()) {
            this.initShim.daemonProcess(builder.daemonProcess);
        }
        if (builder.stopTimeoutInMillisIsSet()) {
            this.initShim.stopTimeoutInMillis(builder.stopTimeoutInMillis);
        }
        this.daemonProcess = this.initShim.daemonProcess();
        this.stopTimeoutInMillis = this.initShim.stopTimeoutInMillis();
        this.initShim = null;
    }

    private ImmutableProcessConfig(boolean daemonProcess, long stopTimeoutInMillis) {
        this.daemonProcess = daemonProcess;
        this.stopTimeoutInMillis = stopTimeoutInMillis;
        this.initShim = null;
    }

    private boolean daemonProcessInitialize() {
        return ProcessConfig.super.daemonProcess();
    }

    private long stopTimeoutInMillisInitialize() {
        return ProcessConfig.super.stopTimeoutInMillis();
    }

    @Override
    public boolean daemonProcess() {
        InitShim shim = this.initShim;
        return shim != null ? shim.daemonProcess() : this.daemonProcess;
    }

    @Override
    public long stopTimeoutInMillis() {
        InitShim shim = this.initShim;
        return shim != null ? shim.stopTimeoutInMillis() : this.stopTimeoutInMillis;
    }

    public final ImmutableProcessConfig withDaemonProcess(boolean value) {
        if (this.daemonProcess == value) {
            return this;
        }
        return new ImmutableProcessConfig(value, this.stopTimeoutInMillis);
    }

    public final ImmutableProcessConfig withStopTimeoutInMillis(long value) {
        if (this.stopTimeoutInMillis == value) {
            return this;
        }
        return new ImmutableProcessConfig(this.daemonProcess, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcessConfig && this.equalsByValue((ImmutableProcessConfig)another);
    }

    private boolean equalsByValue(ImmutableProcessConfig another) {
        return this.daemonProcess == another.daemonProcess && this.stopTimeoutInMillis == another.stopTimeoutInMillis;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.daemonProcess);
        h += (h << 5) + Long.hashCode(this.stopTimeoutInMillis);
        return h;
    }

    public String toString() {
        return "ProcessConfig{daemonProcess=" + this.daemonProcess + ", stopTimeoutInMillis=" + this.stopTimeoutInMillis + "}";
    }

    public static ImmutableProcessConfig copyOf(ProcessConfig instance) {
        if (instance instanceof ImmutableProcessConfig) {
            return (ImmutableProcessConfig)instance;
        }
        return ImmutableProcessConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_DAEMON_PROCESS = 1L;
        private static final long OPT_BIT_STOP_TIMEOUT_IN_MILLIS = 2L;
        private long optBits;
        private boolean daemonProcess;
        private long stopTimeoutInMillis;

        private Builder() {
        }

        public final Builder from(ProcessConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.daemonProcess(instance.daemonProcess());
            this.stopTimeoutInMillis(instance.stopTimeoutInMillis());
            return this;
        }

        public final Builder daemonProcess(boolean daemonProcess) {
            this.daemonProcess = daemonProcess;
            this.optBits |= 1L;
            return this;
        }

        public final Builder stopTimeoutInMillis(long stopTimeoutInMillis) {
            this.stopTimeoutInMillis = stopTimeoutInMillis;
            this.optBits |= 2L;
            return this;
        }

        public ImmutableProcessConfig build() {
            return new ImmutableProcessConfig(this);
        }

        private boolean daemonProcessIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean stopTimeoutInMillisIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte daemonProcessBuildStage = 0;
        private boolean daemonProcess;
        private byte stopTimeoutInMillisBuildStage = 0;
        private long stopTimeoutInMillis;

        private InitShim() {
        }

        boolean daemonProcess() {
            if (this.daemonProcessBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.daemonProcessBuildStage == 0) {
                this.daemonProcessBuildStage = (byte)-1;
                this.daemonProcess = ImmutableProcessConfig.this.daemonProcessInitialize();
                this.daemonProcessBuildStage = 1;
            }
            return this.daemonProcess;
        }

        void daemonProcess(boolean daemonProcess) {
            this.daemonProcess = daemonProcess;
            this.daemonProcessBuildStage = 1;
        }

        long stopTimeoutInMillis() {
            if (this.stopTimeoutInMillisBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.stopTimeoutInMillisBuildStage == 0) {
                this.stopTimeoutInMillisBuildStage = (byte)-1;
                this.stopTimeoutInMillis = ImmutableProcessConfig.this.stopTimeoutInMillisInitialize();
                this.stopTimeoutInMillisBuildStage = 1;
            }
            return this.stopTimeoutInMillis;
        }

        void stopTimeoutInMillis(long stopTimeoutInMillis) {
            this.stopTimeoutInMillis = stopTimeoutInMillis;
            this.stopTimeoutInMillisBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.daemonProcessBuildStage == -1) {
                attributes.add("daemonProcess");
            }
            if (this.stopTimeoutInMillisBuildStage == -1) {
                attributes.add("stopTimeoutInMillis");
            }
            return "Cannot build ProcessConfig, attribute initializers form cycle " + attributes;
        }
    }
}

