/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.common.hash;

import de.greenrobot.common.PrimitiveArrayUtils;
import java.util.zip.Checksum;

public class FNVJ32
implements Checksum {
    private static PrimitiveArrayUtils primitiveArrayUtils = PrimitiveArrayUtils.getInstance();
    private static final int INITIAL_VALUE = -2128831035;
    private static final int MULTIPLIER = 16777619;
    private final int seed;
    private int hash = -2128831035;
    private int partialPos;
    private int length;

    public FNVJ32() {
        this.seed = -2128831035;
        this.hash = -2128831035;
    }

    public FNVJ32(int seed) {
        this.hash = this.seed = 0x811C9DC5 ^ seed;
    }

    @Override
    public void update(int b) {
        int xorValue = 0xFF & b;
        switch (this.partialPos) {
            case 0: {
                this.hash *= 16777619;
                xorValue <<= 24;
                this.partialPos = 1;
                break;
            }
            case 1: {
                xorValue <<= 16;
                this.partialPos = 2;
                break;
            }
            case 2: {
                xorValue <<= 8;
                this.partialPos = 3;
                break;
            }
            case 3: {
                this.partialPos = 0;
            }
        }
        this.hash ^= xorValue;
        ++this.length;
    }

    @Override
    public void update(byte[] b, int off, int len) {
        int i;
        while (this.partialPos != 0 && len > 0) {
            this.update(b[off]);
            ++off;
            --len;
        }
        int remainder = len & 3;
        int stop = off + len - remainder;
        for (i = off; i < stop; i += 4) {
            this.hash *= 16777619;
            this.hash ^= primitiveArrayUtils.getIntBE(b, i);
        }
        this.length += stop - off;
        for (i = 0; i < remainder; ++i) {
            this.update(b[stop + i]);
        }
    }

    @Override
    public long getValue() {
        int finished = this.hash * 16777619;
        finished ^= this.length;
        return (long)(finished *= 16777619) & 0xFFFFFFFFL;
    }

    @Override
    public void reset() {
        this.hash = this.seed;
        this.partialPos = 0;
        this.length = 0;
    }

    public int getLength() {
        return this.length;
    }
}

