/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;

public class Either<A, B> {
    private final Optional<A> first;
    private final Optional<B> second;

    @Deprecated
    public static <A, B> Either<A, B> of(@Nullable A first, @Nullable B second) {
        if (first == null && second == null) {
            throw new NullPointerException();
        }
        if (first != null && second != null) {
            throw new IllegalArgumentException("Two values given while expecting exactly one value.");
        }
        return new Either<A, B>(Optional.ofNullable(first), Optional.ofNullable(second));
    }

    public static <A, B> Either<A, B> ofFirst(A value) {
        return new Either(Optional.of(value), Optional.empty());
    }

    public static <A, B> Either<A, B> ofSecond(B value) {
        return new Either(Optional.empty(), Optional.of(value));
    }

    public void ifPresent(Consumer<? super A> firstConsumer, Consumer<? super B> secondConsumer) {
        this.ifFirstIsPresent(firstConsumer);
        this.ifSecondIsPresent(secondConsumer);
    }

    public void ifFirstIsPresent(Consumer<? super A> consumer) {
        this.first.ifPresent(consumer);
    }

    public void ifSecondIsPresent(Consumer<? super B> consumer) {
        this.second.ifPresent(consumer);
    }

    @Nullable
    public <T> T map(Function<? super A, ? extends T> firstFunction, Function<? super B, ? extends T> secondFunction) {
        if (this.first.isPresent()) {
            return this.first.map(firstFunction).orElseThrow(IllegalStateException::new);
        }
        return this.second.map(secondFunction).orElseThrow(IllegalStateException::new);
    }

    @Nullable
    public B mapFirst(Function<? super A, ? extends B> function) {
        return (B)this.second.orElseGet(() -> this.first.map(function).orElseThrow(IllegalStateException::new));
    }

    @Nullable
    public A mapSecond(Function<? super B, ? extends A> function) {
        return (A)this.first.orElseGet(() -> this.second.map(function).orElseThrow(IllegalStateException::new));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<A> getFirst() {
        return this.first;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<B> getSecond() {
        return this.second;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Either(first=" + this.getFirst() + ", second=" + this.getSecond() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Either)) {
            return false;
        }
        Either other = (Either)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Optional<A> this$first = this.getFirst();
        Optional<A> other$first = other.getFirst();
        if (this$first == null ? other$first != null : !((Object)this$first).equals(other$first)) {
            return false;
        }
        Optional<B> this$second = this.getSecond();
        Optional<B> other$second = other.getSecond();
        return !(this$second == null ? other$second != null : !((Object)this$second).equals(other$second));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Either;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<A> $first = this.getFirst();
        result = result * 59 + ($first == null ? 43 : ((Object)$first).hashCode());
        Optional<B> $second = this.getSecond();
        result = result * 59 + ($second == null ? 43 : ((Object)$second).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Either(Optional<A> first, Optional<B> second) {
        this.first = first;
        this.second = second;
    }
}

