/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;

public final class Nullables {
    @SafeVarargs
    @Nullable
    public static <T> T getFirst(T ... values) {
        for (T value : values) {
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    public static <T> T getFirst(Supplier<? extends T> ... suppliers) {
        for (Supplier<T> supplier : suppliers) {
            T value = supplier.get();
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static <T> void ifNonNull(@Nullable T value, Consumer<? super T> consumer) {
        if (value != null) {
            consumer.accept(value);
        }
    }

    public static <T> void ifNonNullOrElse(@Nullable T value, Consumer<? super T> action, Runnable emptyAction) {
        if (value == null) {
            emptyAction.run();
        } else {
            action.accept(value);
        }
    }

    @Nullable
    public static <T, U> U map(@Nullable T value, Function<? super T, ? extends U> mapper) {
        return value == null ? null : (U)mapper.apply((T)value);
    }

    @Nullable
    public static <T> T or(@Nullable T value, Supplier<? extends T> supplier) {
        return value == null ? supplier.get() : value;
    }

    public static <T> T orElse(@Nullable T value, T other) {
        return value == null ? other : value;
    }

    public static <T> T orElseGet(@Nullable T value, Supplier<? extends T> other) {
        return value == null ? other.get() : value;
    }

    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="nullable vs. non-null by design")
    public static <T> T orElseThrow(@Nullable T value) {
        return Objects.requireNonNull(value);
    }

    @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE"}, justification="this is the way orElseThrow works")
    public static <T, X extends Throwable> T orElseThrow(@Nullable T value, Supplier<? extends X> exceptionSupplier) throws X {
        if (value == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        return value;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Nullables() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

