/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils;

import de.larssh.utils.function.DoubleToDoubleFunction;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.stream.DoubleStream;
import lombok.Generated;

public final class OptionalDoubles {
    public static final DoublePredicate IS_NEGATIVE = value -> value < 0.0;
    public static final DoublePredicate IS_NEGATIVE_OR_ZERO = value -> value <= 0.0;
    public static final DoublePredicate IS_POSITIVE = value -> value > 0.0;
    public static final DoublePredicate IS_POSITIVE_OR_ZERO = value -> value >= 0.0;

    public static Optional<Double> boxed(OptionalDouble optional) {
        return optional.isPresent() ? Optional.ofNullable(optional.getAsDouble()) : Optional.empty();
    }

    public static OptionalDouble filter(OptionalDouble optional, DoublePredicate predicate) {
        return optional.isPresent() && predicate.test(optional.getAsDouble()) ? optional : OptionalDouble.empty();
    }

    public static OptionalDouble flatMap(OptionalDouble optional, DoubleFunction<OptionalDouble> mapper) {
        return optional.isPresent() ? mapper.apply(optional.getAsDouble()) : OptionalDouble.empty();
    }

    public static OptionalInt flatMapToInt(OptionalDouble optional, DoubleFunction<OptionalInt> mapper) {
        return optional.isPresent() ? mapper.apply(optional.getAsDouble()) : OptionalInt.empty();
    }

    public static OptionalLong flatMapToLong(OptionalDouble optional, DoubleFunction<OptionalLong> mapper) {
        return optional.isPresent() ? mapper.apply(optional.getAsDouble()) : OptionalLong.empty();
    }

    public static <T> Optional<T> flatMapToObj(OptionalDouble optional, DoubleFunction<Optional<T>> mapper) {
        return optional.isPresent() ? mapper.apply(optional.getAsDouble()) : Optional.empty();
    }

    public static OptionalDouble map(OptionalDouble optional, DoubleToDoubleFunction mapper) {
        return optional.isPresent() ? OptionalDouble.of(mapper.applyAsDouble(optional.getAsDouble())) : OptionalDouble.empty();
    }

    public static OptionalInt mapToInt(OptionalDouble optional, DoubleToIntFunction mapper) {
        return optional.isPresent() ? OptionalInt.of(mapper.applyAsInt(optional.getAsDouble())) : OptionalInt.empty();
    }

    public static OptionalLong mapToLong(OptionalDouble optional, DoubleToLongFunction mapper) {
        return optional.isPresent() ? OptionalLong.of(mapper.applyAsLong(optional.getAsDouble())) : OptionalLong.empty();
    }

    public static <T> Optional<T> mapToObj(OptionalDouble optional, DoubleFunction<T> mapper) {
        return optional.isPresent() ? Optional.ofNullable(mapper.apply(optional.getAsDouble())) : Optional.empty();
    }

    public static OptionalDouble ofNon(DoublePredicate isEmpty, double value) {
        return isEmpty.test(value) ? OptionalDouble.empty() : OptionalDouble.of(value);
    }

    public static OptionalDouble ofNullable(@Nullable Double value) {
        return value == null ? OptionalDouble.empty() : OptionalDouble.of(value);
    }

    @SafeVarargs
    public static DoubleStream stream(OptionalDouble ... optionals) {
        return Arrays.stream(optionals).filter(OptionalDouble::isPresent).mapToDouble(OptionalDouble::getAsDouble);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private OptionalDoubles() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

