/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.collection;

import de.larssh.utils.collection.PeekableIterator;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;

public final class Iterators {
    public static <E> PeekableIterator<E> iterator(Function<ElementsSupplierStateHandler<E>, E> elementsSupplier) {
        return new ElementsSupplierIterator<E>(elementsSupplier);
    }

    public static <E> PeekableIterator<E> peekableIterator(Iterator<E> iterator) {
        if (iterator instanceof PeekableIterator) {
            return (PeekableIterator)iterator;
        }
        return Iterators.iterator(state -> iterator.hasNext() ? iterator.next() : state.endOfData());
    }

    public static <E> Stream<E> stream(Function<ElementsSupplierStateHandler<E>, E> elementsSupplier) {
        return Iterators.stream(Iterators.iterator(elementsSupplier));
    }

    public static <E> Stream<E> stream(Iterator<E> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Iterators() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface ElementsSupplierStateHandler<E> {
        @Nullable
        public E endOfData();
    }

    private static enum ElementsSupplierState {
        CALL_FOR_NEXT,
        END_OF_DATA,
        PEEKED;

    }

    private static class ElementsSupplierIterator<E>
    implements PeekableIterator<E> {
        private final Function<ElementsSupplierStateHandler<E>, E> elementsSupplier;
        @Nullable
        private E peekedElement = null;
        private ElementsSupplierState state = ElementsSupplierState.CALL_FOR_NEXT;
        private final ElementsSupplierStateHandler<E> stateHandler = () -> {
            this.state = ElementsSupplierState.END_OF_DATA;
            return null;
        };

        @Override
        public final boolean hasNext() {
            if (this.state == ElementsSupplierState.CALL_FOR_NEXT) {
                this.peekedElement = this.elementsSupplier.apply(this.stateHandler);
                if (this.state == ElementsSupplierState.CALL_FOR_NEXT) {
                    this.state = ElementsSupplierState.PEEKED;
                }
            }
            return this.state == ElementsSupplierState.PEEKED;
        }

        @Override
        @Nullable
        public final E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            E next = this.peekedElement;
            this.state = ElementsSupplierState.CALL_FOR_NEXT;
            this.peekedElement = null;
            return next;
        }

        @Override
        @Nullable
        public E peek() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.peekedElement;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ElementsSupplierIterator(Function<ElementsSupplierStateHandler<E>, E> elementsSupplier) {
            this.elementsSupplier = elementsSupplier;
        }
    }
}

