/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.collection;

import de.larssh.utils.Collectors;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;

public final class Maps {
    public static <K, V> Builder<K, V> builder() {
        return Maps.builder(new HashMap());
    }

    public static <K, V> Builder<K, V> builder(Map<K, V> map) {
        return new Builder<K, V>(map);
    }

    public static <K, V> Map.Entry<K, V> entry(@Nullable K key, @Nullable V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    public static <K, V> Map<K, V> sort(Map<K, V> unsorted, Comparator<Map.Entry<K, V>> comparator) {
        return unsorted.entrySet().stream().sorted(comparator).collect(Collectors.toLinkedHashMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Maps() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class Builder<K, V> {
        private final Map<K, V> map;

        public Builder<K, V> clear() {
            this.get().clear();
            return this;
        }

        public Builder<K, V> compute(@Nullable K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            this.get().compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
            return this;
        }

        public Builder<K, V> computeIfAbsent(@Nullable K key, Function<? super K, ? extends V> mappingFunction) {
            this.get().computeIfAbsent((K)key, mappingFunction);
            return this;
        }

        public Builder<K, V> computeIfPresent(@Nullable K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            this.get().computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
            return this;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="This builder is meant to return the internal modifiable map.")
        public Map<K, V> get() {
            return this.map;
        }

        public Builder<K, V> merge(@Nullable K key, @Nullable V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            this.get().merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
            return this;
        }

        public Builder<K, V> put(@Nullable K key, @Nullable V value) {
            this.get().put(key, value);
            return this;
        }

        public Builder<K, V> putAll(Map<? extends K, ? extends V> map) {
            this.get().putAll(map);
            return this;
        }

        public Builder<K, V> putIfAbsent(@Nullable K key, @Nullable V value) {
            this.get().putIfAbsent(key, value);
            return this;
        }

        public Builder<K, V> remove(@Nullable K key) {
            this.get().remove(key);
            return this;
        }

        public Builder<K, V> remove(@Nullable K key, @Nullable V value) {
            this.get().remove(key, value);
            return this;
        }

        public Builder<K, V> replace(@Nullable K key, @Nullable V value) {
            this.get().replace(key, value);
            return this;
        }

        public Builder<K, V> replace(@Nullable K key, @Nullable V oldValue, @Nullable V newValue) {
            this.get().replace(key, oldValue, newValue);
            return this;
        }

        public Builder<K, V> replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            this.get().replaceAll(function);
            return this;
        }

        public Map<K, V> unmodifiable() {
            return Collections.unmodifiableMap(this.get());
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        Builder(Map<K, V> map) {
            this.map = map;
        }
    }
}

