/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.collection;

import de.larssh.utils.collection.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import lombok.Generated;

public final class Streams {
    public static <T> Stream<Map.Entry<Integer, T>> indexed(Stream<T> stream) {
        AtomicInteger nextIndex = new AtomicInteger(0);
        return stream.map(value -> {
            int index = nextIndex.getAndUpdate(i -> {
                if (i < 0) {
                    throw new ArithmeticException("Stream index overflow");
                }
                return i + 1;
            });
            return Maps.entry(index, value);
        });
    }

    public static <T> Stream<Map.Entry<Long, T>> indexedLong(Stream<T> stream) {
        AtomicLong nextIndex = new AtomicLong(0L);
        return stream.map(value -> {
            long index = nextIndex.getAndUpdate(i -> {
                if (i < 0L) {
                    throw new ArithmeticException("Stream index of type long overflow");
                }
                return i + 1L;
            });
            return Maps.entry(index, value);
        });
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Streams() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

