/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.dom;

import de.larssh.utils.dom.NodeLists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Optional;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import lombok.Generated;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XPathExpressions {
    public static boolean getBoolean(Node node, XPathExpression expression) throws XPathExpressionException {
        return (Boolean)expression.evaluate(node, XPathConstants.BOOLEAN);
    }

    public static <T extends Node> Optional<T> getNode(Node node, XPathExpression expression) throws XPathExpressionException {
        return Optional.ofNullable((Node)expression.evaluate(node, XPathConstants.NODE));
    }

    public static <T extends Node> List<T> getNodes(Node node, XPathExpression expression) throws XPathExpressionException {
        return NodeLists.asList(XPathExpressions.getNodeList(node, expression));
    }

    public static NodeList getNodeList(Node node, XPathExpression expression) throws XPathExpressionException {
        return (NodeList)expression.evaluate(node, XPathConstants.NODESET);
    }

    public static double getNumber(Node node, XPathExpression expression) throws XPathExpressionException {
        return (Double)expression.evaluate(node, XPathConstants.NUMBER);
    }

    public static String getString(Node node, XPathExpression expression) throws XPathExpressionException {
        return (String)expression.evaluate(node, XPathConstants.STRING);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private XPathExpressions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

