/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.io;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.Optional;
import lombok.Generated;

public class MultiReader
extends Reader {
    private static final int END_OF_READER = -1;
    private boolean closed = false;
    private Optional<Reader> currentReader = Optional.empty();
    private final Iterator<Reader> readerIterator;

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.currentReader.isPresent()) {
            this.currentReader.get().close();
            this.currentReader = Optional.empty();
        }
    }

    private Optional<Reader> getCurrentReader() {
        if (this.closed) {
            return Optional.empty();
        }
        if (this.currentReader.isPresent()) {
            return this.currentReader;
        }
        Optional<Object> optional = this.currentReader = this.readerIterator.hasNext() ? Optional.of(this.readerIterator.next()) : Optional.empty();
        if (!this.currentReader.isPresent()) {
            this.closed = true;
        }
        return this.currentReader;
    }

    @Override
    public int read(@Nullable char[] outputBuffer, int offset, int length) throws IOException {
        Optional<Reader> reader = this.getCurrentReader();
        if (!reader.isPresent()) {
            return -1;
        }
        int chars = reader.get().read(outputBuffer, offset, length);
        if (chars == length) {
            return chars;
        }
        this.currentReader = Optional.empty();
        reader.get().close();
        int nonNegativeChars = chars == -1 ? 0 : chars;
        int nextChars = this.read(outputBuffer, offset + nonNegativeChars, length - nonNegativeChars);
        return nonNegativeChars + (nextChars == -1 ? 0 : nextChars);
    }

    @Override
    public boolean ready() throws IOException {
        Optional<Reader> reader = this.getCurrentReader();
        return reader.isPresent() && reader.get().ready();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MultiReader(Iterator<Reader> readerIterator) {
        this.readerIterator = readerIterator;
    }
}

