/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.io;

import de.larssh.utils.Nullables;
import de.larssh.utils.SystemUtils;
import de.larssh.utils.annotations.PackagePrivate;
import de.larssh.utils.text.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.nio.file.Paths;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;

public final class ProcessBuilders {
    private static final Pattern UNIX_BACKSLASH_SPECIAL_MEANING_CHARACTER_PATTERN = Pattern.compile("[\r\n!\"$\\\\`]");
    private static final Pattern UNIX_SAFE_ARGUMENT_PATTERN = Pattern.compile("[-.0-9A-Z_a-z]+");
    private static final Pattern WINDOWS_DOUBLE_QUOTE_PATTERN = Pattern.compile("\"");
    private static final Pattern WINDOWS_SPACE_CHARACTER_PATTERN = Pattern.compile("[ \t\n\u000b]");

    private static void appendRedirect(StringBuilder builder, String operation, File file) {
        String normalizedPath = file.toPath().toAbsolutePath().normalize().toString();
        builder.append(' ').append(operation).append(' ').append(SystemUtils.isWindows() ? ProcessBuilders.escapeArgumentOnWindows(normalizedPath) : ProcessBuilders.escapeArgumentOnUnix(normalizedPath));
    }

    private static void appendRedirects(StringBuilder builder, ProcessBuilder processBuilder) {
        ProcessBuilder.Redirect output;
        ProcessBuilder.Redirect input = processBuilder.redirectInput();
        if (input.type() == ProcessBuilder.Redirect.Type.READ && input.file() != null) {
            ProcessBuilders.appendRedirect(builder, "<", input.file());
        }
        if ((output = processBuilder.redirectOutput()).type() == ProcessBuilder.Redirect.Type.APPEND && output.file() != null) {
            ProcessBuilders.appendRedirect(builder, ">>", output.file());
        } else if (output.type() == ProcessBuilder.Redirect.Type.WRITE && output.file() != null) {
            ProcessBuilders.appendRedirect(builder, ">", output.file());
        }
        if (processBuilder.redirectErrorStream()) {
            builder.append(" 2>&1");
        } else {
            ProcessBuilder.Redirect error = processBuilder.redirectError();
            if (error.type() == ProcessBuilder.Redirect.Type.APPEND && error.file() != null) {
                ProcessBuilders.appendRedirect(builder, "2>>", error.file());
            } else if (error.type() == ProcessBuilder.Redirect.Type.WRITE && error.file() != null) {
                ProcessBuilders.appendRedirect(builder, "2>", error.file());
            }
        }
    }

    @PackagePrivate
    static String escapeArgumentOnUnix(String argument) {
        if (Strings.matches(argument, UNIX_SAFE_ARGUMENT_PATTERN)) {
            return argument;
        }
        return '\"' + Strings.replaceAll(argument, UNIX_BACKSLASH_SPECIAL_MEANING_CHARACTER_PATTERN, "\\\\$0") + '\"';
    }

    @PackagePrivate
    static String escapeArgumentOnWindows(String argument) {
        int index;
        boolean quote;
        StringBuffer buffer = new StringBuffer();
        boolean bl = quote = argument.isEmpty() || Strings.find(argument, WINDOWS_SPACE_CHARACTER_PATTERN);
        if (quote) {
            buffer.append('\"');
        }
        Matcher matcher = WINDOWS_DOUBLE_QUOTE_PATTERN.matcher(argument);
        while (matcher.find()) {
            matcher.appendReplacement(buffer, "");
            for (index = buffer.length() - 1; index > -1 && buffer.charAt(index) == '\\'; --index) {
                buffer.append('\\');
            }
            buffer.append("\\\"");
        }
        matcher.appendTail(buffer);
        if (quote) {
            for (index = buffer.length() - 1; index > -1 && buffer.charAt(index) == '\\'; --index) {
                buffer.append('\\');
            }
            buffer.append('\"');
        }
        return buffer.toString();
    }

    public static String toCommandLine(ProcessBuilder processBuilder, boolean prependWorkingDirectory) {
        StringBuilder builder = new StringBuilder();
        if (prependWorkingDirectory) {
            builder.append(Nullables.orElseGet(processBuilder.directory(), () -> Paths.get(".", new String[0]).toAbsolutePath().normalize().toString())).append("> ");
        }
        UnaryOperator escapeArgument = SystemUtils.isWindows() ? ProcessBuilders::escapeArgumentOnWindows : ProcessBuilders::escapeArgumentOnUnix;
        builder.append(processBuilder.command().stream().map(escapeArgument).collect(Collectors.joining(" ")));
        ProcessBuilders.appendRedirects(builder, processBuilder);
        return builder.toString();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private ProcessBuilders() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

