/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.maven;

import de.larssh.utils.Nullables;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import lombok.Generated;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.repository.Proxy;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.eclipse.aether.util.repository.AuthenticationBuilder;

public final class AetherUtils {
    public static RemoteRepository convert(ArtifactRepository mavenRepository) {
        ArtifactRepository r = mavenRepository;
        return new RemoteRepository.Builder(r.getId(), r.getLayout().getId(), r.getUrl()).setAuthentication(AetherUtils.convert(r.getAuthentication())).setProxy(AetherUtils.convert(r.getProxy())).setReleasePolicy(AetherUtils.convert(r.getReleases())).setSnapshotPolicy(AetherUtils.convert(r.getSnapshots())).build();
    }

    @Nullable
    public static RepositoryPolicy convert(@Nullable ArtifactRepositoryPolicy mavenPolicy) {
        return Nullables.map(mavenPolicy, p -> new RepositoryPolicy(p.isEnabled(), p.getUpdatePolicy(), p.getChecksumPolicy()));
    }

    @Nullable
    public static org.eclipse.aether.repository.Authentication convert(@Nullable Authentication mavenAuthentication) {
        return Nullables.map(mavenAuthentication, a -> new AuthenticationBuilder().addPassword(a.getPassword()).addUsername(a.getUsername()).build());
    }

    @Nullable
    public static org.eclipse.aether.repository.Proxy convert(@Nullable Proxy mavenProxy) {
        if (mavenProxy == null) {
            return null;
        }
        org.eclipse.aether.repository.Authentication authentication = new AuthenticationBuilder().addHostnameVerifier(AetherUtils.createHostnameVerifier(mavenProxy.getNonProxyHosts())).addNtlm(mavenProxy.getNtlmHost(), mavenProxy.getNtlmDomain()).addPassword(mavenProxy.getPassword()).addUsername(mavenProxy.getUserName()).build();
        return new org.eclipse.aether.repository.Proxy(mavenProxy.getProtocol(), mavenProxy.getHost(), mavenProxy.getPort(), authentication);
    }

    @Nullable
    private static HostnameVerifier createHostnameVerifier(@Nullable String nonProxyHosts) {
        if (nonProxyHosts == null) {
            return null;
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            patterns.add(Pattern.compile(token.replace(".", "\\.").replace("*", ".*"), 2));
        }
        return (hostname, session) -> patterns.stream().noneMatch(pattern -> pattern.matcher(hostname).matches());
    }

    public static String getClassPath(DependencyResult dependencyResult) {
        PreorderNodeListGenerator preorderNodeListGenerator = new PreorderNodeListGenerator();
        dependencyResult.getRoot().accept((DependencyVisitor)preorderNodeListGenerator);
        return preorderNodeListGenerator.getClassPath();
    }

    public static List<RemoteRepository> getRemoteRepositories(MavenSession mavenSession) {
        return mavenSession.getRequest().getRemoteRepositories().stream().map(AetherUtils::convert).collect(Collectors.toList());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private AetherUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

