/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.net;

import de.larssh.utils.Nullables;
import de.larssh.utils.text.SplitLimit;
import de.larssh.utils.text.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

public class GlobalProxyConfiguration {
    private static final Collection<String> NO_PROXY_HOSTS_DEFAULT = Arrays.asList("localhost", "127.*", "[::1]");
    public static final GlobalProxyConfiguration FTP = new GlobalProxyConfiguration("FTP", Proxy.Type.HTTP, 80, "ftp.proxyHost", "ftp.proxyPort", Optional.of("ftp.nonProxyHosts"), Optional.of(NO_PROXY_HOSTS_DEFAULT));
    public static final GlobalProxyConfiguration HTTP = new GlobalProxyConfiguration("HTTP", Proxy.Type.HTTP, 80, "http.proxyHost", "http.proxyPort", Optional.of("http.nonProxyHosts"), Optional.of(NO_PROXY_HOSTS_DEFAULT));
    public static final GlobalProxyConfiguration HTTPS = new GlobalProxyConfiguration("HTTPS", Proxy.Type.HTTP, 443, "https.proxyHost", "https.proxyPort", Optional.empty(), Optional.empty());
    public static final GlobalProxyConfiguration SOCKS = new GlobalProxyConfiguration("SOCKS", Proxy.Type.SOCKS, 1080, "socksProxyHost", "socksProxyPort", Optional.empty(), Optional.empty());
    private final String name;
    private final Proxy.Type type;
    private final int defaultPort;
    private final String hostProperty;
    private final String portProperty;
    private final Optional<String> nonProxyHostsProperty;
    private final Optional<Collection<String>> defaultNonProxyHosts;

    public void addNonProxyHosts(String ... nonProxyHosts) {
        Set<String> set = this.getNonProxyHosts();
        set.addAll(Arrays.asList(nonProxyHosts));
        this.setNonProxyHosts(set);
    }

    public Set<String> getNonProxyHosts() {
        return new LinkedHashSet<String>(Arrays.asList(Nullables.orElse(System.getProperty(this.getNonProxyHostsPropertyOrThrow()), "").split("\\|", SplitLimit.NO_LIMIT_AND_STRIP_EMPTY_TRAILING)));
    }

    protected String getNonProxyHostsPropertyOrThrow() {
        return this.getNonProxyHostsProperty().orElseThrow(() -> new UnsupportedOperationException(Strings.format("The protocol %s does not support the nonProxyHosts property.", this.getName())));
    }

    public void removeNonProxyHosts(String ... nonProxyHosts) {
        Set<String> set = this.getNonProxyHosts();
        set.removeAll(Arrays.asList(nonProxyHosts));
        this.setNonProxyHosts(set);
    }

    public void resetNonProxyHosts() {
        this.setNonProxyHosts(this.getDefaultNonProxyHosts().orElseGet(Collections::emptyList));
    }

    public void setGlobalProxy(InetSocketAddress inetSocketAddress) {
        System.setProperty(this.getHostProperty(), inetSocketAddress.getHostString());
        System.setProperty(this.getPortProperty(), Integer.toString(inetSocketAddress.getPort()));
    }

    public void setNonProxyHosts(Collection<String> nonProxyHosts) {
        System.setProperty(this.getNonProxyHostsPropertyOrThrow(), String.join((CharSequence)"|", nonProxyHosts));
    }

    public void unsetGlobalProxy() {
        System.clearProperty(this.getHostProperty());
        System.clearProperty(this.getPortProperty());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Proxy.Type getType() {
        return this.type;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getDefaultPort() {
        return this.defaultPort;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getHostProperty() {
        return this.hostProperty;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPortProperty() {
        return this.portProperty;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<String> getNonProxyHostsProperty() {
        return this.nonProxyHostsProperty;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<Collection<String>> getDefaultNonProxyHosts() {
        return this.defaultNonProxyHosts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected GlobalProxyConfiguration(String name, Proxy.Type type, int defaultPort, String hostProperty, String portProperty, Optional<String> nonProxyHostsProperty, Optional<Collection<String>> defaultNonProxyHosts) {
        this.name = name;
        this.type = type;
        this.defaultPort = defaultPort;
        this.hostProperty = hostProperty;
        this.portProperty = portProperty;
        this.nonProxyHostsProperty = nonProxyHostsProperty;
        this.defaultNonProxyHosts = defaultNonProxyHosts;
    }
}

