/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.net;

import de.larssh.utils.SneakyException;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Optional;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import lombok.Generated;

public final class SecureConnections {
    public static Optional<HttpsURLConnection> getHttpsUrlConnection(URLConnection connection) {
        return connection instanceof HttpsURLConnection ? Optional.of((HttpsURLConnection)connection) : Optional.empty();
    }

    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CONSTRAINTS"}, justification="converting checked to unchecked exceptions that must not be thrown")
    public static KeyManager[] getKeyManagers(KeyStore keyStore, String password) throws UnrecoverableKeyException {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, password.toCharArray());
            return keyManagerFactory.getKeyManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new SneakyException(e);
        }
    }

    @SuppressFBWarnings(value={"UVA_USE_VAR_ARGS"}, justification="var args make no sense as KeyManager is handled as array regularly")
    public static SSLSocketFactory getSocketFactory(KeyManager[] keyManagers) {
        return SecureConnections.getSocketFactory(keyManagers, null);
    }

    @SuppressFBWarnings(value={"UVA_USE_VAR_ARGS"}, justification="var args make no sense as TrustManager is handled as array regularly")
    public static SSLSocketFactory getSocketFactory(TrustManager[] trustManagers) {
        return SecureConnections.getSocketFactory(null, trustManagers);
    }

    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CONSTRAINTS"}, justification="converting checked to unchecked exceptions that must not be thrown")
    public static SSLSocketFactory getSocketFactory(@Nullable KeyManager[] keyManagers, @Nullable TrustManager[] trustManagers) {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManagers, trustManagers, null);
            return context.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new SneakyException(e);
        }
    }

    public static SSLSocketFactory getSocketFactoryTrusting(Path jksFilePath, String password) throws CertificateException, IOException {
        return SecureConnections.getSocketFactory(SecureConnections.getTrustManagers(SecureConnections.loadKeyStore(jksFilePath, password)));
    }

    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CONSTRAINTS"}, justification="converting checked to unchecked exceptions that must not be thrown")
    public static TrustManager[] getTrustManagers(KeyStore keyStore) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new SneakyException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CONSTRAINTS"}, justification="converting checked to unchecked exceptions that must not be thrown")
    public static KeyStore loadKeyStore(Path jksFilePath, String password) throws CertificateException, IOException {
        try (InputStream inputStream = Files.newInputStream(jksFilePath, new OpenOption[0]);){
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(inputStream, password.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new SneakyException(e);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private SecureConnections() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

