/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.text;

import de.larssh.utils.Finals;
import de.larssh.utils.Nullables;
import de.larssh.utils.collection.ProxiedList;
import de.larssh.utils.text.CsvParser;
import de.larssh.utils.text.CsvRow;
import de.larssh.utils.text.StringConverters;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class Csv
extends ProxiedList<CsvRow> {
    public static final char DEFAULT_ESCAPER = Finals.constant(Character.valueOf('\"')).charValue();
    public static final char DEFAULT_SEPARATOR = Finals.constant(Character.valueOf(',')).charValue();
    private boolean modifiable = true;

    public static Csv parse(Reader reader, char separator, char escaper) throws IOException {
        return new CsvParser(separator, escaper).parse(reader);
    }

    public Csv() {
        super(new ArrayList());
    }

    public Csv(int initialCapacity) {
        super(new ArrayList(initialCapacity));
    }

    @SuppressFBWarnings(value={"PCOA_PARTIALLY_CONSTRUCTED_OBJECT_ACCESS"}, justification="passing this object to CsvRow constructor shouldn't be a problem")
    public Csv(List<? extends List<String>> data) {
        this(data.size());
        for (List<String> list : Nullables.orElseThrow(data)) {
            super.add(new CsvRow(this, super.size(), Nullables.orElseThrow(list)));
        }
    }

    @Override
    public boolean add(@Nullable CsvRow element) {
        return this.add((List<String>)Nullables.orElseThrow(element));
    }

    @Override
    public boolean add(List<String> element) {
        return super.add(new CsvRow(this, this.size(), element));
    }

    @Override
    public void add(int index, @Nullable CsvRow element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(@Nullable Collection<? extends CsvRow> collection) {
        return this.addAllList(Nullables.orElseThrow(collection));
    }

    @Override
    public boolean addAll(int index, @Nullable Collection<? extends CsvRow> collection) {
        throw new UnsupportedOperationException();
    }

    public boolean addAllList(Collection<? extends List<String>> collection) {
        boolean modified = false;
        for (List<String> list : collection) {
            modified |= this.add(list);
        }
        return modified;
    }

    @Override
    @NonNull
    public CsvRow get(int index) {
        return (CsvRow)this.getWrappedForRead().get(index);
    }

    public List<String> getHeaders() {
        return this.isEmpty() ? Collections.emptyList() : this.get(0);
    }

    @Override
    @NonNull
    public CsvRow remove(int index) {
        if (index == this.size() - 1) {
            return (CsvRow)Nullables.orElseThrow(super.remove(index));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public CsvRow set(int index, @Nullable CsvRow element) {
        return this.getWrappedIfModifiable().set(index, new CsvRow(this, index, Nullables.orElseThrow(element)));
    }

    @Override
    public String toString() {
        return this.toString(DEFAULT_SEPARATOR, DEFAULT_ESCAPER);
    }

    public String toString(char separator, char escaper) {
        return StringConverters.encodeCsv(this, separator, escaper);
    }

    public Csv unmodifiable() {
        this.modifiable = false;
        return this;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isModifiable() {
        return this.modifiable;
    }
}

